/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorMerge;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorState;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorStatistics;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorStop;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorTransferRelation;

public class MonitorCPA
extends AbstractSingleWrapperCPA {
    private final AbstractDomain abstractDomain = new FlatLatticeDomain();
    private final MonitorTransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final Statistics stats;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(MonitorCPA.class);
    }

    private MonitorCPA(ConfigurableProgramAnalysis pCpa, Configuration config) throws InvalidConfigurationException {
        super(pCpa);
        this.transferRelation = new MonitorTransferRelation(this.getWrappedCpa(), config);
        this.precisionAdjustment = new MonitorPrecisionAdjustment(this.getWrappedCpa().getPrecisionAdjustment());
        this.mergeOperator = new MonitorMerge(this.getWrappedCpa());
        this.stopOperator = new MonitorStop(this.getWrappedCpa());
        this.stats = new MonitorStatistics(this);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new MonitorState(this.getWrappedCpa().getInitialState(pNode, pPartition), 0L);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public MonitorTransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        super.collectStatistics(pStatsCollection);
    }
}

