/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;

public class MonitorPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecAdjustment;
    final Timer totalTimeOfPrecAdj = new Timer();

    public MonitorPrecisionAdjustment(PrecisionAdjustment pWrappedPrecAdjustment) {
        this.wrappedPrecAdjustment = pWrappedPrecAdjustment;
    }

    @Override
    public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pElement, Precision oldPrecision, UnmodifiableReachedSet pElements, AbstractState fullState) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pElement instanceof MonitorState));
        MonitorState element = (MonitorState)pElement;
        if (element.getWrappedState() == MonitorState.TimeoutState.INSTANCE) {
            return PrecisionAdjustment.PrecisionAdjustmentResult.create(pElement, oldPrecision, PrecisionAdjustment.Action.CONTINUE);
        }
        UnmodifiableReachedSetView elements = new UnmodifiableReachedSetView(pElements, MonitorState.getUnwrapFunction(), (Function<? super Precision, Precision>)Functions.identity());
        AbstractState oldElement = element.getWrappedState();
        this.totalTimeOfPrecAdj.start();
        PrecisionAdjustment.PrecisionAdjustmentResult unwrappedResult = this.wrappedPrecAdjustment.prec(oldElement, oldPrecision, elements, fullState);
        this.totalTimeOfPrecAdj.stop();
        long totalTimeOfExecution = this.totalTimeOfPrecAdj.getLengthOfLastInterval().asMillis();
        long updatedTotalTime = totalTimeOfExecution + element.getTotalTimeOnPath();
        Pair<PreventingHeuristic, Long> preventingCondition = element.getPreventingCondition();
        MonitorState resultElement = new MonitorState(unwrappedResult.abstractState(), updatedTotalTime, preventingCondition);
        return unwrappedResult.withAbstractState(resultElement);
    }
}

