/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class MonitorState
extends AbstractSingleWrapperState
implements AvoidanceReportingState {
    private static final long serialVersionUID = -559038737L;
    private final long totalTimeOnPath;
    private final Pair<PreventingHeuristic, Long> preventingCondition;

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    protected MonitorState(AbstractState pWrappedState, long totalTimeOnPath) {
        this(pWrappedState, totalTimeOnPath, null);
    }

    protected MonitorState(AbstractState pWrappedState, long totalTimeOnPath, Pair<PreventingHeuristic, Long> preventingCondition) {
        super(pWrappedState);
        Preconditions.checkArgument((!(pWrappedState instanceof MonitorState) ? 1 : 0) != 0, (Object)"Don't wrap a MonitorCPA in a MonitorCPA, this makes no sense!");
        Preconditions.checkArgument((pWrappedState != TimeoutState.INSTANCE || preventingCondition != null ? 1 : 0) != 0, (Object)"Need a preventingCondition in case of TimeoutState");
        this.totalTimeOnPath = totalTimeOnPath;
        this.preventingCondition = preventingCondition;
    }

    public long getTotalTimeOnPath() {
        return this.totalTimeOnPath;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof MonitorState) {
            MonitorState otherElem = (MonitorState)pObj;
            return this.getWrappedState().equals(otherElem.getWrappedState());
        }
        return false;
    }

    public int hashCode() {
        return this.getWrappedState().hashCode();
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.preventingCondition != null;
    }

    Pair<PreventingHeuristic, Long> getPreventingCondition() {
        return this.preventingCondition;
    }

    @Override
    public String toString() {
        return "Total time: " + this.totalTimeOnPath + " Wrapped elem: " + this.getWrappedStates();
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView manager) {
        if (this.mustDumpAssumptionForAvoidance()) {
            return ((PreventingHeuristic)((Object)this.preventingCondition.getFirst())).getFormula(manager, (Long)this.preventingCondition.getSecond());
        }
        BooleanFormulaManagerView bfmgr = manager.getBooleanFormulaManager();
        return bfmgr.makeBoolean(true);
    }

    static enum TimeoutState implements AbstractState
    {
        INSTANCE;


        public String toString() {
            return "Dummy element because computation timed out";
        }
    }
}

