/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.concurrency.Threads;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;

@Options(prefix="cpa.monitor")
public class MonitorTransferRelation
extends SingleEdgeTransferRelation {
    long maxTotalTimeForPath = 0L;
    final Timer totalTimeOfTransfer = new Timer();
    @Option(secure=true, name="limit", description="time limit for a single post computation (use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private long timeLimit = 0L;
    @Option(secure=true, name="pathcomputationlimit", description="time limit for all computations on a path in milliseconds (use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private long timeLimitForPath = 0L;
    private final TransferRelation transferRelation;
    private final ExecutorService executor;

    public MonitorTransferRelation(ConfigurableProgramAnalysis pWrappedCPA, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.transferRelation = pWrappedCPA.getTransferRelation();
        this.executor = this.timeLimit == 0L ? null : Executors.newSingleThreadExecutor(Threads.threadFactoryBuilder().setDaemon(true).build());
    }

    public Collection<MonitorState> getAbstractSuccessorsForEdge(AbstractState pElement, final Precision pPrecision, final CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> successors;
        final MonitorState element = (MonitorState)pElement;
        if (element.getWrappedState() == MonitorState.TimeoutState.INSTANCE) {
            return Collections.emptySet();
        }
        this.totalTimeOfTransfer.start();
        TransferCallable tc = new TransferCallable(){

            @Override
            public Collection<? extends AbstractState> call() throws CPATransferException, InterruptedException {
                assert (!(element.getWrappedState() instanceof MonitorState)) : element;
                return MonitorTransferRelation.this.transferRelation.getAbstractSuccessorsForEdge(element.getWrappedState(), pPrecision, pCfaEdge);
            }
        };
        Pair preventingCondition = null;
        if (this.timeLimit == 0L) {
            successors = tc.call();
        } else {
            Future<Collection<? extends AbstractState>> future = this.executor.submit(tc);
            try {
                successors = future.get(this.timeLimit, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                preventingCondition = Pair.of((Object)((Object)PreventingHeuristic.SUCCESSORCOMPTIME), (Object)this.timeLimit);
                successors = Collections.singleton(MonitorState.TimeoutState.INSTANCE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                preventingCondition = Pair.of((Object)((Object)PreventingHeuristic.SUCCESSORCOMPTIME), (Object)this.timeLimit);
                successors = Collections.singleton(MonitorState.TimeoutState.INSTANCE);
            }
            catch (ExecutionException e) {
                Throwables.propagateIfPossible((Throwable)e.getCause(), CPATransferException.class);
                throw new Classes.UnexpectedCheckedException("transfer relation", e.getCause());
            }
        }
        this.totalTimeOfTransfer.stop();
        long timeOfExecution = this.totalTimeOfTransfer.getLengthOfLastInterval().asMillis();
        long totalTimeOnPath = element.getTotalTimeOnPath() + timeOfExecution;
        if (totalTimeOnPath > this.maxTotalTimeForPath) {
            this.maxTotalTimeForPath = totalTimeOnPath;
        }
        if (successors.isEmpty()) {
            return Collections.emptySet();
        }
        if (preventingCondition == null && this.timeLimitForPath > 0L && totalTimeOnPath > this.timeLimitForPath) {
            preventingCondition = Pair.of((Object)((Object)PreventingHeuristic.PATHCOMPTIME), (Object)this.timeLimitForPath);
        }
        ArrayList<MonitorState> wrappedSuccessors = new ArrayList<MonitorState>(successors.size());
        for (AbstractState abstractState : successors) {
            MonitorState successorElem = new MonitorState(abstractState, totalTimeOnPath, (Pair<PreventingHeuristic, Long>)preventingCondition);
            wrappedSuccessors.add(successorElem);
        }
        return wrappedSuccessors;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, final List<AbstractState> otherElements, final CFAEdge cfaEdge, final Precision precision) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> successors;
        final MonitorState element = (MonitorState)pElement;
        if (element.getWrappedState() == MonitorState.TimeoutState.INSTANCE) {
            return null;
        }
        this.totalTimeOfTransfer.start();
        TransferCallable sc = new TransferCallable(){

            @Override
            public Collection<? extends AbstractState> call() throws CPATransferException, InterruptedException {
                return MonitorTransferRelation.this.transferRelation.strengthen(element.getWrappedState(), otherElements, cfaEdge, precision);
            }
        };
        Pair preventingCondition = null;
        if (this.timeLimit == 0L) {
            successors = sc.call();
        } else {
            Future<Collection<? extends AbstractState>> future = this.executor.submit(sc);
            try {
                successors = future.get(this.timeLimit, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                preventingCondition = Pair.of((Object)((Object)PreventingHeuristic.SUCCESSORCOMPTIME), (Object)this.timeLimit);
                successors = Collections.singleton(MonitorState.TimeoutState.INSTANCE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                preventingCondition = Pair.of((Object)((Object)PreventingHeuristic.SUCCESSORCOMPTIME), (Object)this.timeLimit);
                successors = Collections.singleton(MonitorState.TimeoutState.INSTANCE);
            }
            catch (ExecutionException e) {
                Throwables.propagateIfPossible((Throwable)e.getCause(), CPATransferException.class);
                throw new Classes.UnexpectedCheckedException("strengthen", e.getCause());
            }
        }
        this.totalTimeOfTransfer.stop();
        long timeOfExecution = this.totalTimeOfTransfer.getLengthOfLastInterval().asMillis();
        long totalTimeOnPath = element.getTotalTimeOnPath() + timeOfExecution;
        if (totalTimeOnPath > this.maxTotalTimeForPath) {
            this.maxTotalTimeForPath = totalTimeOnPath;
        }
        if (successors == null) {
            successors = Collections.singleton(element.getWrappedState());
        }
        if (successors.isEmpty()) {
            return Collections.emptySet();
        }
        if (preventingCondition == null && this.timeLimitForPath > 0L && totalTimeOnPath > this.timeLimitForPath) {
            preventingCondition = Pair.of((Object)((Object)PreventingHeuristic.PATHCOMPTIME), (Object)this.timeLimitForPath);
        }
        ArrayList<MonitorState> wrappedSuccessors = new ArrayList<MonitorState>(successors.size());
        for (AbstractState abstractState : successors) {
            MonitorState successorElem = new MonitorState(abstractState, totalTimeOnPath, (Pair<PreventingHeuristic, Long>)preventingCondition);
            wrappedSuccessors.add(successorElem);
        }
        return wrappedSuccessors;
    }

    private static interface TransferCallable
    extends Callable<Collection<? extends AbstractState>> {
        @Override
        public Collection<? extends AbstractState> call() throws CPATransferException, InterruptedException;
    }
}

