/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonDomain;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonMergeOperator;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonTransferRelation;
import org.sosy_lab.cpachecker.exceptions.InvalidCFAException;
import org.sosy_lab.cpachecker.util.octagon.OctagonFloatManager;
import org.sosy_lab.cpachecker.util.octagon.OctagonIntManager;
import org.sosy_lab.cpachecker.util.octagon.OctagonManager;

@Options(prefix="cpa.octagon")
public final class OctagonCPA
implements ConfigurableProgramAnalysis {
    @Option(secure=true, name="octagonLibrary", toUppercase=true, values={"INT", "FLOAT"}, description="with this option the number representation in the library will be changed between floats and ints.")
    private String octagonLibrary = "INT";
    @Option(secure=true, name="initialPrecisionType", toUppercase=true, values={"STATIC_FULL", "REFINEABLE_EMPTY"}, description="this option determines which initial precision should be used")
    private String precisionType = "STATIC_FULL";
    private final AbstractDomain abstractDomain;
    private final TransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;
    private final LogManager logger;
    private final Precision precision;
    private final Configuration config;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private final OctagonManager octagonManager;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(OctagonCPA.class);
    }

    private OctagonCPA(Configuration config, LogManager log, ShutdownNotifier shutdownNotifier, CFA cfa) throws InvalidConfigurationException, InvalidCFAException {
        config.inject((Object)this);
        this.logger = log;
        OctagonDomain octagonDomain = new OctagonDomain(this.logger);
        this.octagonManager = this.octagonLibrary.equals("FLOAT") ? new OctagonFloatManager() : new OctagonIntManager();
        this.transferRelation = new OctagonTransferRelation(this.logger, cfa);
        MergeOperator octagonMergeOp = OctagonMergeOperator.getInstance(octagonDomain, config);
        StopSepOperator octagonStopOp = new StopSepOperator(octagonDomain);
        this.abstractDomain = octagonDomain;
        this.mergeOperator = octagonMergeOp;
        this.stopOperator = octagonStopOp;
        this.precisionAdjustment = StaticPrecisionAdjustment.getInstance();
        this.config = config;
        this.shutdownNotifier = shutdownNotifier;
        this.cfa = cfa;
        this.precision = this.precisionType.equals("REFINEABLE_EMPTY") ? VariableTrackingPrecision.createRefineablePrecision(config, VariableTrackingPrecision.createStaticPrecision(config, cfa.getVarClassification(), this.getClass())) : VariableTrackingPrecision.createStaticPrecision(config, cfa.getVarClassification(), this.getClass());
    }

    public OctagonManager getManager() {
        return this.octagonManager;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new OctagonState(this.logger, this.octagonManager);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    public CFA getCFA() {
        return this.cfa;
    }
}

