/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonDomain;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.octagon.mergeop")
public class OctagonMergeOperator {
    private final OctagonDomain domain;
    @Option(secure=true, name="type", toUppercase=true, values={"SEP", "JOIN", "WIDENING"}, description="of which type should the merge be?")
    private String type = "SEP";
    @Option(secure=true, name="onlyMergeAtLoopHeads", description="with this option enabled the states are only merged at loop heads")
    private boolean onlyMergeAtLoopHeads = false;

    public static MergeOperator getInstance(OctagonDomain domain, Configuration config) throws InvalidConfigurationException {
        OctagonMergeOperator mergeOp = new OctagonMergeOperator(domain, config);
        switch (mergeOp.type) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "JOIN": {
                OctagonMergeOperator octagonMergeOperator = mergeOp;
                octagonMergeOperator.getClass();
                return octagonMergeOperator.new OctagonMergeJoinOperator(domain, config);
            }
            case "WIDENING": {
                OctagonMergeOperator octagonMergeOperator = mergeOp;
                octagonMergeOperator.getClass();
                return octagonMergeOperator.new OctagonMergeWideningOperator(domain, config);
            }
        }
        throw new InvalidConfigurationException("Unknown type for merge operator");
    }

    private OctagonMergeOperator(OctagonDomain domain, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.domain = domain;
    }

    @Options(prefix="cpa.octagon.mergeop")
    class OctagonMergeWideningOperator
    extends OctagonMergeOperator
    implements MergeOperator {
        private OctagonMergeWideningOperator(OctagonDomain domain, Configuration config) throws InvalidConfigurationException {
            super(domain, config);
        }

        @Override
        public AbstractState merge(AbstractState el1, AbstractState el2, Precision p) throws CPAException {
            if (!(!OctagonMergeOperator.this.onlyMergeAtLoopHeads || ((OctagonState)el1).isLoopHead() && ((OctagonState)el2).isLoopHead())) {
                return el2;
            }
            return OctagonMergeOperator.this.domain.widening((OctagonState)el1, (OctagonState)el2);
        }
    }

    @Options(prefix="cpa.octagon.mergeop")
    class OctagonMergeJoinOperator
    extends OctagonMergeOperator
    implements MergeOperator {
        private OctagonMergeJoinOperator(OctagonDomain domain, Configuration config) throws InvalidConfigurationException {
            super(domain, config);
        }

        @Override
        public AbstractState merge(AbstractState el1, AbstractState el2, Precision p) throws CPAException {
            if (!(!OctagonMergeOperator.this.onlyMergeAtLoopHeads || ((OctagonState)el1).isLoopHead() && ((OctagonState)el2).isLoopHead())) {
                return el2;
            }
            return OctagonMergeOperator.this.domain.join(el1, el2);
        }
    }
}

