/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.octagon.OctagonState;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.IOctagonCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonIntervalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonSimpleCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.coefficients.OctagonUniversalCoefficients;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidCFAException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class OctagonTransferRelation
extends ForwardingTransferRelation<Set<OctagonState>, OctagonState, VariableTrackingPrecision> {
    private static final String TEMP_VAR_PREFIX = "___cpa_temp_var_";
    private static int temporaryVariableCounter = 0;
    private static final Map<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"pthread_create", (Object)"threads");
    private final LogManager logger;
    private final Set<CFANode> loopHeads;

    public OctagonTransferRelation(LogManager log, CFA cfa) throws InvalidCFAException {
        this.logger = log;
        if (!cfa.getLoopStructure().isPresent()) {
            throw new InvalidCFAException("OctagonCPA does not work without loop information!");
        }
        LoopStructure loops = (LoopStructure)cfa.getLoopStructure().get();
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (LoopStructure.Loop l : loops.getAllLoops()) {
            builder.addAll(l.getLoopHeads());
        }
        this.loopHeads = builder.build();
    }

    @Override
    public Collection<OctagonState> getAbstractSuccessorsForEdge(AbstractState abstractState, Precision abstractPrecision, CFAEdge cfaEdge) throws CPATransferException {
        this.setInfo(abstractState, abstractPrecision, cfaEdge);
        Collection<OctagonState> preCheck = this.preCheck();
        if (preCheck != null) {
            return preCheck;
        }
        ArrayList successors = new ArrayList();
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumption = (AssumeEdge)cfaEdge;
                successors.addAll((Collection)this.handleAssumption(assumption, assumption.getExpression(), assumption.getTruthAssumption()));
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge fnkCall = (FunctionCallEdge)cfaEdge;
                FunctionEntryNode succ = fnkCall.getSuccessor();
                String calledFunctionName = succ.getFunctionName();
                successors.addAll((Collection)this.handleFunctionCallEdge(fnkCall, fnkCall.getArguments(), succ.getFunctionParameters(), calledFunctionName));
                break;
            }
            case FunctionReturnEdge: {
                String callerFunctionName = cfaEdge.getSuccessor().getFunctionName();
                FunctionReturnEdge fnkReturnEdge = (FunctionReturnEdge)cfaEdge;
                FunctionSummaryEdge summaryEdge = fnkReturnEdge.getSummaryEdge();
                successors.addAll((Collection)this.handleFunctionReturnEdge(fnkReturnEdge, summaryEdge, summaryEdge.getExpression(), callerFunctionName));
                break;
            }
            case MultiEdge: {
                successors.addAll((Collection)this.handleMultiEdge((MultiEdge)cfaEdge));
                break;
            }
            default: {
                successors.addAll((Collection)this.handleSimpleEdge(cfaEdge));
            }
        }
        assert (!successors.removeAll(Collections.singleton(null)));
        Iterator states = successors.iterator();
        while (states.hasNext()) {
            OctagonState st = (OctagonState)states.next();
            if (!st.isEmpty()) continue;
            states.remove();
            this.logger.log(Level.FINER, new Object[]{"removing state because of unsatisfiable constraints:\n" + st + "________________\nEdge was:\n" + cfaEdge.getDescription()});
        }
        HashSet<OctagonState> cleanedUpStates = new HashSet<OctagonState>();
        for (OctagonState st : successors) {
            cleanedUpStates.add(st.removeTempVars(this.functionName, TEMP_VAR_PREFIX));
        }
        if (this.loopHeads.contains(cfaEdge.getSuccessor())) {
            HashSet<OctagonState> newStates = new HashSet<OctagonState>();
            for (OctagonState s : cleanedUpStates) {
                newStates.add(s.asLoopHead());
            }
            cleanedUpStates = newStates;
        }
        this.resetInfo();
        return cleanedUpStates;
    }

    @Override
    protected Set<OctagonState> handleBlankEdge(BlankEdge cfaEdge) throws CPATransferException {
        return Collections.singleton(this.state);
    }

    @Override
    protected Set<OctagonState> handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) throws CPATransferException {
        if (expression instanceof CBinaryExpression) {
            return this.handleBinaryBooleanExpression((CBinaryExpression)expression, truthAssumption, (OctagonState)this.state);
        }
        if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExp = (CUnaryExpression)expression;
            switch (unaryExp.getOperator()) {
                case MINUS: {
                    return this.handleAssumption(cfaEdge, unaryExp.getOperand(), truthAssumption);
                }
                case SIZEOF: 
                case TILDE: 
                case AMPER: {
                    return Collections.singleton(this.state);
                }
            }
            throw new CPATransferException("Unhandled case: " + unaryExp.getOperator());
        }
        if (expression instanceof CIdExpression || expression instanceof CFieldReference || expression instanceof CPointerExpression && ((CPointerExpression)expression).getOperand() instanceof CIdExpression) {
            if (this.isHandleableVariable(expression)) {
                ValueAnalysisState.MemoryLocation varName = this.buildVarName((CLeftHandSide)expression, this.functionName);
                return this.handleSingleBooleanExpression(varName, truthAssumption, (OctagonState)this.state);
            }
            return Collections.singleton(this.state);
        }
        if (expression instanceof CLiteralExpression) {
            if (expression instanceof CIntegerLiteralExpression) {
                return this.handleLiteralBooleanExpression(((CIntegerLiteralExpression)expression).asLong(), truthAssumption, (OctagonState)this.state);
            }
            if (expression instanceof CCharLiteralExpression) {
                return this.handleLiteralBooleanExpression(((CCharLiteralExpression)expression).getCharacter(), truthAssumption, (OctagonState)this.state);
            }
            if (expression instanceof CFloatLiteralExpression) {
                int val = Math.abs(((CFloatLiteralExpression)expression).getValue().signum());
                return this.handleLiteralBooleanExpression(val, truthAssumption, (OctagonState)this.state);
            }
            return Collections.singleton(this.state);
        }
        if (expression instanceof CCastExpression) {
            return this.handleAssumption(cfaEdge, ((CCastExpression)expression).getOperand(), truthAssumption);
        }
        throw new UnrecognizedCCodeException("Unknown expression type in assumption", (CFAEdge)cfaEdge, expression);
    }

    private Set<OctagonState> handleLiteralBooleanExpression(long value, boolean truthAssumption, OctagonState state) {
        if (value == 0L) {
            if (truthAssumption) {
                return Collections.emptySet();
            }
            return Collections.singleton(state);
        }
        if (truthAssumption) {
            return Collections.singleton(state);
        }
        return Collections.emptySet();
    }

    private OctagonState.Type getCorrespondingOctStateType(CType type) {
        if (type instanceof CSimpleType && (((CSimpleType)type).getType() == CBasicType.FLOAT || ((CSimpleType)type).getType() == CBasicType.DOUBLE)) {
            return OctagonState.Type.FLOAT;
        }
        return OctagonState.Type.INT;
    }

    private Set<OctagonState> handleBinaryBooleanExpression(CBinaryExpression binExp, boolean truthAssumption, OctagonState state) throws CPATransferException {
        switch (binExp.getOperator()) {
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case MODULO: {
                return Collections.singleton(state);
            }
            case MINUS: 
            case PLUS: 
            case MULTIPLY: 
            case DIVIDE: {
                ValueAnalysisState.MemoryLocation tempVarName = ValueAnalysisState.MemoryLocation.valueOf(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
                ++temporaryVariableCounter;
                COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(state, this.functionName);
                Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = binExp.accept(coeffVisitor);
                HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
                for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
                    IOctagonCoefficients coeffs = (IOctagonCoefficients)pairs.getFirst();
                    if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                        return Collections.singleton(state);
                    }
                    OctagonState tmp = ((OctagonState)pairs.getSecond()).declareVariable(tempVarName, this.getCorrespondingOctStateType(binExp.getExpressionType()));
                    tmp = tmp.makeAssignment(tempVarName, coeffs.expandToSize(tmp.sizeOfVariables(), tmp));
                    possibleStates.addAll(this.handleSingleBooleanExpression(tempVarName, truthAssumption, tmp));
                }
                return possibleStates;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_EQUAL: 
            case GREATER_THAN: 
            case LESS_EQUAL: 
            case LESS_THAN: {
                CExpression left = binExp.getOperand1();
                CExpression right = binExp.getOperand2();
                CBinaryExpression.BinaryOperator op = binExp.getOperator();
                if (!this.isHandleableVariable(left) || !this.isHandleableVariable(right)) {
                    return Collections.singleton(state);
                }
                if (left instanceof CLiteralExpression || right instanceof CLiteralExpression) {
                    return this.handleBinaryAssumptionWithLiteral(left, right, op, truthAssumption, state);
                }
                return this.handleBinaryAssumptionWithoutLiteral(binExp, truthAssumption, left, right, state);
            }
        }
        throw new CPATransferException("Unhandled case: " + binExp.getOperator());
    }

    private Set<OctagonState> handleBinaryAssumptionWithLiteral(CExpression left, CExpression right, CBinaryExpression.BinaryOperator op, boolean truthAssumption, OctagonState state) throws CPATransferException {
        if (left instanceof CStringLiteralExpression || right instanceof CStringLiteralExpression) {
            return Collections.singleton(state);
        }
        if (left instanceof CLiteralExpression && right instanceof CLiteralExpression) {
            return this.handleBinaryAssumptionWithTwoLiterals((CLiteralExpression)left, (CLiteralExpression)right, op, truthAssumption);
        }
        if (left instanceof CLiteralExpression) {
            switch (op) {
                case GREATER_EQUAL: {
                    op = CBinaryExpression.BinaryOperator.LESS_EQUAL;
                    break;
                }
                case GREATER_THAN: {
                    op = CBinaryExpression.BinaryOperator.LESS_THAN;
                    break;
                }
                case LESS_EQUAL: {
                    op = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
                    break;
                }
                case LESS_THAN: {
                    op = CBinaryExpression.BinaryOperator.GREATER_THAN;
                    break;
                }
            }
            return this.handleBinaryAssumptionWithOneLiteral(right, (CLiteralExpression)left, op, truthAssumption, state);
        }
        if (right instanceof CLiteralExpression) {
            return this.handleBinaryAssumptionWithOneLiteral(left, (CLiteralExpression)right, op, truthAssumption, state);
        }
        return Collections.singleton(state);
    }

    private boolean isHandleableVariable(CExpression var) {
        if (var instanceof CArraySubscriptExpression || var instanceof CFieldReference || var instanceof CPointerExpression || var instanceof CStringLiteralExpression || var instanceof CFieldReference && ((CFieldReference)var).isPointerDereference()) {
            return false;
        }
        return this.isHandleAbleType(var.getExpressionType());
    }

    private boolean isHandleAbleType(CType type) {
        type = type.getCanonicalType();
        while (type instanceof CTypedefType) {
            type = ((CTypedefType)type).getRealType();
        }
        return !(type instanceof CPointerType) && !(type instanceof CCompositeType) && !(type instanceof CArrayType);
    }

    private Set<OctagonState> handleBinaryAssumptionWithOneLiteral(CExpression left, CLiteralExpression right, CBinaryExpression.BinaryOperator op, boolean truthAssumption, OctagonState state) throws CPATransferException {
        if (left.getExpressionType() instanceof CPointerType || left instanceof CFieldReference && ((CFieldReference)left).isPointerDereference()) {
            return Collections.singleton(state);
        }
        ValueAnalysisState.MemoryLocation leftVarName = null;
        ArrayList<OctagonState> states = new ArrayList<OctagonState>();
        states.add(state);
        if (left instanceof CIdExpression || left instanceof CFieldReference) {
            leftVarName = this.buildVarName((CLeftHandSide)left, this.functionName);
        } else {
            COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(state, this.functionName);
            Set<Pair<IOctagonCoefficients, OctagonState>> coeffsLeft = left.accept(coeffVisitor);
            ValueAnalysisState.MemoryLocation tempLeft = ValueAnalysisState.MemoryLocation.valueOf(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
            ++temporaryVariableCounter;
            ArrayList<OctagonState> tmpList = new ArrayList<OctagonState>();
            for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsLeft) {
                IOctagonCoefficients coeffs = (IOctagonCoefficients)pairs.getFirst();
                if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                    return Collections.singleton(state);
                }
                OctagonState tmpState = ((OctagonState)pairs.getSecond()).declareVariable(tempLeft, this.getCorrespondingOctStateType(left.getExpressionType()));
                tmpList.add(tmpState.makeAssignment(tempLeft, coeffs.expandToSize(tmpState.sizeOfVariables(), tmpState)));
            }
            states = tmpList;
            leftVarName = tempLeft;
        }
        OctagonNumericValue rightVal = OctagonIntValue.ZERO;
        if (right instanceof CIntegerLiteralExpression) {
            rightVal = OctagonIntValue.of(((CIntegerLiteralExpression)right).asLong());
        } else if (right instanceof CCharLiteralExpression) {
            rightVal = OctagonIntValue.of(((CCharLiteralExpression)right).getCharacter());
        } else if (right instanceof CFloatLiteralExpression) {
            rightVal = new OctagonDoubleValue(((CFloatLiteralExpression)right).getValue().doubleValue());
        } else {
            return Collections.singleton(state);
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        block9: for (OctagonState actState : states) {
            switch (op) {
                case EQUALS: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addEqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.addAll(actState.addIneqConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case NOT_EQUALS: {
                    if (truthAssumption) {
                        possibleStates.addAll(actState.addIneqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addEqConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case LESS_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerEqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addGreaterConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case LESS_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addGreaterEqConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case GREATER_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterEqConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addSmallerConstraint(leftVarName, rightVal));
                    continue block9;
                }
                case GREATER_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterConstraint(leftVarName, rightVal));
                        continue block9;
                    }
                    possibleStates.add(actState.addSmallerEqConstraint(leftVarName, rightVal));
                    continue block9;
                }
            }
            throw new CPATransferException("Unhandled case statement: " + op);
        }
        return possibleStates;
    }

    private Set<OctagonState> handleBinaryAssumptionWithTwoLiterals(CLiteralExpression left, CLiteralExpression right, CBinaryExpression.BinaryOperator op, boolean truthAssumption) throws CPATransferException {
        OctagonNumericValue leftVal = OctagonIntValue.ZERO;
        if (left instanceof CIntegerLiteralExpression) {
            leftVal = OctagonIntValue.of(((CIntegerLiteralExpression)left).asLong());
        } else if (left instanceof CCharLiteralExpression) {
            leftVal = OctagonIntValue.of(((CCharLiteralExpression)left).getCharacter());
        } else if (left instanceof CFloatLiteralExpression) {
            leftVal = new OctagonDoubleValue(((CFloatLiteralExpression)left).getValue().doubleValue());
        }
        OctagonNumericValue rightVal = OctagonIntValue.ZERO;
        if (right instanceof CIntegerLiteralExpression) {
            rightVal = OctagonIntValue.of(((CIntegerLiteralExpression)right).asLong());
        } else if (right instanceof CCharLiteralExpression) {
            rightVal = OctagonIntValue.of(((CCharLiteralExpression)right).getCharacter());
        } else if (right instanceof CFloatLiteralExpression) {
            rightVal = new OctagonDoubleValue(((CFloatLiteralExpression)right).getValue().doubleValue());
        }
        switch (op) {
            case EQUALS: {
                if (truthAssumption) {
                    if (leftVal.isEqual(rightVal)) {
                        return Collections.singleton(this.state);
                    }
                    return Collections.emptySet();
                }
                if (leftVal.isEqual(rightVal)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(this.state);
            }
            case GREATER_EQUAL: {
                if (truthAssumption) {
                    if (leftVal.greaterEqual(rightVal)) {
                        return Collections.singleton(this.state);
                    }
                    return Collections.emptySet();
                }
                if (leftVal.greaterEqual(rightVal)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(this.state);
            }
            case GREATER_THAN: {
                if (truthAssumption) {
                    if (leftVal.greaterThan(rightVal)) {
                        return Collections.singleton(this.state);
                    }
                    return Collections.emptySet();
                }
                if (leftVal.greaterThan(rightVal)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(this.state);
            }
            case LESS_EQUAL: {
                if (truthAssumption) {
                    if (leftVal.lessEqual(rightVal)) {
                        return Collections.singleton(this.state);
                    }
                    return Collections.emptySet();
                }
                if (leftVal.lessEqual(rightVal)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(this.state);
            }
            case LESS_THAN: {
                if (truthAssumption) {
                    if (leftVal.lessThan(rightVal)) {
                        return Collections.singleton(this.state);
                    }
                    return Collections.emptySet();
                }
                if (leftVal.lessThan(rightVal)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(this.state);
            }
            case NOT_EQUALS: {
                if (truthAssumption) {
                    if (leftVal.isEqual(rightVal)) {
                        return Collections.emptySet();
                    }
                    return Collections.singleton(this.state);
                }
                if (leftVal.isEqual(rightVal)) {
                    return Collections.singleton(this.state);
                }
                return Collections.emptySet();
            }
        }
        throw new CPATransferException("Unhandled case: " + op);
    }

    private Set<OctagonState> handleBinaryAssumptionWithoutLiteral(CBinaryExpression binExp, boolean truthAssumption, CExpression left, CExpression right, OctagonState state) throws CPATransferException {
        CBinaryExpression.BinaryOperator op = binExp.getOperator();
        ValueAnalysisState.MemoryLocation leftVarName = null;
        ValueAnalysisState.MemoryLocation rightVarName = null;
        if (!this.isHandleableVariable(left) || !this.isHandleableVariable(right)) {
            return Collections.singleton(state);
        }
        HashSet<OctagonState> states = new HashSet<OctagonState>();
        states.add(state);
        if (left instanceof CIdExpression || left instanceof CFieldReference) {
            leftVarName = this.buildVarName((CLeftHandSide)left, this.functionName);
        } else {
            COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(state, this.functionName);
            Set<Pair<IOctagonCoefficients, OctagonState>> coeffsLeft = left.accept(coeffVisitor);
            ValueAnalysisState.MemoryLocation tempLeft = ValueAnalysisState.MemoryLocation.valueOf(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
            ++temporaryVariableCounter;
            HashSet<OctagonState> tmpSet = new HashSet<OctagonState>();
            for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsLeft) {
                IOctagonCoefficients coeffs = (IOctagonCoefficients)pairs.getFirst();
                if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                    return Collections.singleton(state);
                }
                OctagonState tmp = ((OctagonState)pairs.getSecond()).declareVariable(tempLeft, this.getCorrespondingOctStateType(left.getExpressionType()));
                tmpSet.add(tmp.makeAssignment(tempLeft, coeffs.expandToSize(tmp.sizeOfVariables(), tmp)));
            }
            states = tmpSet;
            leftVarName = tempLeft;
        }
        if (right instanceof CIdExpression || right instanceof CFieldReference) {
            rightVarName = this.buildVarName((CLeftHandSide)right, this.functionName);
        } else {
            ValueAnalysisState.MemoryLocation tempRight = ValueAnalysisState.MemoryLocation.valueOf(this.functionName, TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
            ++temporaryVariableCounter;
            HashSet<OctagonState> tmpSet = new HashSet<OctagonState>();
            for (OctagonState st : states) {
                COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(st, this.functionName);
                Set<Pair<IOctagonCoefficients, OctagonState>> coeffsRight = right.accept(coeffVisitor);
                for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsRight) {
                    IOctagonCoefficients coeffs = (IOctagonCoefficients)pairs.getFirst();
                    if (coeffs.equals(OctagonUniversalCoefficients.INSTANCE)) {
                        return Collections.singleton(state);
                    }
                    OctagonState tmp = ((OctagonState)pairs.getSecond()).declareVariable(tempRight, this.getCorrespondingOctStateType(right.getExpressionType()));
                    tmpSet.add(tmp.makeAssignment(tempRight, coeffs.expandToSize(tmp.sizeOfVariables(), tmp)));
                }
            }
            states = tmpSet;
            rightVarName = tempRight;
        }
        if (leftVarName.equals(rightVarName)) {
            switch (op) {
                case EQUALS: 
                case GREATER_EQUAL: 
                case LESS_EQUAL: {
                    if (truthAssumption) {
                        return Collections.singleton(state);
                    }
                    return Collections.emptySet();
                }
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case LESS_THAN: {
                    if (truthAssumption) {
                        return Collections.emptySet();
                    }
                    return Collections.singleton(state);
                }
            }
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        block15: for (OctagonState actState : states) {
            switch (op) {
                case EQUALS: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addEqConstraint(rightVarName, leftVarName));
                        continue block15;
                    }
                    possibleStates.addAll(actState.addIneqConstraint(rightVarName, leftVarName));
                    continue block15;
                }
                case GREATER_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterEqConstraint(rightVarName, leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addSmallerConstraint(rightVarName, leftVarName));
                    continue block15;
                }
                case GREATER_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addGreaterConstraint(rightVarName, leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addSmallerEqConstraint(rightVarName, leftVarName));
                    continue block15;
                }
                case LESS_EQUAL: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerEqConstraint(rightVarName, leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addGreaterConstraint(rightVarName, leftVarName));
                    continue block15;
                }
                case LESS_THAN: {
                    if (truthAssumption) {
                        possibleStates.add(actState.addSmallerConstraint(rightVarName, leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addGreaterEqConstraint(rightVarName, leftVarName));
                    continue block15;
                }
                case NOT_EQUALS: {
                    if (truthAssumption) {
                        possibleStates.addAll(actState.addIneqConstraint(rightVarName, leftVarName));
                        continue block15;
                    }
                    possibleStates.add(actState.addEqConstraint(rightVarName, leftVarName));
                    continue block15;
                }
            }
            throw new CPATransferException("Unhandled case: " + binExp.getOperator());
        }
        return possibleStates;
    }

    private Set<OctagonState> handleSingleBooleanExpression(ValueAnalysisState.MemoryLocation variableName, boolean truthAssumption, OctagonState state) {
        if (truthAssumption) {
            return state.addIneqConstraint(variableName, OctagonIntValue.ZERO);
        }
        return Collections.singleton(state.addEqConstraint(variableName, OctagonIntValue.ZERO));
    }

    @Override
    protected Set<OctagonState> handleFunctionCallEdge(CFunctionCallEdge cfaEdge, List<CExpression> arguments, List<CParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        CFunctionEntryNode functionEntryNode = cfaEdge.getSuccessor();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        CFunctionType functionType = cfaEdge.getSuccessor().getFunctionDefinition().getType();
        if (!functionType.takesVarArgs() ? !$assertionsDisabled && parameters.size() != arguments.size() : !$assertionsDisabled && parameters.size() > arguments.size()) {
            throw new AssertionError();
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        CType returnType = functionType.getReturnType().getCanonicalType();
        if (this.isHandleAbleType(returnType) && !(returnType instanceof CVoidType)) {
            this.state = ((OctagonState)this.state).declareVariable(ValueAnalysisState.MemoryLocation.valueOf(calledFunctionName, ((CVariableDeclaration)functionEntryNode.getReturnVariable().get()).getName(), 0L), this.getCorrespondingOctStateType(cfaEdge.getSuccessor().getFunctionDefinition().getType().getReturnType()));
        }
        LinkedList<Pair> handleAbleParams = new LinkedList<Pair>();
        for (int i = 0; i < parameters.size(); ++i) {
            CType typeOfParam;
            ValueAnalysisState.MemoryLocation nameOfParam;
            if (!this.isHandleAbleType(parameters.get(i).getType()) || !((VariableTrackingPrecision)this.precision).isTracking(nameOfParam = ValueAnalysisState.MemoryLocation.valueOf(calledFunctionName, paramNames.get(i), 0L), typeOfParam = parameters.get(i).getType(), functionEntryNode) || !this.isHandleAbleType(parameters.get(i).getType())) continue;
            this.state = ((OctagonState)this.state).declareVariable(nameOfParam, this.getCorrespondingOctStateType(typeOfParam));
            handleAbleParams.add(Pair.of((Object)nameOfParam, (Object)arguments.get(i)));
        }
        possibleStates.add((OctagonState)this.state);
        for (Pair pair : handleAbleParams) {
            ValueAnalysisState.MemoryLocation paramName = (ValueAnalysisState.MemoryLocation)pair.getFirst();
            CExpression argument = (CExpression)pair.getSecond();
            HashSet<OctagonState> newPossibleStates = new HashSet<OctagonState>();
            for (OctagonState st : possibleStates) {
                COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor(st, calledFunctionName);
                Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = argument.accept(coeffVisitor);
                for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
                    newPossibleStates.add(((OctagonState)pairs.getSecond()).makeAssignment(paramName, (IOctagonCoefficients)pairs.getFirst()));
                }
            }
            possibleStates = newPossibleStates;
        }
        return possibleStates;
    }

    @Override
    protected Set<OctagonState> handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        CFunctionCall exprOnSummary = fnkCall.getExpression();
        String calledFunctionName = cfaEdge.getPredecessor().getFunctionName();
        if (exprOnSummary instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement binExp = (CFunctionCallAssignmentStatement)exprOnSummary;
            CLeftHandSide op1 = binExp.getLeftHandSide();
            ValueAnalysisState.MemoryLocation assignedVarName = this.buildVarName(op1, callerFunctionName);
            if (!this.isHandleableVariable(op1) || !((VariableTrackingPrecision)this.precision).isTracking(assignedVarName, op1.getExpressionType(), cfaEdge.getSuccessor())) {
                return Collections.singleton(((OctagonState)this.state).removeLocalVars(calledFunctionName));
            }
            int returnVarIndex = ((OctagonState)this.state).getVariableIndexFor(ValueAnalysisState.MemoryLocation.valueOf(calledFunctionName, ((CVariableDeclaration)fnkCall.getFunctionEntry().getReturnVariable().get()).getName(), 0L));
            if (returnVarIndex == -1) {
                this.state = ((OctagonState)this.state).forget(assignedVarName);
                return Collections.singleton(((OctagonState)this.state).removeLocalVars(calledFunctionName));
            }
            OctagonSimpleCoefficients right = new OctagonSimpleCoefficients(((OctagonState)this.state).sizeOfVariables(), returnVarIndex, OctagonIntValue.ONE, (OctagonState)this.state);
            this.state = ((OctagonState)this.state).makeAssignment(assignedVarName, (IOctagonCoefficients)right);
        } else if (!(exprOnSummary instanceof CFunctionCallStatement)) {
            throw new UnrecognizedCCodeException("on function return", (CFAEdge)cfaEdge, exprOnSummary);
        }
        return Collections.singleton(((OctagonState)this.state).removeLocalVars(calledFunctionName));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Set<OctagonState> handleDeclarationEdge(CDeclarationEdge cfaEdge, CDeclaration decl) throws CPATransferException {
        if (cfaEdge.getDeclaration() instanceof CVariableDeclaration) {
            HashSet<OctagonState> possibleStates;
            block12: {
                CVariableDeclaration declaration = (CVariableDeclaration)decl;
                if (!this.isHandleAbleType(declaration.getType())) {
                    return Collections.singleton(this.state);
                }
                ValueAnalysisState.MemoryLocation variableName = !decl.isGlobal() ? ValueAnalysisState.MemoryLocation.valueOf(this.functionName, declaration.getName(), 0L) : ValueAnalysisState.MemoryLocation.valueOf(declaration.getName());
                if (!((VariableTrackingPrecision)this.precision).isTracking(variableName, declaration.getType(), cfaEdge.getSuccessor())) {
                    return Collections.singleton(this.state);
                }
                CInitializer init = declaration.getInitializer();
                if (!((OctagonState)this.state).existsVariable(variableName) && (init == null || init instanceof CInitializerExpression)) {
                    this.state = ((OctagonState)this.state).declareVariable(variableName, this.getCorrespondingOctStateType(declaration.getType()));
                }
                possibleStates = new HashSet<OctagonState>();
                if (init != null) {
                    if (init instanceof CInitializerExpression) {
                        CExpression exp = ((CInitializerExpression)init).getExpression();
                        COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor((OctagonState)this.state, this.functionName);
                        Set<Pair<IOctagonCoefficients, OctagonState>> initCoeffs = exp.accept(coeffVisitor);
                        for (Pair<IOctagonCoefficients, OctagonState> pairs : initCoeffs) {
                            possibleStates.add(((OctagonState)pairs.getSecond()).makeAssignment(variableName, (IOctagonCoefficients)pairs.getFirst()));
                        }
                        break block12;
                    } else {
                        if (init instanceof CInitializerList) {
                            return Collections.singleton(this.state);
                        }
                        throw new AssertionError((Object)("Unhandled Expression Type: " + init.getClass()));
                    }
                }
                if (decl.isGlobal()) {
                    possibleStates.add(((OctagonState)this.state).makeAssignment(variableName, (IOctagonCoefficients)new OctagonSimpleCoefficients(((OctagonState)this.state).sizeOfVariables(), (OctagonState)this.state).expandToSize(((OctagonState)this.state).sizeOfVariables(), (OctagonState)this.state)));
                }
            }
            if (possibleStates.isEmpty()) {
                possibleStates.add((OctagonState)this.state);
            }
            return possibleStates;
        }
        if (!(cfaEdge.getDeclaration() instanceof CTypeDeclaration) && !(cfaEdge.getDeclaration() instanceof CFunctionDeclaration)) {
            throw new AssertionError((Object)(cfaEdge.getDeclaration() + " (" + cfaEdge.getDeclaration().getClass() + ")"));
        }
        return Collections.singleton(this.state);
    }

    @Override
    protected Set<OctagonState> handleStatementEdge(CStatementEdge cfaEdge, CStatement statement) throws CPATransferException {
        String func;
        CExpression fn;
        if (statement instanceof CFunctionCall && (fn = ((CFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof CIdExpression && UNSUPPORTED_FUNCTIONS.containsKey(func = ((CIdExpression)fn).getName())) {
            throw new UnsupportedCCodeException(UNSUPPORTED_FUNCTIONS.get(func), (CFAEdge)cfaEdge, fn);
        }
        if (statement instanceof CAssignment) {
            CLeftHandSide left = ((CAssignment)statement).getLeftHandSide();
            CRightHandSide right = ((CAssignment)statement).getRightHandSide();
            ValueAnalysisState.MemoryLocation variableName = this.buildVarName(left, this.functionName);
            if (!this.isHandleableVariable(left) || !((VariableTrackingPrecision)this.precision).isTracking(variableName, left.getExpressionType(), cfaEdge.getSuccessor())) {
                assert (!((OctagonState)this.state).existsVariable(variableName)) : "variablename '" + variableName + "' is in map although it can not be handled";
                return Collections.singleton(this.state);
            }
            COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor((OctagonState)this.state, this.functionName);
            Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = right.accept(coeffVisitor);
            HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
            for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
                OctagonState newState = ((OctagonState)pairs.getSecond()).makeAssignment(variableName, (IOctagonCoefficients)pairs.getFirst());
                if (newState.isEmpty()) {
                    possibleStates.add(((OctagonState)this.state).forget(variableName));
                    break;
                }
                possibleStates.add(newState);
            }
            return possibleStates;
        }
        if (statement instanceof CFunctionCallStatement || statement instanceof CExpressionStatement) {
            return Collections.singleton(this.state);
        }
        throw new UnrecognizedCCodeException("unknown statement", (CFAEdge)cfaEdge, statement);
    }

    private ValueAnalysisState.MemoryLocation buildVarName(CLeftHandSide left, String functionName) {
        String variableName = null;
        variableName = left instanceof CArraySubscriptExpression ? ((CArraySubscriptExpression)left).getArrayExpression().toASTString() : (left instanceof CPointerExpression ? ((CPointerExpression)left).getOperand().toASTString() : (left instanceof CFieldReference ? ((CFieldReference)left).getFieldOwner().toASTString() : ((CIdExpression)left).toASTString()));
        if (!OctagonTransferRelation.isGlobal(left)) {
            return ValueAnalysisState.MemoryLocation.valueOf(functionName, variableName, 0L);
        }
        return ValueAnalysisState.MemoryLocation.valueOf(variableName);
    }

    @Override
    protected Set<OctagonState> handleReturnStatementEdge(CReturnStatementEdge cfaEdge) throws CPATransferException {
        if (!cfaEdge.getExpression().isPresent()) {
            return Collections.singleton(this.state);
        }
        ValueAnalysisState.MemoryLocation tempVarName = ValueAnalysisState.MemoryLocation.valueOf(cfaEdge.getPredecessor().getFunctionName(), ((CIdExpression)((CAssignment)cfaEdge.asAssignment().get()).getLeftHandSide()).getName(), 0L);
        if (!((OctagonState)this.state).existsVariable(tempVarName)) {
            return Collections.singleton(this.state);
        }
        HashSet<OctagonState> possibleStates = new HashSet<OctagonState>();
        COctagonCoefficientVisitor coeffVisitor = new COctagonCoefficientVisitor((OctagonState)this.state, cfaEdge.getPredecessor().getFunctionName());
        Set<Pair<IOctagonCoefficients, OctagonState>> coeffsList = ((CExpression)cfaEdge.getExpression().get()).accept(coeffVisitor);
        for (Pair<IOctagonCoefficients, OctagonState> pairs : coeffsList) {
            possibleStates.add(((OctagonState)pairs.getSecond()).makeAssignment(tempVarName, (IOctagonCoefficients)pairs.getFirst()));
        }
        return possibleStates;
    }

    @Override
    protected Set<OctagonState> handleFunctionSummaryEdge(CFunctionSummaryEdge cfaEdge) throws CPATransferException {
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }

    static class NotInstanceOfEmptyCoefficients
    implements Predicate<Pair<IOctagonCoefficients, OctagonState>> {
        NotInstanceOfEmptyCoefficients() {
        }

        public boolean apply(Pair<IOctagonCoefficients, OctagonState> pInput) {
            return !(pInput.getFirst() instanceof OctagonUniversalCoefficients);
        }
    }

    class COctagonCoefficientVisitor
    extends DefaultCExpressionVisitor<Set<Pair<IOctagonCoefficients, OctagonState>>, CPATransferException>
    implements CRightHandSideVisitor<Set<Pair<IOctagonCoefficients, OctagonState>>, CPATransferException> {
        private OctagonState visitorState;
        private String visitorFunctionName;

        public COctagonCoefficientVisitor(OctagonState pState, String pFunctionName) {
            this.visitorState = pState;
            this.visitorFunctionName = pFunctionName;
        }

        public OctagonState getState() {
            return this.visitorState;
        }

        @Override
        protected Set<Pair<IOctagonCoefficients, OctagonState>> visitDefault(CExpression pExp) throws CPATransferException {
            return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CBinaryExpression e) throws CPATransferException {
            switch (e.getOperator()) {
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: 
                case MODULO: {
                    return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
                }
            }
            ImmutableSet left = e.getOperand1().accept(this);
            HashSet<Pair> right = new HashSet<Pair>();
            int origSize = left.size();
            left = FluentIterable.from(left).filter((Predicate)new NotInstanceOfEmptyCoefficients()).toSet();
            if (left.isEmpty() || origSize != left.size()) {
                return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
            }
            for (Pair pair : left) {
                ImmutableSet tmpRight = e.getOperand2().accept(new COctagonCoefficientVisitor((OctagonState)pair.getSecond(), this.visitorFunctionName));
                origSize = tmpRight.size();
                if ((tmpRight = FluentIterable.from(tmpRight).filter((Predicate)new NotInstanceOfEmptyCoefficients()).toSet()).isEmpty() || origSize != tmpRight.size()) {
                    return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
                }
                right.add(Pair.of((Object)pair.getFirst(), (Object)tmpRight));
            }
            switch (e.getOperator()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_EQUAL: 
                case GREATER_THAN: 
                case LESS_EQUAL: 
                case LESS_THAN: {
                    HashSet<Pair<IOctagonCoefficients, OctagonState>> returnCoefficients = new HashSet<Pair<IOctagonCoefficients, OctagonState>>();
                    ValueAnalysisState.MemoryLocation tempVarLeft = ValueAnalysisState.MemoryLocation.valueOf(this.visitorFunctionName, OctagonTransferRelation.TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
                    temporaryVariableCounter++;
                    CBinaryExpression.BinaryOperator binOp = e.getOperator();
                    for (Pair pairs : right) {
                        IOctagonCoefficients leftCoeffs = (IOctagonCoefficients)pairs.getFirst();
                        block19: for (Pair rightPair : (Set)pairs.getSecond()) {
                            OctagonState visitorState = (OctagonState)rightPair.getSecond();
                            IOctagonCoefficients rightCoeffs = (IOctagonCoefficients)rightPair.getFirst();
                            if (leftCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState).equals(rightCoeffs)) {
                                switch (binOp) {
                                    case EQUALS: 
                                    case GREATER_EQUAL: 
                                    case LESS_EQUAL: {
                                        returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(visitorState.sizeOfVariables(), visitorState), (Object)visitorState));
                                        continue block19;
                                    }
                                    case NOT_EQUALS: 
                                    case GREATER_THAN: 
                                    case LESS_THAN: {
                                        returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(visitorState.sizeOfVariables(), visitorState), (Object)visitorState));
                                        continue block19;
                                    }
                                }
                                throw new AssertionError((Object)"Unhandled case in switch clause.");
                            }
                            if (leftCoeffs.hasOnlyOneValue() && !leftCoeffs.hasOnlyConstantValue()) {
                                tempVarLeft = visitorState.getVariableNameFor(leftCoeffs.getVariableIndex());
                            } else if (rightCoeffs.hasOnlyOneValue() && !rightCoeffs.hasOnlyConstantValue()) {
                                tempVarLeft = visitorState.getVariableNameFor(rightCoeffs.getVariableIndex());
                                rightCoeffs = leftCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState);
                                switch (binOp) {
                                    case GREATER_EQUAL: {
                                        binOp = CBinaryExpression.BinaryOperator.LESS_EQUAL;
                                        break;
                                    }
                                    case GREATER_THAN: {
                                        binOp = CBinaryExpression.BinaryOperator.LESS_THAN;
                                        break;
                                    }
                                    case LESS_EQUAL: {
                                        binOp = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
                                        break;
                                    }
                                    case LESS_THAN: {
                                        binOp = CBinaryExpression.BinaryOperator.GREATER_THAN;
                                        break;
                                    }
                                }
                            } else {
                                visitorState = visitorState.declareVariable(tempVarLeft, OctagonTransferRelation.this.getCorrespondingOctStateType(e.getOperand1().getExpressionType()));
                                visitorState = visitorState.makeAssignment(tempVarLeft, leftCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState));
                                rightCoeffs = rightCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState);
                            }
                            returnCoefficients.addAll(this.handleLogicalOperators(tempVarLeft, binOp, visitorState, rightCoeffs));
                        }
                    }
                    return returnCoefficients;
                }
                case MINUS: 
                case PLUS: 
                case MULTIPLY: 
                case DIVIDE: {
                    HashSet<Pair<IOctagonCoefficients, OctagonState>> returnCoefficients = new HashSet();
                    for (Pair pairs : right) {
                        IOctagonCoefficients leftCoeffs = (IOctagonCoefficients)pairs.getFirst();
                        for (Pair rightPair : (Set)pairs.getSecond()) {
                            IOctagonCoefficients rightCoeffs = (IOctagonCoefficients)rightPair.getFirst();
                            OctagonState visitorState = (OctagonState)rightPair.getSecond();
                            if (leftCoeffs.size() < rightCoeffs.size()) {
                                leftCoeffs = leftCoeffs.expandToSize(rightCoeffs.size(), visitorState);
                            } else {
                                rightCoeffs = rightCoeffs.expandToSize(leftCoeffs.size(), visitorState);
                            }
                            if (e.getOperator() == CBinaryExpression.BinaryOperator.MINUS) {
                                returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)leftCoeffs.sub(rightCoeffs), (Object)visitorState));
                                continue;
                            }
                            if (e.getOperator() == CBinaryExpression.BinaryOperator.PLUS) {
                                returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)leftCoeffs.add(rightCoeffs), (Object)visitorState));
                                continue;
                            }
                            if (e.getOperator() == CBinaryExpression.BinaryOperator.MULTIPLY) {
                                if (leftCoeffs.hasOnlyOneValue() || rightCoeffs.hasOnlyOneValue()) {
                                    returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)leftCoeffs.mul(rightCoeffs), (Object)visitorState));
                                    continue;
                                }
                                ValueAnalysisState.MemoryLocation tempVarLeft = ValueAnalysisState.MemoryLocation.valueOf(this.visitorFunctionName, OctagonTransferRelation.TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
                                temporaryVariableCounter++;
                                visitorState = visitorState.declareVariable(tempVarLeft, OctagonTransferRelation.this.getCorrespondingOctStateType(e.getOperand1().getExpressionType()));
                                visitorState = visitorState.makeAssignment(tempVarLeft, leftCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState));
                                returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)new OctagonSimpleCoefficients(visitorState.sizeOfVariables(), visitorState.getVariableIndexFor(tempVarLeft), OctagonIntValue.ONE, visitorState).mul(rightCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState)), (Object)visitorState));
                                continue;
                            }
                            if (e.getOperator() != CBinaryExpression.BinaryOperator.DIVIDE) continue;
                            if (rightCoeffs.hasOnlyOneValue()) {
                                returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)leftCoeffs.div(rightCoeffs), (Object)visitorState));
                                continue;
                            }
                            ValueAnalysisState.MemoryLocation tempVarRight = ValueAnalysisState.MemoryLocation.valueOf(this.visitorFunctionName, OctagonTransferRelation.TEMP_VAR_PREFIX + temporaryVariableCounter + "_", 0L);
                            temporaryVariableCounter++;
                            visitorState = visitorState.declareVariable(tempVarRight, OctagonTransferRelation.this.getCorrespondingOctStateType(e.getOperand2().getExpressionType()));
                            visitorState = visitorState.makeAssignment(tempVarRight, rightCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState));
                            IOctagonCoefficients expandedleftCoeffs = leftCoeffs.expandToSize(visitorState.sizeOfVariables(), visitorState);
                            returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)expandedleftCoeffs.div(new OctagonSimpleCoefficients(visitorState.sizeOfVariables(), visitorState.getVariableIndexFor(tempVarRight), OctagonIntValue.ONE, visitorState)), (Object)visitorState));
                        }
                    }
                    return returnCoefficients;
                }
            }
            throw new AssertionError((Object)"Unhandled case statement");
        }

        private Set<Pair<IOctagonCoefficients, OctagonState>> handleLogicalOperators(ValueAnalysisState.MemoryLocation pTempVarLeft, CBinaryExpression.BinaryOperator binOp, OctagonState state, IOctagonCoefficients constraintCoeffs) {
            HashSet<Pair<IOctagonCoefficients, OctagonState>> returnCoefficients = new HashSet<Pair<IOctagonCoefficients, OctagonState>>();
            switch (binOp) {
                case EQUALS: {
                    OctagonState tmpState = state.addEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(state.sizeOfVariables(), state), (Object)state));
                        break;
                    }
                    returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(state.sizeOfVariables(), tmpState), (Object)tmpState));
                    OctagonState smaller = state.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    if (!smaller.isEmpty()) {
                        returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(smaller.sizeOfVariables(), smaller), (Object)smaller));
                        break;
                    }
                    OctagonState greater = state.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    if (greater.isEmpty()) break;
                    returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(greater.sizeOfVariables(), greater), (Object)greater));
                    break;
                }
                case GREATER_EQUAL: {
                    OctagonState tmpState = state.addGreaterEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(state.sizeOfVariables(), state), (Object)state));
                        break;
                    }
                    returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(state.sizeOfVariables(), tmpState), (Object)tmpState));
                    OctagonState smaller = state.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    if (smaller.isEmpty()) break;
                    returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(smaller.sizeOfVariables(), smaller), (Object)smaller));
                    break;
                }
                case GREATER_THAN: {
                    OctagonState tmpState = state.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(state.sizeOfVariables(), state), (Object)state));
                        break;
                    }
                    returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(state.sizeOfVariables(), tmpState), (Object)tmpState));
                    OctagonState smaller = state.addSmallerEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (smaller.isEmpty()) break;
                    returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(smaller.sizeOfVariables(), smaller), (Object)smaller));
                    break;
                }
                case LESS_EQUAL: {
                    OctagonState tmpState = state.addSmallerEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(state.sizeOfVariables(), state), (Object)state));
                        break;
                    }
                    returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(state.sizeOfVariables(), tmpState), (Object)tmpState));
                    OctagonState greater = state.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    if (greater.isEmpty()) break;
                    returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(greater.sizeOfVariables(), greater), (Object)greater));
                    break;
                }
                case LESS_THAN: {
                    OctagonState tmpState = state.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    if (tmpState.isEmpty()) {
                        returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(state.sizeOfVariables(), state), (Object)state));
                        break;
                    }
                    returnCoefficients.add(Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(state.sizeOfVariables(), tmpState), (Object)tmpState));
                    OctagonState greater = state.addGreaterEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (greater.isEmpty()) break;
                    returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(greater.sizeOfVariables(), greater), (Object)greater));
                    break;
                }
                case NOT_EQUALS: {
                    OctagonState smaller = state.addSmallerConstraint(pTempVarLeft, constraintCoeffs);
                    OctagonState bigger = state.addGreaterConstraint(pTempVarLeft, constraintCoeffs);
                    OctagonState equal = state.addEqConstraint(pTempVarLeft, constraintCoeffs);
                    if (!smaller.isEmpty()) {
                        returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(smaller.sizeOfVariables(), smaller), (Object)smaller));
                    }
                    if (!bigger.isEmpty()) {
                        returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolTRUECoeffs(bigger.sizeOfVariables(), bigger), (Object)bigger));
                    }
                    if (equal.isEmpty()) break;
                    returnCoefficients.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)OctagonSimpleCoefficients.getBoolFALSECoeffs(equal.sizeOfVariables(), equal), (Object)equal));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unhandled case statement");
                }
            }
            return returnCoefficients;
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CCastExpression e) throws CPATransferException {
            return e.getOperand().accept(this);
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CIdExpression e) throws CPATransferException {
            ValueAnalysisState.MemoryLocation varName = OctagonTransferRelation.this.buildVarName(e, OctagonTransferRelation.this.functionName);
            Integer varIndex = this.visitorState.getVariableIndexFor(varName);
            if (varIndex == -1) {
                varName = OctagonTransferRelation.this.buildVarName(e, this.visitorFunctionName);
                varIndex = this.visitorState.getVariableIndexFor(varName);
            }
            if (varIndex == -1) {
                return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
            }
            return Collections.singleton(Pair.of((Object)new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), varIndex, OctagonIntValue.ONE, this.visitorState), (Object)this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CCharLiteralExpression e) throws CPATransferException {
            return Collections.singleton(Pair.of((Object)new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), OctagonIntValue.of(e.getValue().charValue()), this.visitorState), (Object)this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CFloatLiteralExpression e) throws CPATransferException {
            return Collections.singleton(Pair.of((Object)new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), new OctagonDoubleValue(e.getValue().doubleValue()), this.visitorState), (Object)this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CIntegerLiteralExpression e) throws CPATransferException {
            return Collections.singleton(Pair.of((Object)new OctagonSimpleCoefficients(this.visitorState.sizeOfVariables(), OctagonIntValue.of(e.asLong()), this.visitorState), (Object)this.visitorState));
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CUnaryExpression e) throws CPATransferException {
            switch (e.getOperator()) {
                case SIZEOF: 
                case TILDE: 
                case AMPER: {
                    return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
                }
            }
            assert (e.getOperator() == CUnaryExpression.UnaryOperator.MINUS);
            ImmutableSet operand = e.getOperand().accept(this);
            int origSize = operand.size();
            if ((operand = FluentIterable.from(operand).filter((Predicate)new NotInstanceOfEmptyCoefficients()).toSet()).isEmpty() || origSize != operand.size()) {
                return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
            }
            HashSet<Pair<IOctagonCoefficients, OctagonState>> returnValues = new HashSet<Pair<IOctagonCoefficients, OctagonState>>();
            for (Pair pair : operand) {
                returnValues.add((Pair<IOctagonCoefficients, OctagonState>)Pair.of((Object)((IOctagonCoefficients)pair.getFirst()).mul(OctagonIntValue.NEG_ONE), (Object)pair.getSecond()));
            }
            return returnValues;
        }

        @Override
        public Set<Pair<IOctagonCoefficients, OctagonState>> visit(CFunctionCallExpression e) throws CPATransferException {
            if (e.getFunctionNameExpression() instanceof CIdExpression) {
                String functionName = ((CIdExpression)e.getFunctionNameExpression()).getName();
                if (functionName.equals("__VERIFIER_nondet_uint")) {
                    return Collections.singleton(Pair.of((Object)OctagonIntervalCoefficients.getNondetUIntCoeffs(this.visitorState.sizeOfVariables(), this.visitorState), (Object)this.visitorState));
                }
                if (functionName.equals("__VERIFIER_nondet_bool")) {
                    return Collections.singleton(Pair.of((Object)OctagonIntervalCoefficients.getNondetBoolCoeffs(this.visitorState.sizeOfVariables(), this.visitorState), (Object)this.visitorState));
                }
            }
            return Collections.singleton(Pair.of((Object)OctagonUniversalCoefficients.INSTANCE, (Object)this.visitorState));
        }
    }
}

