/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon.values;

import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;

public class OctagonDoubleValue
extends OctagonNumericValue<Double> {
    public OctagonDoubleValue(double value) {
        super(value);
    }

    @Override
    public OctagonNumericValue min(OctagonNumericValue val1) {
        return val1.lessThan((Double)this.value) ? val1 : this;
    }

    @Override
    public OctagonNumericValue max(OctagonNumericValue val1) {
        return val1.greaterThan((Double)this.value) ? val1 : this;
    }

    @Override
    public int signum() {
        if (((Double)this.value).longValue() > 0L) {
            return 1;
        }
        if (((Double)this.value).longValue() == 0L) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isInfinite() {
        return ((Double)this.value).isInfinite();
    }

    @Override
    public boolean isInInterval(double lower, double upper) {
        return lower < (Double)this.value && upper > (Double)this.value;
    }

    @Override
    public OctagonNumericValue add(OctagonNumericValue pVal) {
        return pVal.add((Double)this.value);
    }

    @Override
    public OctagonNumericValue add(long pVal) {
        return new OctagonDoubleValue((Double)this.value + (double)pVal);
    }

    @Override
    public OctagonNumericValue add(double pVal) {
        return new OctagonDoubleValue((Double)this.value + pVal);
    }

    @Override
    public OctagonNumericValue subtract(OctagonNumericValue pVal) {
        if (pVal instanceof OctagonIntValue) {
            return new OctagonDoubleValue((Double)this.value - ((Long)((OctagonIntValue)pVal).value).doubleValue());
        }
        if (pVal instanceof OctagonDoubleValue) {
            return new OctagonDoubleValue((Double)this.value - (Double)((OctagonDoubleValue)pVal).value);
        }
        throw new AssertionError((Object)"unknown subtype of octnumericvalue");
    }

    @Override
    public OctagonNumericValue subtract(long pVal) {
        return new OctagonDoubleValue((Double)this.value - (double)pVal);
    }

    @Override
    public OctagonNumericValue subtract(double pVal) {
        return new OctagonDoubleValue((Double)this.value - pVal);
    }

    @Override
    public OctagonNumericValue mul(OctagonNumericValue pVal) {
        return pVal.mul((Double)this.value);
    }

    @Override
    public OctagonNumericValue mul(long pVal) {
        return new OctagonDoubleValue((Double)this.value * (double)pVal);
    }

    @Override
    public OctagonNumericValue mul(double pVal) {
        return new OctagonDoubleValue((Double)this.value * pVal);
    }

    @Override
    public OctagonNumericValue div(OctagonNumericValue pDivisor) {
        if (pDivisor instanceof OctagonIntValue) {
            return new OctagonDoubleValue((Double)this.value / ((Long)((OctagonIntValue)pDivisor).value).doubleValue());
        }
        if (pDivisor instanceof OctagonDoubleValue) {
            return new OctagonDoubleValue((Double)this.value / (Double)((OctagonDoubleValue)pDivisor).value);
        }
        throw new AssertionError((Object)"unknown subtype of octnumericvalue");
    }

    @Override
    public OctagonNumericValue div(long pDivisor) {
        return new OctagonDoubleValue((Double)this.value / (double)pDivisor);
    }

    @Override
    public OctagonNumericValue div(double pDivisor) {
        return new OctagonDoubleValue((Double)this.value / pDivisor);
    }

    @Override
    public boolean greaterEqual(OctagonNumericValue pVal) {
        return pVal.lessEqual((Double)this.value);
    }

    @Override
    public boolean greaterEqual(long pVal) {
        return (Double)this.value >= (double)pVal;
    }

    @Override
    public boolean greaterEqual(double pVal) {
        return (Double)this.value >= pVal;
    }

    @Override
    public boolean greaterThan(OctagonNumericValue pVal) {
        return pVal.lessThan((Double)this.value);
    }

    @Override
    public boolean greaterThan(long pVal) {
        return (Double)this.value > (double)pVal;
    }

    @Override
    public boolean greaterThan(double pVal) {
        return (Double)this.value > pVal;
    }

    @Override
    public boolean lessEqual(OctagonNumericValue pVal) {
        return pVal.greaterEqual((Double)this.value);
    }

    @Override
    public boolean lessEqual(long pVal) {
        return (Double)this.value <= (double)pVal;
    }

    @Override
    public boolean lessEqual(double pVal) {
        return (Double)this.value <= pVal;
    }

    @Override
    public boolean lessThan(OctagonNumericValue pVal) {
        return pVal.greaterThan((Double)this.value);
    }

    @Override
    public boolean lessThan(long pVal) {
        return (Double)this.value < (double)pVal;
    }

    @Override
    public boolean lessThan(double pVal) {
        return (Double)this.value < pVal;
    }

    @Override
    public boolean isEqual(OctagonNumericValue pVal) {
        return pVal.isEqual((Double)this.value);
    }

    @Override
    public boolean isEqual(long pVal) {
        return (Double)this.value == (double)pVal;
    }

    @Override
    public boolean isEqual(double pVal) {
        return (Double)this.value == pVal;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OctagonDoubleValue)) {
            return false;
        }
        OctagonDoubleValue other = (OctagonDoubleValue)obj;
        return ((Double)this.value).equals(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    @Override
    public int compareTo(OctagonNumericValue val) {
        if (val.isEqual((Double)this.value)) {
            return 0;
        }
        if (val.lessThan((Double)this.value)) {
            return 1;
        }
        if (val.greaterThan((Double)this.value)) {
            return -1;
        }
        throw new AssertionError((Object)"implementation fault");
    }

    public String toString() {
        return ((Double)this.value).toString();
    }
}

