/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon.values;

import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;

public class OctagonIntValue
extends OctagonNumericValue<Long> {
    public static final OctagonIntValue ZERO = new OctagonIntValue(0L);
    public static final OctagonIntValue ONE = new OctagonIntValue(1L);
    public static final OctagonIntValue NEG_ONE = new OctagonIntValue(-1L);

    private OctagonIntValue(long value) {
        super(value);
    }

    public static OctagonIntValue of(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        if (value == -1L) {
            return NEG_ONE;
        }
        return new OctagonIntValue(value);
    }

    @Override
    public OctagonNumericValue min(OctagonNumericValue val1) {
        return val1.lessThan((Long)this.value) ? val1 : this;
    }

    @Override
    public OctagonNumericValue max(OctagonNumericValue val1) {
        return val1.greaterThan((Long)this.value) ? val1 : this;
    }

    @Override
    public int signum() {
        if ((Long)this.value > 0L) {
            return 1;
        }
        if ((Long)this.value == 0L) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean isInInterval(double lower, double upper) {
        return lower < ((Long)this.value).doubleValue() && upper > ((Long)this.value).doubleValue();
    }

    @Override
    public OctagonNumericValue add(OctagonNumericValue pVal) {
        return pVal.add((Long)this.value);
    }

    @Override
    public OctagonNumericValue add(long pVal) {
        return OctagonIntValue.of((Long)this.value + pVal);
    }

    @Override
    public OctagonNumericValue add(double pVal) {
        return new OctagonDoubleValue((double)((Long)this.value).longValue() + pVal);
    }

    @Override
    public OctagonNumericValue subtract(OctagonNumericValue pVal) {
        if (pVal instanceof OctagonIntValue) {
            return OctagonIntValue.of((Long)this.value - (Long)((OctagonIntValue)pVal).value);
        }
        if (pVal instanceof OctagonDoubleValue) {
            return new OctagonDoubleValue((double)((Long)this.value).longValue() - (Double)((OctagonDoubleValue)pVal).value);
        }
        throw new AssertionError((Object)"unknown subtype of octnumericvalue");
    }

    @Override
    public OctagonNumericValue subtract(long pVal) {
        return OctagonIntValue.of((Long)this.value - pVal);
    }

    @Override
    public OctagonNumericValue subtract(double pVal) {
        return new OctagonDoubleValue((double)((Long)this.value).longValue() - pVal);
    }

    @Override
    public OctagonNumericValue mul(OctagonNumericValue pVal) {
        return pVal.mul((Long)this.value);
    }

    @Override
    public OctagonNumericValue mul(long pVal) {
        long newValue = (Long)this.value * pVal;
        if (newValue < 0L && (Long)this.value < 0L && pVal < 0L) {
            newValue = Long.MAX_VALUE;
        }
        return OctagonIntValue.of(newValue);
    }

    @Override
    public OctagonNumericValue mul(double pVal) {
        return new OctagonDoubleValue((double)((Long)this.value).longValue() * pVal);
    }

    @Override
    public OctagonNumericValue div(OctagonNumericValue pDivisor) {
        if (pDivisor instanceof OctagonIntValue) {
            return OctagonIntValue.of((Long)this.value / (Long)((OctagonIntValue)pDivisor).value);
        }
        if (pDivisor instanceof OctagonDoubleValue) {
            return new OctagonDoubleValue((double)((Long)this.value).longValue() / (Double)((OctagonDoubleValue)pDivisor).value);
        }
        throw new AssertionError((Object)"unknown subtype of octnumericvalue");
    }

    @Override
    public OctagonNumericValue div(long pDivisor) {
        return OctagonIntValue.of((Long)this.value / pDivisor);
    }

    @Override
    public OctagonNumericValue div(double pDivisor) {
        return new OctagonDoubleValue((double)((Long)this.value).longValue() / pDivisor);
    }

    @Override
    public boolean greaterEqual(OctagonNumericValue pVal) {
        return pVal.lessEqual((Long)this.value);
    }

    @Override
    public boolean greaterEqual(long pVal) {
        return (Long)this.value >= pVal;
    }

    @Override
    public boolean greaterEqual(double pVal) {
        return (double)((Long)this.value).longValue() >= pVal;
    }

    @Override
    public boolean greaterThan(OctagonNumericValue pVal) {
        return pVal.lessThan((Long)this.value);
    }

    @Override
    public boolean greaterThan(long pVal) {
        return (Long)this.value > pVal;
    }

    @Override
    public boolean greaterThan(double pVal) {
        return (double)((Long)this.value).longValue() > pVal;
    }

    @Override
    public boolean lessEqual(OctagonNumericValue pVal) {
        return pVal.greaterEqual((Long)this.value);
    }

    @Override
    public boolean lessEqual(long pVal) {
        return (Long)this.value <= pVal;
    }

    @Override
    public boolean lessEqual(double pVal) {
        return (double)((Long)this.value).longValue() <= pVal;
    }

    @Override
    public boolean lessThan(OctagonNumericValue pVal) {
        return pVal.greaterThan((Long)this.value);
    }

    @Override
    public boolean lessThan(long pVal) {
        return (Long)this.value < pVal;
    }

    @Override
    public boolean lessThan(double pVal) {
        return (double)((Long)this.value).longValue() < pVal;
    }

    @Override
    public boolean isEqual(OctagonNumericValue pVal) {
        return pVal.isEqual((Long)this.value);
    }

    @Override
    public boolean isEqual(long pVal) {
        return (Long)this.value == pVal;
    }

    @Override
    public boolean isEqual(double pVal) {
        return (double)((Long)this.value).longValue() == pVal;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OctagonIntValue)) {
            return false;
        }
        OctagonIntValue other = (OctagonIntValue)obj;
        return ((Long)this.value).equals(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    @Override
    public int compareTo(OctagonNumericValue val) {
        if (val.isEqual((Long)this.value)) {
            return 0;
        }
        if (val.lessThan((Long)this.value)) {
            return 1;
        }
        if (val.greaterThan((Long)this.value)) {
            return -1;
        }
        throw new AssertionError((Object)"implementation fault");
    }

    public String toString() {
        return ((Long)this.value).toString();
    }
}

