/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.octagon.values;

import java.util.Arrays;
import java.util.Collections;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonDoubleValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonIntValue;
import org.sosy_lab.cpachecker.cpa.octagon.values.OctagonNumericValue;

public class OctagonInterval {
    private final OctagonNumericValue low;
    private final OctagonNumericValue high;
    public static final OctagonInterval EMPTY = OctagonInterval.createEmptyOctInterval();
    public static final OctagonInterval FALSE = new OctagonInterval(OctagonIntValue.ZERO, OctagonIntValue.ZERO);
    public static final OctagonInterval DELTA = new OctagonInterval(-1.0E-5, 1.0E-5);

    private OctagonInterval() {
        this.low = null;
        this.high = null;
    }

    public OctagonInterval(Long value) {
        this.low = OctagonIntValue.of(value);
        this.high = OctagonIntValue.of(value);
    }

    public OctagonInterval(Long low, Long high) {
        this.low = OctagonIntValue.of(low);
        this.high = OctagonIntValue.of(high);
        this.isSane();
    }

    public OctagonInterval(double low, double high) {
        this.low = new OctagonDoubleValue(low);
        this.high = new OctagonDoubleValue(high);
        this.isSane();
    }

    public OctagonInterval(OctagonNumericValue low, OctagonNumericValue high) {
        this.low = low;
        this.high = high;
        this.isSane();
    }

    public OctagonInterval(OctagonNumericValue pValue) {
        this.low = pValue;
        this.high = pValue;
    }

    private boolean isSane() {
        if (this.low.greaterThan(this.high)) {
            throw new IllegalStateException("low cannot be larger than high");
        }
        return true;
    }

    public boolean isInfinite() {
        boolean isInfinite = false;
        if (this.low instanceof OctagonDoubleValue) {
            isInfinite = ((Double)((OctagonDoubleValue)this.low).getValue()).isInfinite();
        }
        if (!isInfinite && this.high instanceof OctagonDoubleValue) {
            isInfinite = ((Double)((OctagonDoubleValue)this.high).getValue()).isInfinite();
        }
        return isInfinite;
    }

    public OctagonNumericValue getLow() {
        return this.low;
    }

    public OctagonNumericValue getHigh() {
        return this.high;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OctagonInterval)) {
            return false;
        }
        OctagonInterval other = (OctagonInterval)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.low.isEqual(other.low) && this.high.isEqual(other.high);
    }

    public boolean isSingular() {
        return this.low.isEqual(this.high);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int result = 17;
        result = 31 * result + this.low.hashCode();
        result = 31 * result + this.high.hashCode();
        return result;
    }

    public OctagonInterval union(OctagonInterval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return OctagonInterval.createEmptyOctInterval();
        }
        return new OctagonInterval(this.low.min(other.low), this.high.max(other.high));
    }

    public OctagonInterval intersect(OctagonInterval other) {
        OctagonInterval OctInterval = null;
        OctInterval = this.intersects(other) ? new OctagonInterval(this.low.max(other.low), this.high.max(other.high)) : OctagonInterval.createEmptyOctInterval();
        return OctInterval;
    }

    public boolean isLessThan(OctagonInterval other) {
        return !this.isEmpty() && !other.isEmpty() && this.high.lessThan(other.low);
    }

    public boolean isGreaterThan(OctagonInterval other) {
        return !this.isEmpty() && !other.isEmpty() && this.low.greaterThan(other.high);
    }

    public boolean mayBeLessThan(OctagonInterval other) {
        return this.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.low.lessThan(other.high);
    }

    public boolean mayBeLessOrEqualThan(OctagonInterval other) {
        return this.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.low.lessEqual(other.high);
    }

    public boolean mayBeGreaterThan(OctagonInterval other) {
        return other.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.high.greaterEqual(other.low);
    }

    public boolean mayBeGreaterOrEqualThan(OctagonInterval other) {
        return other.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.high.greaterEqual(other.low);
    }

    public boolean isTrue() {
        return !this.isEmpty() && (this.high.lessThan(0L) || this.low.greaterThan(0L));
    }

    public OctagonInterval minimum(OctagonInterval other) {
        OctagonInterval OctInterval = new OctagonInterval(this.low.min(other.low), this.high.min(other.high));
        return OctInterval;
    }

    public OctagonInterval maximum(OctagonInterval other) {
        OctagonInterval OctInterval = new OctagonInterval(this.low.max(other.low), this.high.max(other.high));
        return OctInterval;
    }

    public OctagonInterval limitLowerBoundBy(OctagonInterval other) {
        OctagonInterval OctInterval = null;
        OctInterval = this.isEmpty() || other.isEmpty() || this.high.lessEqual(other.low) ? OctagonInterval.createEmptyOctInterval() : new OctagonInterval(this.low.max(other.low), this.high);
        return OctInterval;
    }

    public OctagonInterval limitUpperBoundBy(OctagonInterval other) {
        OctagonInterval OctInterval = null;
        OctInterval = this.isEmpty() || other.isEmpty() || this.low.greaterThan(other.high) ? OctagonInterval.createEmptyOctInterval() : new OctagonInterval(this.low, this.high.min(other.high));
        return OctInterval;
    }

    public boolean intersects(OctagonInterval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.low.greaterEqual(other.low) && this.low.lessEqual(other.high) || this.high.greaterEqual(other.low) && this.high.lessEqual(other.high) || this.low.lessEqual(other.low) && this.high.greaterEqual(other.high);
    }

    public boolean contains(OctagonInterval other) {
        return !this.isEmpty() && !other.isEmpty() && this.low.lessEqual(other.low) && other.high.lessEqual(this.high);
    }

    public OctagonInterval plus(OctagonInterval OctInterval) {
        if (this.isEmpty() || OctInterval.isEmpty()) {
            return OctagonInterval.createEmptyOctInterval();
        }
        return new OctagonInterval(OctagonInterval.scalarPlus(this.low, OctInterval.low), OctagonInterval.scalarPlus(this.high, OctInterval.high));
    }

    public OctagonInterval plus(Long offset) {
        return this.plus(new OctagonInterval(offset, offset));
    }

    public OctagonInterval minus(OctagonInterval other) {
        return this.plus(other.negate());
    }

    public OctagonInterval minus(Long offset) {
        return this.plus(-offset.longValue());
    }

    public OctagonInterval times(OctagonInterval other) {
        OctagonNumericValue[] values = new OctagonNumericValue[]{OctagonInterval.scalarTimes(this.low, other.low), OctagonInterval.scalarTimes(this.low, other.high), OctagonInterval.scalarTimes(this.high, other.low), OctagonInterval.scalarTimes(this.high, other.high)};
        return new OctagonInterval(Collections.min(Arrays.asList(values)), Collections.max(Arrays.asList(values)));
    }

    public OctagonInterval divide(OctagonInterval other) {
        if (other.contains(FALSE)) {
            return OctagonInterval.createUnboundOctInterval();
        }
        OctagonNumericValue[] values = new OctagonNumericValue[]{this.low.div(other.low), this.low.div(other.high), this.high.div(other.low), this.high.div(other.high)};
        return new OctagonInterval(Collections.min(Arrays.asList(values)), Collections.max(Arrays.asList(values)));
    }

    public OctagonInterval negate() {
        return new OctagonInterval(this.high.mul(OctagonIntValue.NEG_ONE), this.low.mul(OctagonIntValue.NEG_ONE));
    }

    public boolean isEmpty() {
        return this.low == null && this.high == null;
    }

    public String toString() {
        return "[" + this.low + "; " + this.high + "]";
    }

    private static OctagonInterval createEmptyOctInterval() {
        return new OctagonInterval();
    }

    public static OctagonInterval createUnboundOctInterval() {
        return new OctagonInterval(-9.223372036854776E18, 9.223372036854776E18);
    }

    public static OctagonInterval createFalseOctInterval() {
        return new OctagonInterval(0L);
    }

    public static OctagonInterval createTrueOctInterval() {
        return new OctagonInterval(1L);
    }

    private static OctagonNumericValue scalarPlus(OctagonNumericValue x, OctagonNumericValue y) {
        OctagonNumericValue result = x.add(y);
        return result;
    }

    private static OctagonNumericValue scalarTimes(OctagonNumericValue x, OctagonNumericValue y) {
        if (x.equals(OctagonIntValue.ONE)) {
            return y;
        }
        if (y.equals(OctagonIntValue.ONE)) {
            return x;
        }
        Long bound = x.signum() == y.signum() ? Long.MAX_VALUE : Long.MIN_VALUE;
        if (!x.isEqual(0L) && (y.greaterThan(0L) && y.greaterThan(OctagonIntValue.ONE.div(x).mul(bound)) || y.lessThan(0L) && y.lessThan(OctagonIntValue.ONE.div(x).mul(bound)))) {
            return OctagonIntValue.of(bound);
        }
        return x.mul(y);
    }
}

