/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.partitioning;

import com.google.common.base.Objects;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.IdentityTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;

public class PartitioningCPA
implements ConfigurableProgramAnalysis {
    private final AbstractDomain abstractDomain = new FlatLatticeDomain();
    private final StopOperator stopOperator = new StopJoinOperator(this.abstractDomain);
    private final MergeOperator mergeOperator = new MergeJoinOperator(this.abstractDomain);
    private final TransferRelation transferRelation = IdentityTransferRelation.INSTANCE;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PartitioningCPA.class);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new PartitionState(pPartition);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }

    public static class PartitionState
    implements AbstractState {
        private final StateSpacePartition partition;

        public PartitionState(StateSpacePartition pPartition) {
            this.partition = pPartition;
        }

        public StateSpacePartition getStateSpacePartition() {
            return this.partition;
        }

        public String toString() {
            if (this.partition == null) {
                return "PARTITION [NULL]";
            }
            return "PARTITION " + this.partition.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object[])new Object[]{this.partition});
            return result;
        }

        public boolean equals(Object pObj) {
            if (!(pObj instanceof PartitionState)) {
                return false;
            }
            return Objects.equal((Object)this.partition, (Object)((PartitionState)pObj).partition);
        }
    }
}

