/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.partitioning;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.partitioning.PartitioningCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class PartitioningCPATest {
    private PartitioningCPA cpa;
    private AbstractDomain domain;

    @Before
    public void setUp() throws Exception {
        this.cpa = new PartitioningCPA();
        this.domain = this.cpa.getAbstractDomain();
    }

    @Test
    public void testIsLessOrEqual_EqualPartition() throws CPAException, InterruptedException {
        AbstractState p1 = this.cpa.getInitialState(TestDataTools.DUMMY_CFA_NODE, StateSpacePartition.getPartitionWithKey((Object)CPAchecker.InitialStatesFor.ENTRY));
        AbstractState p2 = this.cpa.getInitialState(TestDataTools.DUMMY_CFA_NODE, StateSpacePartition.getPartitionWithKey((Object)CPAchecker.InitialStatesFor.ENTRY));
        Truth.assertThat((Object)p1).isEqualTo((Object)p2);
        Truth.assertThat((Boolean)this.domain.isLessOrEqual(p1, p2)).isTrue();
    }

    @Test
    public void testMerge_EqualPartition() throws CPAException, InterruptedException {
        AbstractState p1 = this.cpa.getInitialState(TestDataTools.DUMMY_CFA_NODE, StateSpacePartition.getPartitionWithKey((Object)CPAchecker.InitialStatesFor.ENTRY));
        AbstractState p2 = this.cpa.getInitialState(TestDataTools.DUMMY_CFA_NODE, StateSpacePartition.getPartitionWithKey((Object)CPAchecker.InitialStatesFor.ENTRY));
        AbstractState mergeResult = this.cpa.getMergeOperator().merge(p1, p2, SingletonPrecision.getInstance());
        Truth.assertThat((Object)mergeResult).isEqualTo((Object)p2);
    }

    @Test
    public void testIsLessOrEqual_DifferentPartitions() throws CPAException, InterruptedException {
        AbstractState p1 = this.cpa.getInitialState(TestDataTools.DUMMY_CFA_NODE, StateSpacePartition.getPartitionWithKey((Object)CPAchecker.InitialStatesFor.ENTRY));
        AbstractState p2 = this.cpa.getInitialState(TestDataTools.DUMMY_CFA_NODE, StateSpacePartition.getPartitionWithKey((Object)CPAchecker.InitialStatesFor.EXIT));
        Truth.assertThat((Object)p1).isNotEqualTo((Object)p2);
        Truth.assertThat((Boolean)this.domain.isLessOrEqual(p1, p2)).isFalse();
    }
}

