/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer2;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetBot;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetTop;

public class PointerState
implements AbstractState {
    public static final PointerState INITIAL_STATE = new PointerState();
    private final PersistentSortedMap<String, LocationSet> pointsToMap;

    private PointerState() {
        this.pointsToMap = PathCopyingPersistentTreeMap.of();
    }

    private PointerState(PersistentSortedMap<String, LocationSet> pPointsToMap) {
        this.pointsToMap = pPointsToMap;
    }

    public PointerState addPointsToInformation(String pSource, String pTarget) {
        LocationSet previousPointsToSet = this.getPointsToSet(pSource);
        LocationSet newPointsToSet = previousPointsToSet.addElement(pTarget);
        return new PointerState((PersistentSortedMap<String, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)newPointsToSet));
    }

    public PointerState addPointsToInformation(String pSource, Iterable<String> pTargets) {
        LocationSet previousPointsToSet = this.getPointsToSet(pSource);
        LocationSet newPointsToSet = previousPointsToSet.addElements(pTargets);
        return new PointerState((PersistentSortedMap<String, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)newPointsToSet));
    }

    public PointerState addPointsToInformation(String pSource, LocationSet pTargets) {
        if (pTargets.isBot()) {
            return this;
        }
        if (pTargets.isTop()) {
            return new PointerState((PersistentSortedMap<String, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)LocationSetTop.INSTANCE));
        }
        LocationSet previousPointsToSet = this.getPointsToSet(pSource);
        return new PointerState((PersistentSortedMap<String, LocationSet>)this.pointsToMap.putAndCopy((Object)pSource, (Object)previousPointsToSet.addElements(pTargets)));
    }

    public LocationSet getPointsToSet(String pSource) {
        LocationSet result = (LocationSet)this.pointsToMap.get((Object)pSource);
        if (result == null) {
            return LocationSetBot.INSTANCE;
        }
        return result;
    }

    @Nullable
    public Boolean pointsTo(String pSource, String pTarget) {
        LocationSet pointsToSet = this.getPointsToSet(pSource);
        if (pointsToSet.equals(LocationSetBot.INSTANCE)) {
            return false;
        }
        if (pointsToSet instanceof ExplicitLocationSet) {
            ExplicitLocationSet explicitLocationSet = (ExplicitLocationSet)pointsToSet;
            if (explicitLocationSet.mayPointTo(pTarget)) {
                return explicitLocationSet.getSize() == 1 ? Boolean.valueOf(true) : null;
            }
            return false;
        }
        return null;
    }

    public boolean definitelyPointsTo(String pSource, String pTarget) {
        return Boolean.TRUE.equals(this.pointsTo(pSource, pTarget));
    }

    public boolean definitelyNotPointsTo(String pSource, String pTarget) {
        return Boolean.FALSE.equals(this.pointsTo(pSource, pTarget));
    }

    public boolean mayPointTo(String pSource, String pTarget) {
        return !Boolean.FALSE.equals(this.pointsTo(pSource, pTarget));
    }

    public Set<String> getKnownLocations() {
        return FluentIterable.from((Iterable)Iterables.concat((Iterable)this.pointsToMap.keySet(), (Iterable)FluentIterable.from((Iterable)this.pointsToMap.values()).transformAndConcat((Function)new Function<LocationSet, Iterable<? extends String>>(){

            public Iterable<? extends String> apply(LocationSet pArg0) {
                if (pArg0 instanceof ExplicitLocationSet) {
                    return (ExplicitLocationSet)pArg0;
                }
                return Collections.emptySet();
            }
        }))).toSet();
    }

    public Map<String, LocationSet> getPointsToMap() {
        return Collections.unmodifiableMap(this.pointsToMap);
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof PointerState) {
            return this.pointsToMap.equals(((PointerState)pO).pointsToMap);
        }
        return false;
    }

    public int hashCode() {
        return this.pointsToMap.hashCode();
    }

    public String toString() {
        return this.pointsToMap.toString();
    }
}

