/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer2;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetBot;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetTop;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public class PointerTransferRelation
extends SingleEdgeTransferRelation {
    static final TransferRelation INSTANCE = new PointerTransferRelation();
    private static final String RETURN_VARIABLE_BASE_NAME = "___cpa_temp_result_var_";

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        PointerState pointerState = (PointerState)pState;
        PointerState resultState = this.getAbstractSuccessor(pointerState, pPrecision, pCfaEdge);
        return resultState == null ? Collections.emptySet() : Collections.singleton(resultState);
    }

    private PointerState getAbstractSuccessor(PointerState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        PointerState resultState = pState;
        switch (pCfaEdge.getEdgeType()) {
            case AssumeEdge: {
                break;
            }
            case BlankEdge: {
                break;
            }
            case CallToReturnEdge: {
                break;
            }
            case DeclarationEdge: {
                resultState = this.handleDeclarationEdge(pState, pPrecision, (CDeclarationEdge)pCfaEdge);
                break;
            }
            case FunctionCallEdge: {
                resultState = this.handleFunctionCallEdge(pState, pPrecision, (CFunctionCallEdge)pCfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                break;
            }
            case MultiEdge: {
                for (CFAEdge edge : (MultiEdge)pCfaEdge) {
                    resultState = this.getAbstractSuccessor(resultState, pPrecision, edge);
                }
                break;
            }
            case ReturnStatementEdge: {
                resultState = this.handleReturnStatementEdge(pState, pPrecision, (CReturnStatementEdge)pCfaEdge);
                break;
            }
            case StatementEdge: {
                resultState = this.handleStatementEdge(pState, pPrecision, (CStatementEdge)pCfaEdge);
                break;
            }
            default: {
                throw new UnrecognizedCCodeException("Unrecognized CFA edge.", pCfaEdge);
            }
        }
        return resultState;
    }

    private PointerState handleReturnStatementEdge(PointerState pState, Precision pPrecision, CReturnStatementEdge pCfaEdge) throws UnrecognizedCCodeException {
        if (!pCfaEdge.getExpression().isPresent()) {
            return pState;
        }
        return this.handleAssignment(pState, pPrecision, RETURN_VARIABLE_BASE_NAME + pCfaEdge.getSuccessor().getFunctionName(), (CRightHandSide)pCfaEdge.getExpression().get());
    }

    private PointerState handleFunctionCallEdge(PointerState pState, Precision pPrecision, CFunctionCallEdge pCFunctionCallEdge) throws UnrecognizedCCodeException {
        PointerState newState = pState;
        ImmutableList formalParams = pCFunctionCallEdge.getSuccessor().getFunctionParameters();
        ImmutableList actualParams = pCFunctionCallEdge.getArguments();
        int limit = Math.min(formalParams.size(), actualParams.size());
        formalParams = FluentIterable.from(formalParams).limit(limit).toList();
        actualParams = FluentIterable.from(actualParams).limit(limit).toList();
        for (Pair param : Pair.zipList((Collection)formalParams, (Collection)actualParams)) {
            CExpression actualParam = (CExpression)param.getSecond();
            CParameterDeclaration formalParam = (CParameterDeclaration)param.getFirst();
            CType type = formalParam.getType();
            String location = ((Object)type).toString().startsWith("struct ") || ((Object)type).toString().startsWith("union ") ? ((Object)type).toString() : formalParam.getQualifiedName();
            newState = this.handleAssignment(pState, pPrecision, location, PointerTransferRelation.asLocations(actualParam, pState, 1));
        }
        for (CParameterDeclaration formalParam : FluentIterable.from((Iterable)formalParams).skip(limit)) {
            CType type = formalParam.getType();
            String location = ((Object)type).toString().startsWith("struct ") || ((Object)type).toString().startsWith("union ") ? ((Object)type).toString() : formalParam.getQualifiedName();
            newState = this.handleAssignment(pState, pPrecision, location, LocationSetBot.INSTANCE);
        }
        return newState;
    }

    private PointerState handleStatementEdge(PointerState pState, Precision pPrecision, CStatementEdge pCfaEdge) throws UnrecognizedCCodeException {
        if (pCfaEdge.getStatement() instanceof CAssignment) {
            CAssignment assignment = (CAssignment)pCfaEdge.getStatement();
            return this.handleAssignment(pState, pPrecision, assignment.getLeftHandSide(), assignment.getRightHandSide());
        }
        return pState;
    }

    private PointerState handleAssignment(PointerState pState, Precision pPrecision, CExpression pLeftHandSide, CRightHandSide pRightHandSide) throws UnrecognizedCCodeException {
        LocationSet locations = PointerTransferRelation.asLocations(pLeftHandSide, pState, 0);
        return this.handleAssignment(pState, pPrecision, locations, pRightHandSide);
    }

    private PointerState handleAssignment(PointerState pState, Precision pPrecision, LocationSet pLocationSet, CRightHandSide pRightHandSide) throws UnrecognizedCCodeException {
        Iterable<String> locations = pLocationSet.isTop() ? pState.getKnownLocations() : (pLocationSet instanceof ExplicitLocationSet ? (ExplicitLocationSet)pLocationSet : Collections.emptySet());
        PointerState result = pState;
        for (String location : locations) {
            result = this.handleAssignment(result, pPrecision, location, pRightHandSide);
        }
        return result;
    }

    private PointerState handleAssignment(PointerState pState, Precision pPrecision, String pLhsLocation, CRightHandSide pRightHandSide) throws UnrecognizedCCodeException {
        return pState.addPointsToInformation(pLhsLocation, PointerTransferRelation.asLocations(pRightHandSide, pState, 1));
    }

    private PointerState handleAssignment(PointerState pState, Precision pPrecision, String pLeftHandSide, LocationSet pRightHandSide) throws UnrecognizedCCodeException {
        return pState.addPointsToInformation(pLeftHandSide, pRightHandSide);
    }

    private PointerState handleDeclarationEdge(final PointerState pState, Precision pPrecision, CDeclarationEdge pCfaEdge) throws UnrecognizedCCodeException {
        if (!(pCfaEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return pState;
        }
        CType type = pCfaEdge.getDeclaration().getType();
        CVariableDeclaration declaration = (CVariableDeclaration)pCfaEdge.getDeclaration();
        CInitializer initializer = declaration.getInitializer();
        if (initializer != null) {
            LocationSet rhs = initializer.accept(new CInitializerVisitor<LocationSet, UnrecognizedCCodeException>(){

                @Override
                public LocationSet visit(CInitializerExpression pInitializerExpression) throws UnrecognizedCCodeException {
                    return PointerTransferRelation.asLocations(pInitializerExpression.getExpression(), pState, 1);
                }

                @Override
                public LocationSet visit(CInitializerList pInitializerList) throws UnrecognizedCCodeException {
                    return LocationSetTop.INSTANCE;
                }

                @Override
                public LocationSet visit(CDesignatedInitializer pCStructInitializerPart) throws UnrecognizedCCodeException {
                    return LocationSetTop.INSTANCE;
                }
            });
            String location = ((Object)type).toString().startsWith("struct ") || ((Object)type).toString().startsWith("union ") ? ((Object)type).toString() : declaration.getQualifiedName();
            return this.handleAssignment(pState, pPrecision, location, rhs);
        }
        return pState;
    }

    private static LocationSet toLocationSet(Iterable<? extends String> pLocations) {
        if (pLocations == null) {
            return LocationSetTop.INSTANCE;
        }
        Iterator<? extends String> locationIterator = pLocations.iterator();
        if (!locationIterator.hasNext()) {
            return LocationSetBot.INSTANCE;
        }
        return ExplicitLocationSet.from(pLocations);
    }

    private static LocationSet asLocations(CRightHandSide pExpression, final PointerState pState, final int pDerefCounter) throws UnrecognizedCCodeException {
        return pExpression.accept(new CRightHandSideVisitor<LocationSet, UnrecognizedCCodeException>(){

            @Override
            public LocationSet visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnrecognizedCCodeException {
                CLiteralExpression literal;
                if (pIastArraySubscriptExpression.getSubscriptExpression() instanceof CLiteralExpression && (literal = (CLiteralExpression)pIastArraySubscriptExpression.getSubscriptExpression()) instanceof CIntegerLiteralExpression && ((CIntegerLiteralExpression)literal).getValue().equals(BigInteger.ZERO)) {
                    LocationSet starredLocations = PointerTransferRelation.asLocations(pIastArraySubscriptExpression.getArrayExpression(), pState, pDerefCounter);
                    if (starredLocations.isBot() || starredLocations.isTop()) {
                        return starredLocations;
                    }
                    if (!(starredLocations instanceof ExplicitLocationSet)) {
                        return LocationSetTop.INSTANCE;
                    }
                    HashSet<String> result = new HashSet<String>();
                    for (String location : (ExplicitLocationSet)starredLocations) {
                        LocationSet pointsToSet = pState.getPointsToSet(location);
                        if (pointsToSet.isTop()) {
                            for (String loc : pState.getKnownLocations()) {
                                result.add(loc);
                            }
                            break;
                        }
                        if (pointsToSet.isBot() || !(pointsToSet instanceof ExplicitLocationSet)) continue;
                        ExplicitLocationSet explicitLocationSet = (ExplicitLocationSet)pointsToSet;
                        Iterables.addAll(result, (Iterable)explicitLocationSet);
                    }
                    return PointerTransferRelation.toLocationSet(result);
                }
                return LocationSetTop.INSTANCE;
            }

            @Override
            public LocationSet visit(CFieldReference pIastFieldReference) throws UnrecognizedCCodeException {
                CType type = pIastFieldReference.getFieldOwner().getExpressionType();
                String prefix = ((Object)type).toString();
                String infix = pIastFieldReference.isPointerDereference() ? "->" : ".";
                String suffix = pIastFieldReference.getFieldName();
                return PointerTransferRelation.toLocationSet(Collections.singleton(prefix + infix + suffix));
            }

            @Override
            public LocationSet visit(CIdExpression pIastIdExpression) throws UnrecognizedCCodeException {
                CSimpleDeclaration declaration;
                CType type = pIastIdExpression.getExpressionType();
                String location = ((Object)type).toString().startsWith("struct ") || ((Object)type).toString().startsWith("union ") ? ((Object)type).toString() : ((declaration = pIastIdExpression.getDeclaration()) != null ? declaration.getQualifiedName() : pIastIdExpression.getName());
                return this.visit(location);
            }

            private LocationSet visit(String pLocation) {
                Set<String> result = Collections.singleton(pLocation);
                for (int deref = pDerefCounter; deref > 0 && !result.isEmpty(); --deref) {
                    HashSet<String> newResult = new HashSet<String>();
                    for (String location : result) {
                        LocationSet targets = pState.getPointsToSet(location);
                        if (targets.isTop() || targets.isBot()) {
                            return targets;
                        }
                        if (!(targets instanceof ExplicitLocationSet)) {
                            return LocationSetTop.INSTANCE;
                        }
                        Iterables.addAll(newResult, (Iterable)((ExplicitLocationSet)targets));
                    }
                    result = newResult;
                }
                return PointerTransferRelation.toLocationSet(result);
            }

            @Override
            public LocationSet visit(CPointerExpression pPointerExpression) throws UnrecognizedCCodeException {
                return PointerTransferRelation.asLocations(pPointerExpression.getOperand(), pState, pDerefCounter + 1);
            }

            @Override
            public LocationSet visit(CComplexCastExpression pComplexCastExpression) throws UnrecognizedCCodeException {
                return PointerTransferRelation.asLocations(pComplexCastExpression.getOperand(), pState, pDerefCounter);
            }

            @Override
            public LocationSet visit(CBinaryExpression pIastBinaryExpression) throws UnrecognizedCCodeException {
                return PointerTransferRelation.toLocationSet(Iterables.concat(PointerTransferRelation.toNormalSet(pState, PointerTransferRelation.asLocations(pIastBinaryExpression.getOperand1(), pState, pDerefCounter)), PointerTransferRelation.toNormalSet(pState, PointerTransferRelation.asLocations(pIastBinaryExpression.getOperand2(), pState, pDerefCounter))));
            }

            @Override
            public LocationSet visit(CCastExpression pIastCastExpression) throws UnrecognizedCCodeException {
                return PointerTransferRelation.asLocations(pIastCastExpression.getOperand(), pState, pDerefCounter);
            }

            @Override
            public LocationSet visit(CCharLiteralExpression pIastCharLiteralExpression) throws UnrecognizedCCodeException {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CFloatLiteralExpression pIastFloatLiteralExpression) throws UnrecognizedCCodeException {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) throws UnrecognizedCCodeException {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CStringLiteralExpression pIastStringLiteralExpression) throws UnrecognizedCCodeException {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CTypeIdExpression pIastTypeIdExpression) throws UnrecognizedCCodeException {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CUnaryExpression pIastUnaryExpression) throws UnrecognizedCCodeException {
                if (pDerefCounter > 0 && pIastUnaryExpression.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                    return PointerTransferRelation.asLocations(pIastUnaryExpression.getOperand(), pState, pDerefCounter - 1);
                }
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CImaginaryLiteralExpression PIastLiteralExpression) throws UnrecognizedCCodeException {
                return LocationSetBot.INSTANCE;
            }

            @Override
            public LocationSet visit(CFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCCodeException {
                CFunctionDeclaration declaration = pIastFunctionCallExpression.getDeclaration();
                if (declaration == null) {
                    LocationSet result = pIastFunctionCallExpression.getFunctionNameExpression().accept(this);
                    if (result.isTop() || result.isBot()) {
                        return result;
                    }
                    return PointerTransferRelation.toLocationSet((Iterable)FluentIterable.from(PointerTransferRelation.toNormalSet(pState, result)).transform((Function)new Function<String, String>(){

                        public String apply(String pArg0) {
                            if (pArg0 == null) {
                                return null;
                            }
                            return PointerTransferRelation.RETURN_VARIABLE_BASE_NAME + pArg0;
                        }
                    }).filter(Predicates.notNull()));
                }
                return this.visit(PointerTransferRelation.RETURN_VARIABLE_BASE_NAME + declaration.getQualifiedName());
            }

            @Override
            public LocationSet visit(CAddressOfLabelExpression pAddressOfLabelExpression) throws UnrecognizedCCodeException {
                throw new UnrecognizedCCodeException("Address of labels not supported by pointer analysis", pAddressOfLabelExpression);
            }
        });
    }

    public static LocationSet asLocations(CExpression pExpression, PointerState pState) throws UnrecognizedCCodeException {
        return PointerTransferRelation.asLocations(pExpression, pState, 0);
    }

    public static Iterable<String> toNormalSet(PointerState pState, LocationSet pLocationSet) {
        if (pLocationSet.isBot()) {
            return Collections.emptySet();
        }
        if (pLocationSet.isTop() || !(pLocationSet instanceof ExplicitLocationSet)) {
            return pState.getKnownLocations();
        }
        return (ExplicitLocationSet)pLocationSet;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return Collections.singleton(pState);
    }
}

