/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.pointer2.util;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetBot;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSetTop;

public class ExplicitLocationSet
implements LocationSet,
Iterable<String> {
    private final Set<String> explicitSet;

    private ExplicitLocationSet(ImmutableSet<String> pLocations) {
        assert (pLocations.size() >= 1);
        this.explicitSet = pLocations;
    }

    @Override
    public boolean mayPointTo(String pLocation) {
        return this.explicitSet.contains(pLocation);
    }

    @Override
    public LocationSet addElement(String pLocation) {
        if (this.explicitSet.contains(pLocation)) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.explicitSet).add((Object)pLocation);
        return new ExplicitLocationSet((ImmutableSet<String>)builder.build());
    }

    @Override
    public LocationSet addElements(Iterable<String> pLocations) {
        ImmutableSet.Builder builder = null;
        for (String target : pLocations) {
            if (this.explicitSet.contains(target)) continue;
            if (builder == null) {
                builder = ImmutableSet.builder();
                builder.addAll(this.explicitSet);
            }
            builder.add((Object)target);
        }
        if (builder == null) {
            return this;
        }
        return new ExplicitLocationSet((ImmutableSet<String>)builder.build());
    }

    @Override
    public LocationSet removeElement(String pLocation) {
        if (!this.explicitSet.contains(pLocation)) {
            return this;
        }
        if (this.getSize() == 1) {
            return LocationSetBot.INSTANCE;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String location : this.explicitSet) {
            if (location.equals(pLocation)) continue;
            builder.add((Object)location);
        }
        return new ExplicitLocationSet((ImmutableSet<String>)builder.build());
    }

    public static LocationSet from(String pLocation) {
        return new ExplicitLocationSet((ImmutableSet<String>)ImmutableSet.of((Object)pLocation));
    }

    public static LocationSet from(Iterable<? extends String> pLocations) {
        Iterator<? extends String> elementIterator = pLocations.iterator();
        if (!elementIterator.hasNext()) {
            return LocationSetBot.INSTANCE;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        while (elementIterator.hasNext()) {
            String location = elementIterator.next();
            builder.add((Object)location);
        }
        return new ExplicitLocationSet((ImmutableSet<String>)builder.build());
    }

    @Override
    public boolean isBot() {
        return this.explicitSet.isEmpty();
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public LocationSet addElements(LocationSet pElements) {
        if (pElements == this) {
            return this;
        }
        if (pElements instanceof ExplicitLocationSet) {
            ExplicitLocationSet explicitLocationSet = (ExplicitLocationSet)pElements;
            return this.addElements(explicitLocationSet.explicitSet);
        }
        return pElements.addElements(this);
    }

    @Override
    public boolean containsAll(LocationSet pElements) {
        if (pElements == this) {
            return true;
        }
        if (pElements instanceof ExplicitLocationSet) {
            ExplicitLocationSet explicitLocationSet = (ExplicitLocationSet)pElements;
            return this.explicitSet.containsAll(explicitLocationSet.explicitSet);
        }
        return pElements.containsAll(this);
    }

    public String toString() {
        return this.explicitSet.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof LocationSet) {
            LocationSet o = (LocationSet)pO;
            if (o.isTop()) {
                return false;
            }
            if (o.isBot()) {
                return this.explicitSet.isEmpty();
            }
            if (o instanceof ExplicitLocationSet) {
                ExplicitLocationSet other = (ExplicitLocationSet)o;
                return this.explicitSet.equals(other.explicitSet);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.isBot()) {
            return LocationSetBot.INSTANCE.hashCode();
        }
        if (this.isTop()) {
            assert (false);
            return LocationSetTop.INSTANCE.hashCode();
        }
        return this.explicitSet.hashCode();
    }

    @Override
    public Iterator<String> iterator() {
        return this.explicitSet.iterator();
    }

    public int getSize() {
        return this.explicitSet.size();
    }
}

