/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;

public class FormulaLinearizationManager {
    private final UnsafeFormulaManager ufmgr;
    private final BooleanFormulaManager bfmgr;
    private final FormulaManagerView fmgr;
    private final NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifmgr;
    private static final String NOT_FUNC_NAME = "not";
    private static final String EQ_FUNC_NAME = "=";
    private static final String OR_FUNC_NAME = "or";
    public static final String CHOICE_VAR_NAME = "__POLICY_CHOICE_";
    private static final String INITIAL_CONDITION_FLAG = "__INITIAL_CONDITION_TRUE";
    private int choiceVarCounter = -1;

    public FormulaLinearizationManager(UnsafeFormulaManager pUfmgr, BooleanFormulaManager pBfmgr, FormulaManagerView pFmgr, NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> pIfmgr) {
        this.ufmgr = pUfmgr;
        this.bfmgr = pBfmgr;
        this.fmgr = pFmgr;
        this.ifmgr = pIfmgr;
    }

    public BooleanFormula linearize(BooleanFormula input) {
        return (BooleanFormula)this.recLinearize(input, new HashMap<Formula, Formula>());
    }

    private Formula recLinearize(Formula input, Map<Formula, Formula> memoization) {
        Formula out = memoization.get(input);
        if (out != null) {
            return out;
        }
        boolean isNot = this.ufmgr.getName(input).equals(NOT_FUNC_NAME);
        if (isNot && this.ufmgr.getName(this.ufmgr.getArg(input, 0)).equals(EQ_FUNC_NAME)) {
            Formula child = this.ufmgr.getArg(input, 0);
            Formula lhs = this.ufmgr.getArg(child, 0);
            Formula rhs = this.ufmgr.getArg(child, 1);
            out = this.bfmgr.or(this.fmgr.makeGreaterThan(lhs, rhs, true), this.fmgr.makeLessThan(lhs, rhs, true));
        } else {
            ArrayList<Formula> newArgs = new ArrayList<Formula>();
            for (int i = 0; i < this.ufmgr.getArity(input); ++i) {
                newArgs.add(this.recLinearize(this.ufmgr.getArg(input, i), memoization));
            }
            out = this.ufmgr.replaceArgs(input, newArgs);
        }
        memoization.put(input, out);
        return out;
    }

    public BooleanFormula annotateDisjunctions(BooleanFormula input) {
        return (BooleanFormula)this.recAnnotateDisjunction(input, new HashMap<Formula, Formula>());
    }

    private Formula recAnnotateDisjunction(Formula input, Map<Formula, Formula> memoization) {
        Formula out = memoization.get(input);
        if (out != null) {
            return out;
        }
        BooleanFormula specVar = this.bfmgr.not(this.bfmgr.makeVariable(INITIAL_CONDITION_FLAG));
        if (this.ufmgr.getName(input).equals(OR_FUNC_NAME)) {
            if (this.ufmgr.getArity(input) == 2 && (this.ufmgr.getArg(input, 0).equals(specVar) || this.ufmgr.getArg(input, 1).equals(specVar))) {
                out = input;
            } else {
                String freshVarName = CHOICE_VAR_NAME + ++this.choiceVarCounter;
                NumeralFormula.IntegerFormula var = this.ifmgr.makeVariable(freshVarName);
                ArrayList<Formula> newArgs = new ArrayList<Formula>();
                for (int choice = 0; choice < this.ufmgr.getArity(input); ++choice) {
                    newArgs.add(this.bfmgr.and((BooleanFormula)this.recAnnotateDisjunction(this.ufmgr.getArg(input, choice), memoization), this.fmgr.makeEqual(var, this.ifmgr.makeNumber(choice))));
                }
                out = this.ufmgr.replaceArgs(input, newArgs);
            }
        } else {
            ArrayList<Formula> newArgs = new ArrayList<Formula>();
            for (int i = 0; i < this.ufmgr.getArity(input); ++i) {
                newArgs.add(this.recAnnotateDisjunction(this.ufmgr.getArg(input, i), memoization));
            }
            out = this.ufmgr.replaceArgs(input, newArgs);
        }
        memoization.put(input, out);
        return out;
    }

    public BooleanFormula enforceChoice(BooleanFormula input, Iterable<Map.Entry<Model.AssignableTerm, Object>> model, boolean useInitialValue) {
        Object mapping = ImmutableMap.of((Object)this.bfmgr.makeVariable(INITIAL_CONDITION_FLAG), (Object)this.bfmgr.makeBoolean(useInitialValue));
        BooleanFormula initialSelected = this.ufmgr.substitute(input, mapping);
        mapping = new HashMap();
        for (Map.Entry<Model.AssignableTerm, Object> entry : model) {
            String termName = entry.getKey().getName();
            if (!termName.contains(CHOICE_VAR_NAME)) continue;
            BigInteger value = (BigInteger)entry.getValue();
            mapping.put(this.ifmgr.makeVariable(termName), this.ifmgr.makeNumber(value));
        }
        BooleanFormula pathSelected = this.ufmgr.substitute(initialSelected, mapping);
        pathSelected = this.fmgr.simplify(pathSelected);
        return pathSelected;
    }
}

