/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public final class Location {
    final CFANode node;
    final ImmutableList<CFANode> callerNodes;
    private static int locationCounter = -1;
    private static final BiMap<Integer, Location> serializationMap = HashBiMap.create();
    private final int locationID;

    private Location(CFANode pNode, List<CFANode> pCallerNodes) {
        this.node = pNode;
        this.callerNodes = ImmutableList.copyOf(pCallerNodes);
        if (serializationMap.inverse().containsKey((Object)this)) {
            this.locationID = (Integer)serializationMap.inverse().get((Object)this);
        } else {
            this.locationID = ++locationCounter;
            serializationMap.put((Object)this.locationID, (Object)this);
        }
    }

    public static Location initial(CFANode initial) {
        return new Location(initial, (List<CFANode>)ImmutableList.of());
    }

    public static Location ofID(int l) {
        return (Location)serializationMap.get((Object)l);
    }

    public int toID() {
        return this.locationID;
    }

    public static Location transferRelation(Location old, CFAEdge pEdge) {
        CFANode newNode = pEdge.getSuccessor();
        if (pEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
            return new Location(newNode, (List<CFANode>)ImmutableList.builder().addAll(old.callerNodes).add((Object)pEdge.getPredecessor()).build());
        }
        if (pEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
            return new Location(newNode, (List<CFANode>)old.callerNodes.subList(0, old.callerNodes.size() - 1));
        }
        return new Location(newNode, (List<CFANode>)old.callerNodes);
    }

    public String toString() {
        return String.format("%s(%s)", this.node, Joiner.on((String)",").join(this.callerNodes));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.node, this.callerNodes});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Location other = (Location)o;
        return this.node == other.node && this.callerNodes.equals(other.callerNodes);
    }
}

