/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.policyiteration.Location;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyDotWriter;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIntermediateState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.Template;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public final class PolicyAbstractedState
extends PolicyState
implements Iterable<Map.Entry<Template, PolicyBound>> {
    private final ImmutableMap<Template, PolicyBound> abstraction;
    private final PolicyIntermediateState generatingState;

    private PolicyAbstractedState(Location pLocation, Set<Template> pTemplates, Map<Template, PolicyBound> pAbstraction, PolicyIntermediateState pGeneratingState) {
        super(pLocation, pTemplates);
        this.abstraction = ImmutableMap.copyOf(pAbstraction);
        this.generatingState = pGeneratingState;
    }

    public static PolicyAbstractedState of(Map<Template, PolicyBound> data, Set<Template> templates, Location pLocation, PolicyIntermediateState pGeneratingState) {
        return new PolicyAbstractedState(pLocation, templates, data, pGeneratingState);
    }

    public PolicyAbstractedState withUpdates(Map<Template, PolicyBound> updates, Set<Template> unbounded, Set<Template> newTemplates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Template template : newTemplates) {
            if (unbounded.contains(template)) continue;
            if (updates.containsKey(template)) {
                builder.put((Object)template, (Object)updates.get(template));
                continue;
            }
            PolicyBound v = (PolicyBound)this.abstraction.get((Object)template);
            if (v == null) continue;
            builder.put((Object)template, this.abstraction.get((Object)template));
        }
        return new PolicyAbstractedState(this.getLocation(), newTemplates, (Map<Template, PolicyBound>)builder.build(), this.generatingState);
    }

    public PathFormula getPathFormula() {
        return this.generatingState.getPathFormula();
    }

    public Optional<PolicyBound> getBound(Template e) {
        return Optional.fromNullable((Object)this.abstraction.get((Object)e));
    }

    public static PolicyAbstractedState empty(Location pLocation, PathFormula initial) {
        PolicyIntermediateState Iinitial = PolicyIntermediateState.of(pLocation, (Set<Template>)ImmutableSet.of(), initial, (Multimap<Location, Location>)ImmutableMultimap.of(), (Map<Location, SSAMap>)ImmutableMap.of());
        return PolicyAbstractedState.of((Map<Template, PolicyBound>)ImmutableMap.of(), (Set<Template>)ImmutableSet.of(), pLocation, Iinitial);
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public String toDOTLabel() {
        return String.format("%s%n%s%n %n %s", new PolicyDotWriter().toDOTLabel((Map<Template, PolicyBound>)this.abstraction), this.templates, this.generatingState.getPathFormula());
    }

    public String toString() {
        return String.format("%s: %s", this.getLocation(), this.abstraction);
    }

    @Override
    public Iterator<Map.Entry<Template, PolicyBound>> iterator() {
        return this.abstraction.entrySet().iterator();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.generatingState, this.abstraction, super.hashCode()});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyAbstractedState other = (PolicyAbstractedState)o;
        return this.generatingState.equals(other.generatingState) && this.abstraction.equals(other.abstraction) && super.equals(o);
    }
}

