/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.cpa.policyiteration.Location;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class PolicyBound {
    final Location predecessor;
    final PathFormula formula;
    final Rational bound;
    final SSAMap startSSA;
    private static final Map<Triple<Location, PathFormula, Location>, Integer> serializationMap = new HashMap<Triple<Location, PathFormula, Location>, Integer>();
    private static int pathCounter = -1;

    PolicyBound(PathFormula pFormula, Rational pBound, Location pPredecessor, SSAMap pStartSSA) {
        this.formula = pFormula;
        this.bound = pBound;
        this.predecessor = pPredecessor;
        this.startSSA = pStartSSA;
    }

    public static PolicyBound of(PathFormula pFormula, Rational bound, Location pUpdatedFrom, SSAMap pStartSSA) {
        return new PolicyBound(pFormula, bound, pUpdatedFrom, pStartSSA);
    }

    public int serializePath(Location toLocation) {
        Triple p = Triple.of((Object)this.predecessor, (Object)this.formula, (Object)toLocation);
        Integer serialization = serializationMap.get(p);
        if (serialization == null) {
            serialization = ++pathCounter;
            serializationMap.put((Triple<Location, PathFormula, Location>)p, serialization);
        }
        return serialization;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.predecessor, this.bound, this.formula});
    }

    public String toString() {
        return String.format("%s (from: %s)", this.bound, this.predecessor);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        PolicyBound o = (PolicyBound)other;
        return this.predecessor.equals(o.predecessor) && this.bound.equals(o.bound) && this.formula.equals(o.formula);
    }
}

