/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.Template;
import org.sosy_lab.cpachecker.util.rationals.LinearExpression;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class PolicyDotWriter {
    public String toDOTLabel(Map<Template, PolicyBound> data) {
        StringBuilder b = new StringBuilder();
        b.append("\n");
        HashMap<LinearExpression<CIdExpression>, PolicyBound> toSort = new HashMap<LinearExpression<CIdExpression>, PolicyBound>();
        HashMap<LinearExpression, Rational> lessThan = new HashMap<LinearExpression, Rational>();
        HashMap<LinearExpression, Pair> bounded = new HashMap<LinearExpression, Pair>();
        HashMap<LinearExpression, Rational> equal = new HashMap<LinearExpression, Rational>();
        for (Map.Entry<Template, PolicyBound> entry : data.entrySet()) {
            toSort.put(entry.getKey().linearExpression, entry.getValue());
        }
        while (toSort.size() > 0) {
            LinearExpression template = (LinearExpression)toSort.keySet().iterator().next();
            Rational upperBound = ((PolicyBound)toSort.get((Object)template)).bound;
            LinearExpression linearExpression = template.negate();
            toSort.remove(template);
            if (toSort.containsKey(linearExpression)) {
                Rational lowerBound = ((PolicyBound)toSort.get(linearExpression)).bound.negate();
                toSort.remove(linearExpression);
                boolean negated = false;
                if (template.toString().startsWith("-")) {
                    negated = true;
                }
                if (lowerBound.equals(upperBound)) {
                    if (negated) {
                        equal.put(template.negate(), lowerBound.negate());
                        continue;
                    }
                    equal.put(template, lowerBound);
                    continue;
                }
                if (negated) {
                    bounded.put(template.negate(), Pair.of((Object)upperBound.negate(), (Object)lowerBound.negate()));
                    continue;
                }
                bounded.put(template, Pair.of((Object)lowerBound, (Object)upperBound));
                continue;
            }
            lessThan.put(template, upperBound);
        }
        for (Map.Entry<Template, PolicyBound> entry : equal.entrySet()) {
            b.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        for (Map.Entry<Template, PolicyBound> entry : bounded.entrySet()) {
            b.append(((Pair)entry.getValue()).getFirst()).append("\u2264").append(entry.getKey()).append("\u2264").append(((Pair)entry.getValue()).getSecond()).append("\n");
        }
        for (Map.Entry<Template, PolicyBound> entry : lessThan.entrySet()) {
            b.append(entry.getKey()).append("\u2264").append(entry.getValue()).append("\n");
        }
        return b.toString();
    }
}

