/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.policyiteration.Location;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.Template;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public final class PolicyIntermediateState
extends PolicyState {
    private final PathFormula pathFormula;
    private final ImmutableMultimap<Location, Location> trace;
    private final ImmutableMap<Location, SSAMap> startSSA;

    private PolicyIntermediateState(Location pLocation, Set<Template> pTemplates, PathFormula pPathFormula, Multimap<Location, Location> pTrace, Map<Location, SSAMap> pStartSSA) {
        super(pLocation, pTemplates);
        this.pathFormula = pPathFormula;
        this.trace = ImmutableMultimap.copyOf(pTrace);
        this.startSSA = ImmutableMap.copyOf(pStartSSA);
    }

    public static PolicyIntermediateState of(Location pLocation, Set<Template> pTemplates, PathFormula pPathFormula, Multimap<Location, Location> pTrace, Map<Location, SSAMap> startSSA) {
        return new PolicyIntermediateState(pLocation, pTemplates, pPathFormula, pTrace, startSSA);
    }

    public Map<Location, SSAMap> getStartSSA() {
        return this.startSSA;
    }

    public PathFormula getPathFormula() {
        return this.pathFormula;
    }

    public ImmutableMultimap<Location, Location> getTrace() {
        return this.trace;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public String toDOTLabel() {
        return this.pathFormula.toString() + "\n" + this.pathFormula.getSsa().toString();
    }

    public String toString() {
        return String.format("%s: %s", this.getLocation(), this.pathFormula);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pathFormula, super.hashCode()});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyIntermediateState other = (PolicyIntermediateState)o;
        return this.pathFormula.equals(other.pathFormula) && super.equals(o);
    }
}

