/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.policyiteration.FormulaLinearizationManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.IPolicyIterationManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.Location;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIntermediateState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyIterationStatistics;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.SlicingFormulaManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.Template;
import org.sosy_lab.cpachecker.cpa.policyiteration.TemplateManager;
import org.sosy_lab.cpachecker.cpa.policyiteration.ValueDeterminationFormulaManager;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.rationals.Rational;

@Options(prefix="cpa.stator.policy")
public class PolicyIterationManager
implements IPolicyIterationManager {
    @Option(secure=true, description="Call [simplify] on the formulas resulting from the C code")
    private boolean simplifyFormulas = true;
    @Option(secure=true, description="Perform abstraction only at the nodes from the cut-set.")
    private boolean pathFocusing = true;
    @Option(secure=true, description="Perform formula slicing after abstractions to propagate the pointer information")
    private boolean propagateFormulasPastAbstraction = true;
    @Option(secure=true, name="epsilon", description="Value to substitute for the epsilon")
    private Rational EPSILON = Rational.ONE;
    private final FormulaManagerView fmgr;
    private final CFA cfa;
    private final PathFormulaManager pfmgr;
    private final BooleanFormulaManager bfmgr;
    private final Solver solver;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> rfmgr;
    private final NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifmgr;
    private final TemplateManager templateManager;
    private final ValueDeterminationFormulaManager vdfmgr;
    private final PolicyIterationStatistics statistics;
    private final SlicingFormulaManager formulaSlicingManager;
    private final FormulaLinearizationManager linearizationManager;
    private final ImmutableMap<CFANode, LoopStructure.Loop> loopStructure;
    private final Map<Location, PolicyState> abstractStates;
    private static final String INITIAL_CONDITION_FLAG = "__INITIAL_CONDITION_TRUE";
    private static final String START_LOCATION_FLAG = "__INITIAL_LOCATION";

    public PolicyIterationManager(Configuration config, FormulaManagerView pFormulaManager, CFA pCfa, PathFormulaManager pPfmgr, Solver pSolver, LogManager pLogger, ShutdownNotifier pShutdownNotifier, TemplateManager pTemplateManager, ValueDeterminationFormulaManager pValueDeterminationFormulaManager, PolicyIterationStatistics pStatistics, SlicingFormulaManager pFormulaSlicingManager, FormulaLinearizationManager pLinearizationManager) throws InvalidConfigurationException {
        config.inject((Object)this, PolicyIterationManager.class);
        this.fmgr = pFormulaManager;
        this.cfa = pCfa;
        this.pfmgr = pPfmgr;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.solver = pSolver;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.rfmgr = this.fmgr.getRationalFormulaManager();
        this.ifmgr = this.fmgr.getIntegerFormulaManager();
        this.templateManager = pTemplateManager;
        this.vdfmgr = pValueDeterminationFormulaManager;
        this.statistics = pStatistics;
        this.formulaSlicingManager = pFormulaSlicingManager;
        this.linearizationManager = pLinearizationManager;
        ImmutableMap.Builder nodeMapBuilder = ImmutableMap.builder();
        for (CFANode node : pCfa.getAllNodes()) {
            nodeMapBuilder.put((Object)node.getNodeNumber(), (Object)node);
        }
        ImmutableMap.Builder loopStructureBuilder = ImmutableMap.builder();
        LoopStructure loopStructure1 = (LoopStructure)pCfa.getLoopStructure().get();
        for (LoopStructure.Loop l : loopStructure1.getAllLoops()) {
            for (CFANode n : l.getLoopHeads()) {
                loopStructureBuilder.put((Object)n, (Object)l);
            }
        }
        this.loopStructure = loopStructureBuilder.build();
        this.abstractStates = new HashMap<Location, PolicyState>(pCfa.getAllNodes().size());
    }

    @Override
    public PolicyState getInitialState(CFANode pNode) {
        Location initialLocation = Location.initial(pNode);
        PolicyAbstractedState initial = PolicyAbstractedState.empty(initialLocation, this.pfmgr.makeEmptyPathFormula());
        this.abstractStates.put(initialLocation, initial);
        return initial;
    }

    @Override
    public Collection<PolicyState> getAbstractSuccessors(PolicyState oldState, CFAEdge edge) throws CPATransferException, InterruptedException {
        CFANode node = edge.getSuccessor();
        Location oldLocation = oldState.getLocation();
        Location newLocation = Location.transferRelation(oldLocation, edge);
        PolicyIntermediateState iOldState = oldState.isAbstract() ? this.abstractStateToIntermediate(oldState.asAbstracted()) : oldState.asIntermediate();
        HashMultimap trace = HashMultimap.create(iOldState.getTrace());
        trace.put((Object)newLocation, (Object)oldLocation);
        PathFormula outPath = this.pfmgr.makeAnd(iOldState.getPathFormula(), edge);
        if (this.simplifyFormulas) {
            outPath = outPath.updateFormula(this.fmgr.simplify(outPath.getFormula()));
        }
        PolicyIntermediateState out = PolicyIntermediateState.of(newLocation, (Set<Template>)Sets.union(this.templateManager.templatesForNode(node), oldState.getTemplates()), outPath, (Multimap<Location, Location>)trace, iOldState.getStartSSA());
        return Collections.singleton(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PolicyState> strengthen(PolicyState state, List<AbstractState> otherStates, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        this.statistics.startAbstractionTimer();
        try {
            if (!state.isAbstract() && this.shouldPerformAbstraction(state.asIntermediate())) {
                PolicyIntermediateState iState = state.asIntermediate();
                this.logger.log(Level.FINE, new Object[]{">>> Abstraction from formula", iState.getPathFormula()});
                this.logger.log(Level.FINE, new Object[]{"SSA: ", iState.getPathFormula().getSsa()});
                Optional<PolicyAbstractedState> abstraction = this.performAbstraction(iState);
                if (!abstraction.isPresent()) {
                    List<PolicyState> list = Collections.emptyList();
                    return list;
                }
                state = (PolicyState)abstraction.get();
                this.logger.log(Level.FINE, new Object[]{">>> Abstraction produced state: ", state});
            }
            this.abstractStates.put(state.getLocation(), state);
        }
        finally {
            this.statistics.stopAbstractionTimer();
        }
        if (state.isAbstract()) {
            return Collections.singleton(state);
        }
        boolean hasTargetState = false;
        for (AbstractState oState : otherStates) {
            if (!AbstractStates.isTargetState(oState)) continue;
            hasTargetState = true;
        }
        if (hasTargetState) {
            boolean isSat = this.checkSatisfiability(state.asIntermediate());
            if (!isSat) {
                return Collections.emptyList();
            }
            return Collections.singleton(state);
        }
        return Collections.singleton(state);
    }

    @Override
    public PolicyState join(PolicyState newState, PolicyState oldState) throws CPATransferException, InterruptedException, SolverException {
        Preconditions.checkState((oldState.getNode() == newState.getNode() ? 1 : 0) != 0);
        Preconditions.checkState((oldState.isAbstract() == newState.isAbstract() ? 1 : 0) != 0);
        PolicyState out = oldState.isAbstract() ? this.joinAbstractedStates(newState.asAbstracted(), oldState.asAbstracted()) : this.joinIntermediateStates(newState.asIntermediate(), oldState.asIntermediate());
        this.abstractStates.put(out.getLocation(), out);
        if (out.equals(oldState)) {
            return oldState;
        }
        return out;
    }

    private PolicyIntermediateState joinIntermediateStates(PolicyIntermediateState newState, PolicyIntermediateState oldState) throws CPATransferException, InterruptedException {
        Preconditions.checkState((boolean)newState.getLocation().equals(oldState.getLocation()));
        Location location = newState.getLocation();
        if (this.checkCovering(oldState, newState)) {
            return newState;
        }
        Sets.SetView allTemplates = Sets.union(oldState.getTemplates(), newState.getTemplates());
        PathFormula newPath = newState.getPathFormula();
        PathFormula oldPath = oldState.getPathFormula();
        HashMultimap trace = HashMultimap.create();
        trace.putAll(newState.getTrace());
        trace.putAll(oldState.getTrace());
        HashMap<Location, SSAMap> newStartSSA = new HashMap<Location, SSAMap>();
        for (Location loc : Sets.union(newState.getStartSSA().keySet(), oldState.getStartSSA().keySet())) {
            if (newState.getStartSSA().get(loc) == null) {
                newStartSSA.put(loc, oldState.getStartSSA().get(loc));
                continue;
            }
            if (oldState.getStartSSA().get(loc) == null) {
                newStartSSA.put(loc, newState.getStartSSA().get(loc));
                continue;
            }
            Preconditions.checkState((boolean)newState.getStartSSA().get(loc).equals(oldState.getStartSSA().get(loc)));
            newStartSSA.put(loc, newState.getStartSSA().get(loc));
        }
        return PolicyIntermediateState.of(location, (Set<Template>)allTemplates, this.pfmgr.makeOr(newPath, oldPath), (Multimap<Location, Location>)trace, newStartSSA);
    }

    private PolicyAbstractedState joinAbstractedStates(PolicyAbstractedState newState, PolicyAbstractedState oldState) throws CPATransferException, InterruptedException {
        Preconditions.checkState((boolean)newState.getLocation().equals(oldState.getLocation()));
        CFANode node = oldState.getNode();
        Location location = oldState.getLocation();
        Sets.SetView allTemplates = Sets.union(oldState.getTemplates(), newState.getTemplates());
        HashMap<Template, PolicyBound> updated = new HashMap<Template, PolicyBound>();
        HashSet<Template> unbounded = new HashSet<Template>();
        for (Template template : allTemplates) {
            Optional<PolicyBound> oldValue = oldState.getBound(template);
            Optional<PolicyBound> newValue = newState.getBound(template);
            if (!oldValue.isPresent()) continue;
            if (!newValue.isPresent()) {
                unbounded.add(template);
                continue;
            }
            if (((PolicyBound)newValue.get()).bound.compareTo(((PolicyBound)oldValue.get()).bound) <= 0) continue;
            updated.put(template, (PolicyBound)newValue.get());
        }
        PolicyAbstractedState stateWithUpdates = oldState.withUpdates(updated, unbounded, (Set<Template>)allTemplates);
        this.logger.log(Level.FINE, new Object[]{"# State with updates: ", stateWithUpdates});
        if (!this.shouldPerformValueDetermination(node, updated)) {
            return stateWithUpdates;
        }
        Map<Location, PolicyAbstractedState> related = this.findRelated(stateWithUpdates, updated);
        Pair<ImmutableMap<String, FormulaType<?>>, BooleanFormula> constraints = this.vdfmgr.valueDeterminationFormula(related, stateWithUpdates.getLocation(), updated);
        PolicyAbstractedState out = this.valueDeterminationMaximization(oldState, (Set<Template>)allTemplates, updated, location, (Map)constraints.getFirst(), (BooleanFormula)constraints.getSecond());
        this.logger.log(Level.FINE, new Object[]{">>> Value determination out state: ", out});
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolicyAbstractedState valueDeterminationMaximization(PolicyAbstractedState prevState, Set<Template> templates, Map<Template, PolicyBound> updated, Location location, Map<String, FormulaType<?>> types, BooleanFormula pValueDeterminationConstraints) throws InterruptedException, CPATransferException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<Template> unbounded = new HashSet<Template>();
        this.statistics.startValueDeterminationTimer();
        try (OptEnvironment solver = this.solver.newOptEnvironment();){
            OptEnvironment.OptStatus result;
            this.shutdownNotifier.shutdownIfNecessary();
            solver.addConstraint(pValueDeterminationConstraints);
            HashMap<Template, Integer> objectiveHandles = new HashMap<Template, Integer>(updated.size());
            for (Map.Entry<Template, PolicyBound> policyValue : updated.entrySet()) {
                NumeralFormula objective;
                Template template = policyValue.getKey();
                String varName = this.vdfmgr.absDomainVarName(location, template);
                this.logger.log(Level.FINE, new Object[]{"Var name: ", varName});
                if (this.templateManager.shouldUseRationals(template)) {
                    objective = this.rfmgr.makeVariable(varName);
                } else {
                    FormulaType<?> type = types.get(varName);
                    objective = (NumeralFormula)this.fmgr.makeVariable(type, varName);
                }
                int handle = solver.maximize(objective);
                objectiveHandles.put(template, handle);
            }
            try {
                this.statistics.startOPTTimer();
                result = solver.check();
            }
            finally {
                this.statistics.stopOPTTimer();
            }
            if (result != OptEnvironment.OptStatus.OPT) {
                this.shutdownNotifier.shutdownIfNecessary();
                throw new CPATransferException("Unexpected solver state, value determination problem should be feasible");
            }
            for (Map.Entry<Template, PolicyBound> policyValue : updated.entrySet()) {
                Template template = policyValue.getKey();
                PolicyBound bound = policyValue.getValue();
                PathFormula policyFormula = bound.formula;
                Optional<Rational> value = solver.upper((Integer)objectiveHandles.get(template), this.EPSILON);
                if (value.isPresent()) {
                    builder.put((Object)template, (Object)PolicyBound.of(policyFormula, (Rational)value.get(), bound.predecessor, bound.startSSA));
                    continue;
                }
                unbounded.add(template);
            }
        }
        catch (SolverException e) {
            throw new CPATransferException("Failed maximization ", e);
        }
        finally {
            this.statistics.stopValueDeterminationTimer();
        }
        return prevState.withUpdates((Map<Template, PolicyBound>)builder.build(), unbounded, templates);
    }

    private boolean shouldPerformValueDetermination(CFANode node, Map<Template, PolicyBound> updated) {
        if (!node.isLoopStart()) {
            return false;
        }
        LoopStructure.Loop l = (LoopStructure.Loop)this.loopStructure.get((Object)node);
        if (l == null) {
            return true;
        }
        for (PolicyBound bound : updated.values()) {
            Location location = bound.predecessor;
            if (!l.getLoopNodes().contains((Object)location.node)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSatisfiability(PolicyIntermediateState state) throws CPATransferException, InterruptedException {
        BooleanFormula constraint = state.getPathFormula().getFormula();
        constraint = this.linearizationManager.enforceChoice(constraint, Collections.emptySet(), true);
        try {
            this.statistics.startCheckSATTimer();
            boolean bl = !this.solver.isUnsat(constraint);
            return bl;
        }
        catch (SolverException e) {
            throw new CPATransferException("Failed solving", e);
        }
        finally {
            this.statistics.stopCheckSATTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<PolicyAbstractedState> performAbstraction(PolicyIntermediateState state) throws CPATransferException, InterruptedException {
        PathFormula p = state.getPathFormula();
        BooleanFormula transferRelation = p.getFormula();
        BooleanFormula linearizedFormula = this.linearizationManager.linearize(transferRelation);
        BooleanFormula annotatedFormula = this.linearizationManager.annotateDisjunctions(linearizedFormula);
        ImmutableMap.Builder abstraction = ImmutableMap.builder();
        BooleanFormula formulaWithInitial = this.linearizationManager.enforceChoice(annotatedFormula, Collections.emptySet(), true);
        try (OptEnvironment solver = this.solver.newOptEnvironment();){
            solver.addConstraint(formulaWithInitial);
            this.shutdownNotifier.shutdownIfNecessary();
            Iterator i$ = state.getTemplates().iterator();
            while (i$.hasNext()) {
                OptEnvironment.OptStatus status;
                Template template = (Template)i$.next();
                Formula objective = this.templateManager.toFormula(template, p);
                solver.push();
                this.logger.log(Level.FINE, new Object[]{"Optimizing for ", objective});
                this.logger.log(Level.FINE, new Object[]{"Constraints: ", p.getFormula()});
                this.logger.flush();
                int handle = solver.maximize(objective);
                try {
                    this.statistics.startOPTTimer();
                    status = solver.check();
                }
                finally {
                    this.statistics.stopOPTTimer();
                }
                switch (status) {
                    case OPT: {
                        boolean unsignedAndLower;
                        Optional<Rational> bound = solver.upper(handle, this.EPSILON);
                        Model model = solver.getModel();
                        boolean bl = unsignedAndLower = template.type.isUnsigned() && template.isLowerBound();
                        if (bound.isPresent() || unsignedAndLower) {
                            Rational boundValue = bound.isPresent() && unsignedAndLower ? Rational.max((Rational)bound.get(), Rational.ZERO) : (bound.isPresent() ? (Rational)bound.get() : Rational.ZERO);
                            PolicyBound policyBound = this.policyBoundFromModel(state, p, annotatedFormula, model, boundValue);
                            abstraction.put((Object)template, (Object)policyBound);
                        }
                        this.logger.log(Level.FINE, new Object[]{"Got bound: ", bound});
                        break;
                    }
                    case UNSAT: {
                        this.logger.log(Level.FINE, new Object[]{"Got UNSAT"});
                        Optional optional = Optional.absent();
                        return optional;
                    }
                    case UNDEF: {
                        this.shutdownNotifier.shutdownIfNecessary();
                        throw new CPATransferException("Solver returned undefined status");
                    }
                }
                solver.pop();
            }
            return Optional.of((Object)PolicyAbstractedState.of((Map<Template, PolicyBound>)abstraction.build(), state.getTemplates(), state.getLocation(), state));
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver error: ", e);
        }
    }

    private PolicyIntermediateState abstractStateToIntermediate(PolicyAbstractedState abstractState) throws InterruptedException, CPATransferException {
        SSAMap ssa = abstractState.getPathFormula().getSsa();
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        for (Map.Entry<Template, PolicyBound> entry : abstractState) {
            Template template = entry.getKey();
            PolicyBound bound = entry.getValue();
            Formula t = this.templateManager.toFormula(template, abstractState.getPathFormula());
            BooleanFormula constraint = this.fmgr.makeLessOrEqual(t, this.fmgr.makeNumber(t, bound.bound), true);
            constraints.add(constraint);
        }
        BooleanFormula initialConstraint = this.bfmgr.and(constraints);
        initialConstraint = this.bfmgr.or(this.bfmgr.not(this.bfmgr.makeVariable(INITIAL_CONDITION_FLAG)), this.bfmgr.and(initialConstraint, this.ifmgr.equal(this.ifmgr.makeVariable(START_LOCATION_FLAG), this.ifmgr.makeNumber(abstractState.getLocation().toID()))));
        if (this.propagateFormulasPastAbstraction) {
            BooleanFormula pointerData = this.formulaSlicingManager.pointerFormulaSlice(abstractState.getLocation(), abstractState.getPathFormula());
            initialConstraint = this.bfmgr.and(initialConstraint, pointerData);
        }
        PathFormula path = new PathFormula(initialConstraint, ssa, abstractState.getPathFormula().getPointerTargetSet(), 0);
        return PolicyIntermediateState.of(abstractState.getLocation(), abstractState.getTemplates(), path, (Multimap<Location, Location>)HashMultimap.create(), (Map<Location, SSAMap>)ImmutableMap.of((Object)abstractState.getLocation(), (Object)ssa));
    }

    private PolicyBound policyBoundFromModel(PolicyIntermediateState inputState, PathFormula inputPathFormula, BooleanFormula transferRelation, Model model, Rational bound) {
        BooleanFormula policyFormula = this.linearizationManager.enforceChoice(transferRelation, model.entrySet(), false);
        BigInteger prevLocationID = (BigInteger)model.get(new Model.Constant(START_LOCATION_FLAG, Model.TermType.Integer));
        int locationID = Ints.checkedCast((long)prevLocationID.longValue());
        Location prevLocation = Location.ofID(locationID);
        SSAMap startSSA = inputState.getStartSSA().get(prevLocation);
        return PolicyBound.of(inputPathFormula.updateFormula(policyFormula), bound, prevLocation, startSSA);
    }

    private boolean shouldPerformAbstraction(PolicyIntermediateState state) {
        CFANode node = state.getNode();
        if (!this.pathFocusing) {
            return true;
        }
        return node.isLoopStart();
    }

    private Map<Location, PolicyAbstractedState> findRelated(PolicyAbstractedState newState, Map<Template, PolicyBound> updated) {
        HashMap<Location, PolicyAbstractedState> out = new HashMap<Location, PolicyAbstractedState>();
        HashSet visited = Sets.newHashSet();
        Location focusedLocation = newState.getLocation();
        LinkedHashSet<Location> queue = new LinkedHashSet<Location>();
        queue.add(focusedLocation);
        while (!queue.isEmpty()) {
            Iterator it = queue.iterator();
            Location loc = (Location)it.next();
            it.remove();
            visited.add(loc);
            PolicyState state = loc == focusedLocation ? newState : this.abstractStates.get(loc);
            PolicyAbstractedState aState = state.asAbstracted();
            out.put(loc, aState);
            for (Map.Entry<Template, PolicyBound> entry : aState) {
                Location toVisit;
                Template template = entry.getKey();
                PolicyBound bound = entry.getValue();
                if (state == newState && !updated.containsKey(template) || visited.contains(toVisit = bound.predecessor)) continue;
                queue.add(toVisit);
            }
        }
        return out;
    }

    private boolean checkCovering(PolicyIntermediateState newState, PolicyIntermediateState oldState) throws CPATransferException, InterruptedException {
        for (Map.Entry e : newState.getTrace().entries()) {
            if (oldState.getTrace().containsEntry(e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }
}

