/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;

@Options(prefix="cpa.stator.policy")
public class PolicyIterationStatistics
implements Statistics {
    private final Timer valueDeterminationTimer = new Timer();
    private final Timer abstractionTimer = new Timer();
    private final Timer checkSATTimer = new Timer();
    private final Timer optTimer = new Timer();

    public void startCheckSATTimer() {
        this.checkSATTimer.start();
    }

    public void stopCheckSATTimer() {
        this.checkSATTimer.stop();
    }

    public void startOPTTimer() {
        this.optTimer.start();
    }

    public void stopOPTTimer() {
        this.optTimer.stop();
    }

    public void startAbstractionTimer() {
        this.abstractionTimer.start();
    }

    public void stopAbstractionTimer() {
        this.abstractionTimer.stop();
    }

    public void startValueDeterminationTimer() {
        this.valueDeterminationTimer.start();
    }

    public void stopValueDeterminationTimer() {
        this.valueDeterminationTimer.stop();
    }

    public PolicyIterationStatistics(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this, PolicyIterationStatistics.class);
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        this.printTimer(out, this.valueDeterminationTimer, "value determination");
        this.printTimer(out, this.abstractionTimer, "abstraction");
        this.printTimer(out, this.optTimer, "optimization");
        this.printTimer(out, this.checkSATTimer, "checking satisfiability");
        out.printf("Time spent in %s: %s (Max: %s)%n", "SMT solver", TimeSpan.sum((TimeSpan)this.optTimer.getSumTime(), (TimeSpan)this.checkSATTimer.getSumTime()).formatAs(TimeUnit.SECONDS), this.optTimer.getMaxTime().formatAs(TimeUnit.SECONDS));
    }

    public void printTimer(PrintStream out, Timer t, String name) {
        out.printf("Time spent in %s: %s (Max: %s)%n", name, t, t.getMaxTime().formatAs(TimeUnit.SECONDS));
    }

    @Override
    public String getName() {
        return "PolicyIterationCPA";
    }
}

