/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.policyiteration.Location;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class SlicingFormulaManager {
    private final LogManager logger;
    private final FormulaManagerView fmgr;
    private final UnsafeFormulaManager unsafeManager;
    private final BooleanFormulaManager bfmgr;
    private final PathFormulaManager pfmgr;
    private final Solver solver;
    private static final String NOT_FUNC_NAME = "not";
    private static final String POINTER_ADDR_VAR_NAME = "ADDRESS_OF";

    public SlicingFormulaManager(LogManager pLogger, FormulaManagerView pFmgr, UnsafeFormulaManager pUnsafeManager, BooleanFormulaManager pBfmgr, PathFormulaManager pPfmgr, Solver pSolver) {
        this.logger = pLogger;
        this.fmgr = pFmgr;
        this.unsafeManager = pUnsafeManager;
        this.bfmgr = pBfmgr;
        this.pfmgr = pPfmgr;
        this.solver = pSolver;
    }

    BooleanFormula pointerFormulaSlice(Location location, PathFormula pf) throws InterruptedException, CPATransferException {
        BooleanFormula f = pf.getFormula();
        SSAMap ssa = pf.getSsa();
        Set<String> closure = this.findClosure(f, new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains(SlicingFormulaManager.POINTER_ADDR_VAR_NAME);
            }
        });
        this.logger.log(Level.FINE, new Object[]{"Closure =", closure});
        Formula slice = this.recSliceFormula(f, (ImmutableSet<String>)ImmutableSet.copyOf(closure), false, new HashMap<Formula, Formula>());
        this.logger.log(Level.FINE, new Object[]{"Produced =", slice});
        String renamePrefix = "__SLICE_INTERMEDIATE_";
        HashMap<Formula, Formula> renames = new HashMap<Formula, Formula>();
        HashSet<Formula> outVariables = new HashSet<Formula>();
        HashSet<Formula> intermediateVariables = new HashSet<Formula>();
        for (Triple<Formula, String, Integer> triple : this.fmgr.extractFunctionSymbols(slice)) {
            Formula var = (Formula)triple.getFirst();
            String varName = (String)triple.getSecond();
            Integer ssaIndex = (Integer)triple.getThird();
            if (ssaIndex != null && ssa.containsVariable(varName) && ssaIndex < ssa.getIndex(varName)) {
                Formula newVar = this.fmgr.makeVariable(var, "__SLICE_INTERMEDIATE_" + varName);
                renames.put(var, newVar);
                intermediateVariables.add(newVar);
                continue;
            }
            outVariables.add(var);
        }
        BooleanFormula sliceRenamed = (BooleanFormula)this.unsafeManager.substitute(slice, renames);
        if (this.isInductive(location.node, outVariables, intermediateVariables, pf.updateFormula(sliceRenamed))) {
            return this.fmgr.simplify(sliceRenamed);
        }
        return this.bfmgr.makeBoolean(true);
    }

    private Set<String> findClosure(BooleanFormula f, Predicate<String> seedCondition) {
        HashSet<String> closure = new HashSet<String>();
        Collection<BooleanFormula> atoms = this.fmgr.extractAtoms(f, false, false);
        boolean changed = true;
        while (changed) {
            changed = false;
            block1: for (BooleanFormula atom : atoms) {
                Set<String> variableNames = this.fmgr.extractFunctionNames(atom);
                for (String s : variableNames) {
                    if (!seedCondition.apply((Object)s) && !closure.contains(s)) continue;
                    changed = closure.addAll(variableNames);
                    continue block1;
                }
            }
        }
        return closure;
    }

    private Formula recSliceFormula(Formula f, ImmutableSet<String> closure, boolean isInsideNot, Map<Formula, Formula> memoization) throws InterruptedException {
        Formula out = memoization.get(f);
        if (out != null) {
            return out;
        }
        if (this.unsafeManager.isAtom(f)) {
            Formula uninstantiatedF = this.fmgr.uninstantiate(f);
            Set<String> containedVariables = this.fmgr.extractFunctionNames(uninstantiatedF);
            if (!Sets.intersection(closure, containedVariables).isEmpty()) {
                out = f;
            } else if (containedVariables.size() == 2) {
                Iterator<String> iterator = containedVariables.iterator();
                String first = iterator.next();
                String second = iterator.next();
                out = first.contains("::") && second.contains("::") && !first.substring(0, first.indexOf("::")).equals(second.substring(0, second.indexOf("::"))) ? f : this.bfmgr.makeBoolean(!isInsideNot);
            } else {
                out = this.bfmgr.makeBoolean(!isInsideNot);
            }
        } else {
            int count = this.unsafeManager.getArity(f);
            ArrayList<Formula> newArgs = new ArrayList<Formula>(count);
            String name = this.unsafeManager.getName(f);
            if (name.equals(NOT_FUNC_NAME)) {
                isInsideNot = !isInsideNot;
            }
            for (int i = 0; i < count; ++i) {
                newArgs.add(this.recSliceFormula(this.unsafeManager.getArg(f, i), closure, isInsideNot, memoization));
            }
            out = this.unsafeManager.replaceArgs(f, newArgs);
        }
        memoization.put(f, out);
        return out;
    }

    private boolean isInductive(CFANode pNode, Set<Formula> pOutVariables, Set<Formula> pIntermediateVariables, PathFormula formulaSlice) throws CPATransferException, InterruptedException {
        Set<CFAEdge> edges = this.getRelated(pNode);
        for (CFAEdge edge : edges) {
            boolean isInductive = this.testInductivenessUnderEdge(formulaSlice, edge, pOutVariables, pIntermediateVariables);
            if (isInductive) continue;
            return false;
        }
        return true;
    }

    private boolean testInductivenessUnderEdge(PathFormula formulaSlice, CFAEdge edge, Set<Formula> outVars, Set<Formula> intermediateVars) throws CPATransferException, InterruptedException {
        boolean isInductive;
        PathFormula prefix = this.pfmgr.makeAnd(formulaSlice, edge);
        SSAMap outSSA = prefix.getSsa();
        HashMap<Formula, Formula> renames = new HashMap<Formula, Formula>();
        for (Formula f : outVars) {
            Formula to;
            if (f.equals(to = this.fmgr.instantiate(f, outSSA))) continue;
            renames.put(f, to);
        }
        for (Formula f : intermediateVars) {
            renames.put(f, this.fmgr.makeVariable(f, this.unsafeManager.getName(f) + "'"));
        }
        BooleanFormula formulaSliceSuffix = this.unsafeManager.substitute(formulaSlice.getFormula(), renames);
        BooleanFormula test = this.fmgr.makeAnd(prefix.getFormula(), this.fmgr.makeNot(formulaSliceSuffix));
        try {
            isInductive = this.solver.isUnsat(test);
        }
        catch (SolverException e) {
            throw new CPATransferException("Failed checking unsat", e);
        }
        return isInductive;
    }

    private Set<CFAEdge> getRelated(CFANode node) {
        HashSet<CFAEdge> reachableEdges = new HashSet<CFAEdge>();
        LinkedList<CFAEdge> queue = new LinkedList<CFAEdge>();
        for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
            queue.add(node.getLeavingEdge(i));
        }
        while (!queue.isEmpty()) {
            CFAEdge edge = (CFAEdge)queue.remove();
            if (reachableEdges.contains(edge)) continue;
            reachableEdges.add(edge);
            CFANode toNode = edge.getSuccessor();
            for (int i = 0; i < toNode.getNumLeavingEdges(); ++i) {
                queue.add(toNode.getLeavingEdge(i));
            }
        }
        HashSet<CFAEdge> canReachEdges = new HashSet<CFAEdge>();
        queue = new LinkedList();
        for (int i = 0; i < node.getNumEnteringEdges(); ++i) {
            queue.add(node.getEnteringEdge(i));
        }
        while (!queue.isEmpty()) {
            CFAEdge edge = (CFAEdge)queue.remove();
            if (canReachEdges.contains(edge)) continue;
            canReachEdges.add(edge);
            CFANode fromNode = edge.getPredecessor();
            for (int i = 0; i < fromNode.getNumEnteringEdges(); ++i) {
                queue.add(fromNode.getEnteringEdge(i));
            }
        }
        return Sets.intersection(reachableEdges, canReachEdges);
    }
}

