/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cpa.policyiteration.Template;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.rationals.LinearExpression;
import org.sosy_lab.cpachecker.util.rationals.Rational;

@Options(prefix="cpa.stator.policy")
public class TemplateManager {
    @Option(secure=true, description="Generate templates for the lower bounds of each variable")
    private boolean generateLowerBound = true;
    @Option(secure=true, description="Generate templates for the upper bounds of each variable")
    private boolean generateUpperBound = true;
    @Option(secure=true, description="Generate octagon templates for all combinations of variables. ")
    private boolean generateOctagons = false;
    @Option(secure=true, description="Generate templates from assert statements")
    private boolean generateFromAsserts = true;
    @Option(secure=true, description="Ignore the template type and encode with a rational variable")
    private boolean encodeTemplatesAsRationals = false;
    private final CFA cfa;
    private final LogManager logger;
    private final NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> rfmgr;
    private final NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifmgr;
    private final PathFormulaManager pfmgr;
    private final FormulaManagerView fmgrv;
    private final CFAEdge dummyEdge;
    private final ImmutableSet<Template> generatedTemplates;
    private static final String TMP_VARIABLE = "__CPAchecker_TMP";
    private static final String RET_VARIABLE = "__retval__";
    private static final String ASSERT_FUNC_NAME = "assert";
    private static final String ASSERT_H_FUNC_NAME = "__assert_fail";

    public TemplateManager(LogManager pLogger, Configuration pConfig, CFA pCfa, FormulaManagerView pFormulaManagerView, PathFormulaManager pPfmgr) throws InvalidConfigurationException {
        pConfig.inject((Object)this, TemplateManager.class);
        this.pfmgr = pPfmgr;
        this.cfa = pCfa;
        this.logger = pLogger;
        this.rfmgr = pFormulaManagerView.getRationalFormulaManager();
        this.ifmgr = pFormulaManagerView.getIntegerFormulaManager();
        this.fmgrv = pFormulaManagerView;
        this.dummyEdge = new BlankEdge("", FileLocation.DUMMY, new CFANode("dummy-1"), new CFANode("dummy-2"), "Dummy Edge");
        this.generatedTemplates = this.generateFromAsserts ? ImmutableSet.copyOf(this.templatesFromAsserts()) : ImmutableSet.of();
        this.logger.log(Level.FINE, new Object[]{"hello"});
    }

    public ImmutableSet<Template> templatesForNode(CFANode node) {
        ImmutableSet.Builder out = ImmutableSet.builder();
        LiveVariables liveVariables = (LiveVariables)this.cfa.getLiveVariables().get();
        Set<ASimpleDeclaration> liveVars = liveVariables.getLiveVariablesForNode(node);
        for (ASimpleDeclaration s : liveVars) {
            if (!this.shouldProcessVariable(s)) continue;
            String varName = s.getQualifiedName();
            CSimpleType type = (CSimpleType)s.getType();
            CIdExpression idExpression = new CIdExpression(FileLocation.DUMMY, (CSimpleDeclaration)s);
            this.logger.log(Level.FINEST, new Object[]{"Processing variable", varName});
            if (this.generateUpperBound) {
                out.add((Object)new Template(LinearExpression.ofVariable(idExpression), type));
            }
            if (!this.generateLowerBound) continue;
            out.add((Object)new Template(LinearExpression.ofVariable(idExpression).negate(), type));
        }
        if (this.generateOctagons) {
            for (ASimpleDeclaration s1 : liveVars) {
                for (ASimpleDeclaration s2 : liveVars) {
                    if (!this.shouldProcessVariable(s1) || !this.shouldProcessVariable(s2) || s1 == s2 || !s1.getType().equals(s2.getType())) continue;
                    CSimpleType type = (CSimpleType)s1.getType();
                    CIdExpression idExpression1 = new CIdExpression(FileLocation.DUMMY, (CSimpleDeclaration)s1);
                    CIdExpression idExpression2 = new CIdExpression(FileLocation.DUMMY, (CSimpleDeclaration)s2);
                    LinearExpression<CIdExpression> expr1 = LinearExpression.ofVariable(idExpression1);
                    LinearExpression<CIdExpression> expr2 = LinearExpression.ofVariable(idExpression2);
                    out.add((Object)new Template(expr1.add(expr2), type));
                    out.add((Object)new Template(expr1.negate().sub(expr2), type));
                    out.add((Object)new Template(expr1.sub(expr2), type));
                    out.add((Object)new Template(expr2.sub(expr1), type));
                }
            }
        }
        out.addAll(this.generatedTemplates);
        return out.build();
    }

    public Formula toFormula(Template template, PathFormula pPathFormula) {
        return this.toFormula(template, pPathFormula, "");
    }

    public Formula toFormula(Template template, PathFormula pPathFormula, String customPrefix) {
        boolean useRationals = this.shouldUseRationals(template);
        Formula sum = null;
        for (Map.Entry<CIdExpression, Rational> entry : template.linearExpression) {
            Formula item;
            Rational coeff = entry.getValue();
            CIdExpression declaration = entry.getKey();
            try {
                item = this.pfmgr.expressionToFormula(pPathFormula, declaration, this.dummyEdge);
            }
            catch (UnrecognizedCCodeException e) {
                throw new UnsupportedOperationException();
            }
            if (coeff == Rational.ZERO) continue;
            if (coeff == Rational.NEG_ONE) {
                item = this.fmgrv.makeNegate(item);
            } else if (coeff != Rational.ONE) {
                item = this.fmgrv.makeMultiply(item, this.fmgrv.makeNumber(item, entry.getValue()));
            }
            if (sum == null) {
                sum = item;
                continue;
            }
            sum = this.fmgrv.makePlus(sum, item);
        }
        if (sum == null) {
            if (useRationals) {
                return this.rfmgr.makeNumber(0L);
            }
            return this.ifmgr.makeNumber(0L);
        }
        if (customPrefix.equals("")) {
            return sum;
        }
        return this.fmgrv.addPrefixToAll(sum, customPrefix);
    }

    public boolean shouldUseRationals(Template template) {
        if (this.encodeTemplatesAsRationals) {
            return true;
        }
        if (!template.linearExpression.isIntegral()) {
            return true;
        }
        switch (template.type.getType()) {
            case BOOL: 
            case INT: {
                return false;
            }
            case UNSPECIFIED: 
            case CHAR: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + template.type);
    }

    private boolean shouldProcessVariable(ASimpleDeclaration var) {
        return !var.getQualifiedName().contains(TMP_VARIABLE) && var.getType() instanceof CSimpleType && !var.getType().toString().contains("*") && !var.getQualifiedName().contains(RET_VARIABLE);
    }

    private Set<Template> templatesFromAsserts() {
        HashSet<Template> templates = new HashSet<Template>();
        for (CFANode node : this.cfa.getAllNodes()) {
            for (int edgeIdx = 0; edgeIdx < node.getNumLeavingEdges(); ++edgeIdx) {
                CFAEdge edge = node.getLeavingEdge(edgeIdx);
                String statement = edge.getRawStatement();
                Optional<Template> template = Optional.absent();
                if (statement.contains(ASSERT_H_FUNC_NAME) && edge instanceof CStatementEdge) {
                    for (int enteringEdgeIdx = 0; enteringEdgeIdx < node.getNumEnteringEdges(); ++enteringEdgeIdx) {
                        CFAEdge enteringEdge = node.getEnteringEdge(enteringEdgeIdx);
                        if (!(enteringEdge instanceof CAssumeEdge)) continue;
                        CAssumeEdge assumeEdge = (CAssumeEdge)enteringEdge;
                        CExpression expression = assumeEdge.getExpression();
                        template = this.recExpressionToTemplate(expression);
                    }
                } else if (statement.contains(ASSERT_FUNC_NAME) && edge instanceof CFunctionCallEdge) {
                    CFunctionCallEdge callEdge = (CFunctionCallEdge)edge;
                    if (callEdge.getArguments().isEmpty()) continue;
                    CExpression expression = callEdge.getArguments().get(0);
                    template = this.recExpressionToTemplate(expression);
                }
                if (!template.isPresent()) continue;
                Template t = (Template)template.get();
                templates.add(t);
                templates.add(new Template(t.linearExpression.negate(), t.type));
            }
        }
        return templates;
    }

    private Optional<Template> recExpressionToTemplate(CExpression expression) {
        if (expression instanceof CBinaryExpression) {
            CExpression operand1 = ((CBinaryExpression)expression).getOperand1();
            CExpression operand2 = ((CBinaryExpression)expression).getOperand2();
            CBinaryExpression.BinaryOperator operator = ((CBinaryExpression)expression).getOperator();
            Optional<Template> templateA = this.recExpressionToTemplate(operand1);
            Optional<Template> templateB = this.recExpressionToTemplate(operand2);
            if (operator == CBinaryExpression.BinaryOperator.MULTIPLY && (templateA.isPresent() || templateB.isPresent())) {
                if (operand1 instanceof CIntegerLiteralExpression && templateB.isPresent()) {
                    return Optional.of((Object)this.useCoeff((CIntegerLiteralExpression)operand1, (Template)templateB.get()));
                }
                if (operand2 instanceof CIntegerLiteralExpression && templateA.isPresent()) {
                    return Optional.of((Object)this.useCoeff((CIntegerLiteralExpression)operand2, (Template)templateA.get()));
                }
                return Optional.absent();
            }
            if (templateA.isPresent() && templateB.isPresent()) {
                LinearExpression<CIdExpression> a = ((Template)templateA.get()).linearExpression;
                LinearExpression<CIdExpression> b = ((Template)templateB.get()).linearExpression;
                CSimpleType type = ((Template)templateA.get()).type;
                Template t = operator == CBinaryExpression.BinaryOperator.PLUS ? new Template(a.add(b), type) : new Template(a.sub(b), type);
                return Optional.of((Object)t);
            }
            return Optional.absent();
        }
        if (expression instanceof CLiteralExpression && expression.getExpressionType() instanceof CSimpleType) {
            return Optional.of((Object)new Template(LinearExpression.empty(), (CSimpleType)expression.getExpressionType()));
        }
        if (expression instanceof CIdExpression && expression.getExpressionType() instanceof CSimpleType) {
            CIdExpression idExpression = (CIdExpression)expression;
            return Optional.of((Object)new Template(LinearExpression.ofVariable(idExpression), (CSimpleType)expression.getExpressionType()));
        }
        return Optional.absent();
    }

    private Template useCoeff(CIntegerLiteralExpression literal, Template other) {
        Rational coeff = Rational.ofBigInteger(literal.getValue());
        return new Template(other.linearExpression.multByConst(coeff), other.type);
    }
}

