/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.policyiteration.Location;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyAbstractedState;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyBound;
import org.sosy_lab.cpachecker.cpa.policyiteration.PolicyState;
import org.sosy_lab.cpachecker.cpa.policyiteration.Template;
import org.sosy_lab.cpachecker.cpa.policyiteration.TemplateManager;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

public class ValueDeterminationFormulaManager {
    private final FormulaManager formulaManager;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final LogManager logger;
    private final TemplateManager templateManager;
    private final int threshold;
    private static final String BOUND_VAR_NAME = "BOUND_[%s]_[%s]";
    private static final String VISIT_PREFIX = "[%d]_";

    public ValueDeterminationFormulaManager(FormulaManagerView fmgr, LogManager logger, CFA cfa, FormulaManager rfmgr, TemplateManager pTemplateManager) throws InvalidConfigurationException {
        this.fmgr = fmgr;
        this.bfmgr = fmgr.getBooleanFormulaManager();
        this.logger = logger;
        this.formulaManager = rfmgr;
        this.templateManager = pTemplateManager;
        this.threshold = this.getThreshold(cfa);
    }

    public Pair<ImmutableMap<String, FormulaType<?>>, BooleanFormula> valueDeterminationFormula(Map<Location, PolicyAbstractedState> policy, Location focusedLocation, Map<Template, PolicyBound> updated) throws CPATransferException, InterruptedException {
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        HashMap<String, FormulaType<Formula>> types = new HashMap<String, FormulaType<Formula>>();
        for (Map.Entry<Location, PolicyAbstractedState> entry : policy.entrySet()) {
            Location toLocation = entry.getKey();
            PolicyState state = entry.getValue();
            Preconditions.checkState((boolean)state.isAbstract());
            HashSet<String> visited = new HashSet<String>();
            for (Map.Entry<Template, PolicyBound> incoming : state.asAbstracted()) {
                Template template = incoming.getKey();
                PolicyBound bound = incoming.getValue();
                String prefix = String.format(VISIT_PREFIX, bound.serializePath(toLocation));
                if (toLocation == focusedLocation && !updated.containsKey(template)) {
                    Formula templateFormula = this.templateManager.toFormula(template, new PathFormula(this.bfmgr.makeBoolean(true), SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), 0), prefix);
                    BooleanFormula constraint = this.fmgr.makeLessOrEqual(templateFormula, this.fmgr.makeNumber(templateFormula, bound.bound), true);
                    constraints.add(constraint);
                } else {
                    PathFormula formula = bound.formula;
                    Location fromLocation = bound.predecessor;
                    SSAMap startSSA = bound.startSSA;
                    int toLocationNo = toLocation.toID();
                    int toLocationPrimeNo = this.toPrime(toLocationNo);
                    PathFormula prefixedPathFormula = this.pathFormulaWithCustomIdxAndPrefix(formula, toLocationPrimeNo, prefix);
                    BooleanFormula edgeFormula = prefixedPathFormula.getFormula();
                    PolicyAbstractedState incomingState = policy.get(fromLocation);
                    for (Map.Entry<Template, PolicyBound> incomingConstraint : incomingState) {
                        Template incomingTemplate = incomingConstraint.getKey();
                        Formula templateFormula = this.templateWithInitialMap(startSSA, incomingTemplate, formula, prefix);
                        String prevAbstractDomainElement = this.absDomainVarName(fromLocation, incomingTemplate);
                        Formula absDomainElementFormula = this.fmgr.makeVariable(this.fmgr.getFormulaType(templateFormula), prevAbstractDomainElement);
                        BooleanFormula constraint = this.fmgr.makeLessOrEqual(templateFormula, absDomainElementFormula, true);
                        constraints.add(constraint);
                    }
                    if (!edgeFormula.equals(this.bfmgr.makeBoolean(true)) && !visited.contains(prefix)) {
                        constraints.add(edgeFormula);
                    }
                    if (policy.get(fromLocation) == null) continue;
                    Formula outExpr = this.templateManager.toFormula(template, prefixedPathFormula, prefix);
                    String abstractDomainElement = this.absDomainVarName(toLocation, template);
                    types.put(abstractDomainElement, this.fmgr.getFormulaType(outExpr));
                    BooleanFormula outConstraint = this.fmgr.makeEqual(outExpr, this.fmgr.makeVariable(this.fmgr.getFormulaType(outExpr), abstractDomainElement));
                    this.logger.log(Level.FINE, new Object[]{"Output constraint = ", outConstraint});
                    constraints.add(outConstraint);
                }
                visited.add(prefix);
            }
        }
        return Pair.of((Object)ImmutableMap.copyOf(types), (Object)this.bfmgr.and(constraints));
    }

    private PathFormula pathFormulaWithCustomIdxAndPrefix(PathFormula p, int stopIdx, String customPrefix) throws CPATransferException, InterruptedException {
        SSAMap ssa = p.getSsa();
        SSAMap.SSAMapBuilder newMapBuilder = ssa.builder();
        BooleanFormula policyConstraint = p.getFormula();
        ArrayList<Formula> fromVars = new ArrayList<Formula>();
        ArrayList<Formula> toVars = new ArrayList<Formula>();
        Set<Triple<Formula, String, Integer>> allVars = this.fmgr.extractFreeVariables(policyConstraint);
        for (Triple<Formula, String, Integer> e : allVars) {
            int newIdx;
            String varName;
            CType type;
            Formula formula = (Formula)e.getFirst();
            Integer oldIdx = (Integer)e.getThird();
            if (oldIdx == null) {
                oldIdx = 0;
            }
            if ((type = newMapBuilder.getType(varName = (String)e.getSecond())) == null) {
                type = CNumericTypes.DOUBLE;
            }
            if (oldIdx.intValue() == ssa.getIndex(varName)) {
                newIdx = stopIdx;
                newMapBuilder = newMapBuilder.setIndex(varName, type, newIdx);
            } else {
                newIdx = oldIdx;
            }
            fromVars.add(formula);
            toVars.add(this.makeVariable(formula, varName, newIdx, customPrefix));
        }
        BooleanFormula innerFormula = this.formulaManager.getUnsafeFormulaManager().substitute(policyConstraint, fromVars, toVars);
        return new PathFormula(innerFormula, newMapBuilder.build(), p.getPointerTargetSet(), p.getLength());
    }

    private Formula makeVariable(Formula pFormula, String variable, int idx, String namespace) {
        return this.fmgr.makeVariable(this.fmgr.getFormulaType(pFormula), namespace + variable, idx);
    }

    private int getThreshold(CFA cfa) {
        double magnitude = Math.log10(cfa.getAllNodes().size());
        return Math.max(10000, (int)Math.pow(10.0, magnitude));
    }

    private int toPrime(int no) {
        return this.threshold + no;
    }

    String absDomainVarName(Location pLocation, Template template) {
        return String.format(BOUND_VAR_NAME, pLocation.toID(), template);
    }

    private Formula templateWithInitialMap(SSAMap initialMap, Template template, PathFormula p, String prefix) {
        PathFormula initialFormula = new PathFormula(p.getFormula(), initialMap, p.getPointerTargetSet(), p.getLength());
        return this.templateManager.toFormula(template, initialFormula, prefix);
    }
}

