/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.policyiteration.tests;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class PolicyIterationTest {
    private static final String TEST_DIR_PATH = "test/programs/policyiteration/";

    @Test
    public void stateful_true_assert() throws Exception {
        this.check("stateful_true_assert.c");
    }

    @Test
    public void tests_true_assert() throws Exception {
        this.check("tests_true_assert.c");
    }

    @Test
    public void loop_bounds_true_assert() throws Exception {
        this.check("loop_bounds_true_assert.c");
    }

    @Test
    public void pointer_read_true_assert() throws Exception {
        this.check("pointers/pointer_read_true_assert.c");
    }

    @Test
    public void pointer_read_false_assert() throws Exception {
        this.check("pointers/pointer_read_false_assert.c");
    }

    @Test
    public void pointer_write_false_assert() throws Exception {
        this.check("pointers/pointer_write_false_assert.c");
    }

    @Test
    public void pointer2_true_assert() throws Exception {
        this.check("pointers/pointer2_true_assert.c");
    }

    @Test
    public void loop2_true_assert() throws Exception {
        this.check("loop2_true_assert.c");
    }

    @Test
    public void simplest_false_assert() throws Exception {
        this.check("simplest_false_assert.c");
    }

    @Test
    public void loop_false_assert() throws Exception {
        this.check("loop_false_assert.c");
    }

    @Test
    public void double_pointer() throws Exception {
        this.check("pointers/double_pointer.c");
    }

    @Test
    public void loop_nested_false_assert() throws Exception {
        this.check("loop_nested_false_assert.c");
    }

    @Test
    public void pointer_past_abstraction_true_assert() throws Exception {
        this.check("pointers/pointer_past_abstraction_true_assert.c");
    }

    @Test
    public void pointer_past_abstraction_false_assert() throws Exception {
        this.check("pointers/pointer_past_abstraction_false_assert.c", (Map<String, String>)ImmutableMap.of((Object)"cpa.stator.policy.generateOctagons", (Object)"true"));
    }

    @Ignore
    @Test
    public void pointers_loop_true_assert() throws Exception {
        this.check("pointers/pointers_loop_true_assert.c", (Map<String, String>)ImmutableMap.of((Object)"cpa.stator.policy.generateOctagons", (Object)"true"));
    }

    @Test
    public void octagons_loop_true_assert() throws Exception {
        this.check("octagons/octagons_loop_true_assert.c", (Map<String, String>)ImmutableMap.of((Object)"cpa.stator.policy.generateOctagons", (Object)"true"));
    }

    @Test
    public void octagons_loop_false_assert() throws Exception {
        this.check("octagons/octagons_loop_false_assert.c", (Map<String, String>)ImmutableMap.of((Object)"cpa.stator.policy.generateOctagons", (Object)"true"));
    }

    @Test
    public void ineqality_true_assert() throws Exception {
        this.check("inequality_true_assert.c");
    }

    @Test
    public void initial_true_assert() throws Exception {
        this.check("initial_true_assert.c");
    }

    @Test
    public void template_generation_true_assert() throws Exception {
        this.check("template_generation_true_assert.c");
    }

    @Test
    public void pointers_change_aliasing_false_assert() throws Exception {
        this.check("pointers/pointers_change_aliasing_false_assert.c");
    }

    @Test
    public void fixpoint_true_assert() throws Exception {
        this.check("fixpoint_true_assert.c");
    }

    @Test
    public void formula_fail_true_assert() throws Exception {
        this.check("formula_fail_true_assert.c", (Map<String, String>)ImmutableMap.of((Object)"cpa.stator.policy.generateLowerBound", (Object)"false", (Object)"cpa.stator.policy.generateFromAsserts", (Object)"false", (Object)"cpa.stator.policy.pathFocusing", (Object)"false"));
    }

    private void check(String filename) throws Exception {
        this.check(filename, new HashMap<String, String>());
    }

    private void check(String filename, Map<String, String> extra) throws Exception {
        TestResults results = CPATestRunner.runAndLogToSTDOUT(this.getProperties(extra), Paths.get(TEST_DIR_PATH, filename).toString());
        if (filename.contains("_true_assert")) {
            results.assertIsSafe();
        } else if (filename.contains("_false_assert") || filename.contains("_false-unreach")) {
            results.assertIsUnsafe();
        }
    }

    private Map<String, String> getProperties(Map<String, String> extra) {
        return ImmutableMap.builder().put((Object)"cpa", (Object)"cpa.composite.CompositeCPA").put((Object)"CompositeCPA.cpas", (Object)Joiner.on((String)", ").join((Iterable)ImmutableList.builder().add((Object)"cpa.location.LocationCPA").add((Object)"cpa.callstack.CallstackCPA").add((Object)"cpa.policyiteration.PolicyCPA").build())).putAll(extra).put((Object)"reachedSet.export", (Object)"true").put((Object)"cpa.predicate.solver", (Object)"Z3").put((Object)"log.consoleLevel", (Object)"FINE").put((Object)"specification", (Object)"config/specification/default.spc").put((Object)"cpa.predicate.ignoreIrrelevantVariables", (Object)"false").put((Object)"parser.usePreprocessor", (Object)"true").put((Object)"cfa.findLiveVariables", (Object)"true").build();
    }
}

