/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.collect.PersistentSortedMaps;
import org.sosy_lab.cpachecker.util.predicates.pathformula.FreshValueProvider;

public class BAMFreshValueProvider
implements FreshValueProvider {
    private PersistentSortedMap<String, Integer> vars;

    @VisibleForTesting
    public BAMFreshValueProvider() {
        this.vars = PathCopyingPersistentTreeMap.of();
    }

    private BAMFreshValueProvider(PersistentSortedMap<String, Integer> diffVars) {
        this.vars = diffVars;
    }

    @Override
    public int getFreshValue(String variable, int value) {
        if (this.vars.containsKey((Object)variable) && value < (Integer)this.vars.get((Object)variable)) {
            value = (Integer)this.vars.get((Object)variable);
        }
        return value + 1;
    }

    @Override
    public FreshValueProvider merge(FreshValueProvider other) {
        if (other instanceof FreshValueProvider.DefaultFreshValueProvider) {
            return this;
        }
        if (other instanceof BAMFreshValueProvider) {
            PersistentSortedMap vars = PersistentSortedMaps.merge(this.vars, ((BAMFreshValueProvider)other).vars, (Equivalence)Equivalence.equals(), (PersistentSortedMaps.MergeConflictHandler)PersistentSortedMaps.getMaximumMergeConflictHandler(), null);
            return new BAMFreshValueProvider((PersistentSortedMap<String, Integer>)vars);
        }
        throw new AssertionError((Object)("unhandled case for FreshValueProvider: " + other.getClass()));
    }

    public void put(String variable, int index) {
        this.vars = this.vars.putAndCopy((Object)variable, (Object)index);
    }

    public boolean equals(Object other) {
        return other instanceof BAMFreshValueProvider && this.vars.equals(((BAMFreshValueProvider)other).vars);
    }

    public int hashCode() {
        return this.vars.hashCode();
    }
}

