/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.predicate.BAMBlockOperator;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPAStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateReducer;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.AuxiliaryComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.CachingRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RefineableOccurrenceComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options(prefix="cpa.predicate.bam")
public class BAMPredicateCPA
extends PredicateCPA
implements ConfigurableProgramAnalysisWithBAM {
    private final BAMPredicateReducer reducer;
    private final BAMBlockOperator blk;
    private final BAMPredicateCPAStatistics stats;
    private final RelevantPredicatesComputer relevantPredicatesComputer;
    @Option(secure=true, description="whether to use auxiliary predidates for reduction")
    private boolean auxiliaryPredicateComputer = true;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(BAMPredicateCPA.class).withOptions(BAMBlockOperator.class);
    }

    private BAMPredicateCPA(Configuration config, LogManager logger, BAMBlockOperator pBlk, CFA pCfa, ReachedSetFactory reachedSetFactory, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, CPAException {
        super(config, logger, pBlk, pCfa, reachedSetFactory, pShutdownNotifier);
        config.inject((Object)this, BAMPredicateCPA.class);
        FormulaManagerView fmgr = this.getSolver().getFormulaManager();
        RelevantPredicatesComputer relevantPredicatesComputer = this.auxiliaryPredicateComputer ? new AuxiliaryComputer(fmgr) : new RefineableOccurrenceComputer(fmgr);
        relevantPredicatesComputer = new CachingRelevantPredicatesComputer(relevantPredicatesComputer);
        this.relevantPredicatesComputer = relevantPredicatesComputer;
        this.reducer = new BAMPredicateReducer(fmgr.getBooleanFormulaManager(), this, relevantPredicatesComputer);
        this.blk = pBlk;
        this.stats = new BAMPredicateCPAStatistics(this.reducer);
    }

    RelevantPredicatesComputer getRelevantPredicatesComputer() {
        return this.relevantPredicatesComputer;
    }

    BlockPartitioning getPartitioning() {
        return this.blk.getPartitioning();
    }

    @Override
    public BAMPredicateReducer getReducer() {
        return this.reducer;
    }

    public void setPartitioning(BlockPartitioning partitioning) {
        this.blk.setPartitioning(partitioning);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        super.collectStatistics(pStatsCollection);
        pStatsCollection.add(this.stats);
    }

    BAMPredicateCPAStatistics getBAMStats() {
        return this.stats;
    }
}

