/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.predicate.BAMFreshValueProvider;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class BAMPredicateReducer
implements Reducer {
    final Timer reduceTimer = new Timer();
    final Timer expandTimer = new Timer();
    final Timer extractTimer = new Timer();
    private final PathFormulaManager pmgr;
    private final PredicateAbstractionManager pamgr;
    private final RelevantPredicatesComputer relevantComputer;
    private final LogManager logger;
    private final BooleanFormulaManager bfmgr;
    private Map<Pair<Integer, Block>, Precision> reduceCache = new HashMap<Pair<Integer, Block>, Precision>();

    public BAMPredicateReducer(BooleanFormulaManager bfmgr, BAMPredicateCPA cpa, RelevantPredicatesComputer pRelevantPredicatesComputer) {
        this.pmgr = cpa.getPathFormulaManager();
        this.pamgr = cpa.getPredicateManager();
        this.bfmgr = bfmgr;
        this.logger = cpa.getLogger();
        this.relevantComputer = pRelevantPredicatesComputer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractState getVariableReducedState(AbstractState pExpandedState, Block pContext, CFANode pLocation) {
        PredicateAbstractState predicateElement = (PredicateAbstractState)pExpandedState;
        if (!predicateElement.isAbstractionState()) {
            return predicateElement;
        }
        this.reduceTimer.start();
        try {
            AbstractionFormula oldAbstraction = predicateElement.getAbstractionFormula();
            Region oldRegion = oldAbstraction.asRegion();
            Collection<AbstractionPredicate> predicates = this.extractPredicates(oldRegion);
            Set<AbstractionPredicate> removePredicates = this.relevantComputer.getIrrelevantPredicates(pContext, predicates);
            PathFormula pathFormula = predicateElement.getPathFormula();
            assert (this.bfmgr.isTrue(pathFormula.getFormula()));
            AbstractionFormula newAbstraction = this.pamgr.reduce(oldAbstraction, removePredicates, pathFormula.getSsa());
            PersistentMap abstractionLocations = predicateElement.getAbstractionLocationsOnPath().empty();
            PredicateAbstractState predicateAbstractState = PredicateAbstractState.mkAbstractionState(this.bfmgr, pathFormula, newAbstraction, (PersistentMap<CFANode, Integer>)abstractionLocations);
            return predicateAbstractState;
        }
        finally {
            this.reduceTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        PredicateAbstractState rootState = (PredicateAbstractState)pRootState;
        PredicateAbstractState reducedState = (PredicateAbstractState)pReducedState;
        if (!reducedState.isAbstractionState()) {
            return reducedState;
        }
        this.expandTimer.start();
        try {
            AbstractionFormula rootAbstraction = rootState.getAbstractionFormula();
            AbstractionFormula reducedAbstraction = reducedState.getAbstractionFormula();
            Collection<AbstractionPredicate> rootPredicates = this.extractPredicates(rootAbstraction.asRegion());
            Set<AbstractionPredicate> relevantRootPredicates = this.relevantComputer.getRelevantPredicates(pReducedContext, rootPredicates);
            PathFormula oldPathFormula = reducedState.getPathFormula();
            assert (this.bfmgr.isTrue(oldPathFormula.getFormula())) : "Formula should be TRUE, but formula is " + oldPathFormula.getFormula();
            SSAMap oldSSA = oldPathFormula.getSsa();
            SSAMap.SSAMapBuilder builder = oldSSA.builder();
            SSAMap rootSSA = rootState.getPathFormula().getSsa();
            for (String var : rootSSA.allVariables()) {
                if (oldSSA.containsVariable(var)) continue;
                builder.setIndex(var, rootSSA.getType(var), rootSSA.getIndex(var));
            }
            SSAMap newSSA = builder.build();
            PathFormula newPathFormula = this.pmgr.makeNewPathFormula(oldPathFormula, newSSA);
            AbstractionFormula newAbstractionFormula = this.pamgr.expand(reducedAbstraction, rootAbstraction, relevantRootPredicates, newSSA);
            PersistentMap<CFANode, Integer> abstractionLocations = reducedState.getAbstractionLocationsOnPath();
            PredicateAbstractState predicateAbstractState = PredicateAbstractState.mkAbstractionState(this.bfmgr, newPathFormula, newAbstractionFormula, abstractionLocations);
            return predicateAbstractState;
        }
        finally {
            this.expandTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractionPredicate> extractPredicates(Region pRegion) {
        this.extractTimer.start();
        try {
            Set<AbstractionPredicate> set = this.pamgr.extractPredicates(pRegion);
            return set;
        }
        finally {
            this.extractTimer.stop();
        }
    }

    @Override
    public Object getHashCodeForState(AbstractState pElementKey, Precision pPrecisionKey) {
        PredicateAbstractState element = (PredicateAbstractState)pElementKey;
        PredicatePrecision precision = (PredicatePrecision)pPrecisionKey;
        return Pair.of((Object)element.getAbstractionFormula().asRegion(), (Object)precision);
    }

    public void clearCaches() {
        this.reduceCache.clear();
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        PredicatePrecision precision = (PredicatePrecision)pPrecision;
        Pair key = Pair.of((Object)precision.getId(), (Object)pContext);
        Precision result = this.reduceCache.get(key);
        if (result != null) {
            return result;
        }
        result = new ReducedPredicatePrecision(precision, pContext);
        this.reduceCache.put((Pair<Integer, Block>)key, result);
        return result;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        PredicatePrecision derivedToplevelPrecision;
        PredicatePrecision rootPrecision;
        PredicatePrecision toplevelPrecision = rootPrecision = (PredicatePrecision)pRootPrecision;
        if (rootPrecision instanceof ReducedPredicatePrecision) {
            toplevelPrecision = ((ReducedPredicatePrecision)rootPrecision).getRootPredicatePrecision();
        }
        if ((derivedToplevelPrecision = ((ReducedPredicatePrecision)pReducedPrecision).getRootPredicatePrecision()) == toplevelPrecision) {
            return pRootPrecision;
        }
        PredicatePrecision mergedToplevelPrecision = toplevelPrecision.mergeWith(derivedToplevelPrecision);
        return this.getVariableReducedPrecision(mergedToplevelPrecision, pRootContext);
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        PredicatePrecision precision = (PredicatePrecision)pPrecision;
        PredicatePrecision otherPrecision = (PredicatePrecision)pOtherPrecision;
        return precision.calculateDifferenceTo(otherPrecision);
    }

    @Override
    public AbstractState getVariableReducedStateForProofChecking(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
        return pExpandedState;
    }

    @Override
    public AbstractState getVariableExpandedStateForProofChecking(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        PredicateAbstractState rootState = (PredicateAbstractState)pRootState;
        PredicateAbstractState reducedState = (PredicateAbstractState)pReducedState;
        if (!reducedState.isAbstractionState()) {
            return reducedState;
        }
        AbstractionFormula rootAbstraction = rootState.getAbstractionFormula();
        AbstractionFormula reducedAbstraction = reducedState.getAbstractionFormula();
        this.pamgr.extractPredicates(reducedAbstraction.asInstantiatedFormula());
        Collection<AbstractionPredicate> rootPredicates = this.pamgr.extractPredicates(rootAbstraction.asInstantiatedFormula());
        Set<AbstractionPredicate> relevantRootPredicates = this.relevantComputer.getRelevantPredicates(pReducedContext, rootPredicates);
        PathFormula oldPathFormula = reducedState.getPathFormula();
        SSAMap oldSSA = oldPathFormula.getSsa();
        SSAMap.SSAMapBuilder builder = oldSSA.builder();
        SSAMap rootSSA = rootState.getPathFormula().getSsa();
        for (String var : rootSSA.allVariables()) {
            if (oldSSA.containsVariable(var)) continue;
            builder.setIndex(var, rootSSA.getType(var), rootSSA.getIndex(var));
        }
        SSAMap newSSA = builder.build();
        PathFormula newPathFormula = this.pmgr.makeNewPathFormula(this.pmgr.makeEmptyPathFormula(), newSSA);
        Region reducedRegion = this.pamgr.buildRegionFromFormula(reducedAbstraction.asFormula());
        Region rootRegion = this.pamgr.buildRegionFromFormula(rootAbstraction.asFormula());
        AbstractionFormula newAbstractionFormula = this.pamgr.expand(reducedRegion, rootRegion, relevantRootPredicates, newSSA, reducedAbstraction.getBlockFormula());
        PersistentMap<CFANode, Integer> abstractionLocations = rootState.getAbstractionLocationsOnPath();
        return PredicateAbstractState.mkAbstractionState(this.bfmgr, newPathFormula, newAbstractionFormula, abstractionLocations);
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState pRootState, AbstractState pEntryState, AbstractState pExpandedState, CFANode exitLocation) {
        PredicateAbstractState rootState = (PredicateAbstractState)pRootState;
        PredicateAbstractState entryState = (PredicateAbstractState)pEntryState;
        PredicateAbstractState expandedState = (PredicateAbstractState)pExpandedState;
        PersistentMap<CFANode, Integer> abstractionLocations = expandedState.getAbstractionLocationsOnPath();
        if (!expandedState.isAbstractionState()) {
            return expandedState;
        }
        String calledFunction = exitLocation.getFunctionName();
        PathFormula functionCall = entryState.getAbstractionFormula().getBlockFormula();
        SSAMap entrySsaWithRet = functionCall.getSsa();
        SSAMap.SSAMapBuilder entrySsaWithRetBuilder = entrySsaWithRet.builder();
        SSAMap.SSAMapBuilder summSsa = rootState.getAbstractionFormula().getBlockFormula().getSsa().builder();
        SSAMap expandedSSA = expandedState.getAbstractionFormula().getBlockFormula().getSsa();
        for (String var : expandedSSA.allVariables()) {
            int newIndex;
            CType type = expandedSSA.getType(var);
            if (var.startsWith(calledFunction + "::") && var.endsWith("__param__")) {
                newIndex = entrySsaWithRet.getIndex(var);
                assert (entrySsaWithRet.containsVariable(var)) : "param for function is not used in functioncall";
                entrySsaWithRetBuilder.setIndex(var, type, newIndex);
                BAMPredicateReducer.setFreshValueBasis(summSsa, var, newIndex);
                continue;
            }
            if (var.startsWith(calledFunction + "::") && var.endsWith("__retval__")) {
                newIndex = Math.max(expandedSSA.getIndex(var), entrySsaWithRetBuilder.getFreshIndex(var));
                entrySsaWithRetBuilder.setIndex(var, type, newIndex);
                summSsa.setIndex(var, type, newIndex);
                continue;
            }
            if (!entrySsaWithRet.containsVariable(var)) {
                newIndex = expandedSSA.getIndex(var);
                entrySsaWithRetBuilder.setIndex(var, type, newIndex);
                summSsa.setIndex(var, type, newIndex);
                continue;
            }
            newIndex = entrySsaWithRetBuilder.getFreshIndex(var);
            entrySsaWithRetBuilder.setIndex(var, type, newIndex);
            BAMPredicateReducer.setFreshValueBasis(summSsa, var, newIndex);
        }
        SSAMap newEntrySsaWithRet = entrySsaWithRetBuilder.build();
        SSAMap newSummSsa = summSsa.build();
        PathFormula functionCallWithSSA = new PathFormula(functionCall.getFormula(), newEntrySsaWithRet, functionCall.getPointerTargetSet(), functionCall.getLength());
        PathFormula executedFunction = this.pmgr.makeAnd(functionCallWithSSA, expandedState.getAbstractionFormula().asFormula());
        PathFormula executedFunctionWithSSA = new PathFormula(executedFunction.getFormula(), newSummSsa, executedFunction.getPointerTargetSet(), executedFunction.getLength());
        PredicateAbstractState.ComputeAbstractionState rebuildState = new PredicateAbstractState.ComputeAbstractionState(executedFunctionWithSSA, rootState.getAbstractionFormula(), exitLocation, abstractionLocations);
        this.logger.log(Level.ALL, new Object[]{"\noldAbs: ", rootState.getAbstractionFormula().asInstantiatedFormula(), "\ncall: ", functionCallWithSSA, "\nsumm: ", expandedState.getAbstractionFormula().asFormula(), "\nexe: ", executedFunction, "\nentrySsaRet", newEntrySsaWithRet, "\nsummSsaRet", newSummSsa});
        return rebuildState;
    }

    protected static SSAMap updateIndices(SSAMap rootSSA, SSAMap expandedSSA) {
        SSAMap.SSAMapBuilder rootBuilder = rootSSA.builder();
        for (String var : expandedSSA.allVariables()) {
            if (!expandedSSA.containsVariable(var)) continue;
            CType type = expandedSSA.getType(var);
            if (var.contains("::") && !BAMPredicateReducer.isReturnVar(var)) {
                if (!rootSSA.containsVariable(var)) {
                    rootBuilder.setIndex(var, type, expandedSSA.builder().getFreshIndex(var));
                    continue;
                }
                BAMPredicateReducer.setFreshValueBasis(rootBuilder, var, Math.max(expandedSSA.builder().getFreshIndex(var), rootSSA.getIndex(var)));
                continue;
            }
            rootBuilder.setIndex(var, type, expandedSSA.getIndex(var));
        }
        return rootBuilder.build();
    }

    private static boolean isReturnVar(String var) {
        return var.contains("::") && "__retval__".equals(var.substring(var.indexOf("::") + 2));
    }

    private static void setFreshValueBasis(SSAMap.SSAMapBuilder ssa, String name, int idx) {
        Preconditions.checkArgument((idx > 0 ? 1 : 0) != 0, (String)"Indices need to be positive for this SSAMap implementation:", (Object[])new Object[]{name, idx});
        int oldIdx = ssa.getIndex(name);
        Preconditions.checkArgument((idx >= oldIdx ? 1 : 0) != 0, (String)"SSAMap updates need to be strictly monotone:", (Object[])new Object[]{name, idx, "vs", oldIdx});
        if (idx > oldIdx) {
            BAMFreshValueProvider bamfvp = new BAMFreshValueProvider();
            bamfvp.put(name, idx);
            ssa.mergeFreshValueProviderWith(bamfvp);
        }
    }

    private class ReducedPredicatePrecision
    extends PredicatePrecision {
        private final PredicatePrecision rootPredicatePrecision;
        private final PredicatePrecision expandedPredicatePrecision;
        private final Block context;
        private ImmutableSetMultimap<CFANode, AbstractionPredicate> evaluatedPredicateMap;
        private ImmutableSet<AbstractionPredicate> evaluatedGlobalPredicates;

        public ReducedPredicatePrecision(PredicatePrecision expandedPredicatePrecision, Block context) {
            super((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<CFANode, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<String, AbstractionPredicate>)ImmutableSetMultimap.of(), (Collection<AbstractionPredicate>)ImmutableSet.of());
            assert (expandedPredicatePrecision.getLocationInstancePredicates().isEmpty()) : "TODO: need to handle location-instance-specific predicates in ReducedPredicatePrecision";
            this.expandedPredicatePrecision = expandedPredicatePrecision;
            this.context = context;
            this.rootPredicatePrecision = expandedPredicatePrecision instanceof ReducedPredicatePrecision ? ((ReducedPredicatePrecision)expandedPredicatePrecision).getRootPredicatePrecision() : expandedPredicatePrecision;
            assert (!(this.rootPredicatePrecision instanceof ReducedPredicatePrecision));
            this.evaluatedPredicateMap = null;
            this.evaluatedGlobalPredicates = null;
        }

        public PredicatePrecision getRootPredicatePrecision() {
            return this.rootPredicatePrecision;
        }

        private void computeView() {
            if (this.evaluatedPredicateMap == null) {
                ReducedPredicatePrecision lExpandedPredicatePrecision = null;
                if (this.expandedPredicatePrecision instanceof ReducedPredicatePrecision) {
                    lExpandedPredicatePrecision = (ReducedPredicatePrecision)this.expandedPredicatePrecision;
                }
                this.evaluatedGlobalPredicates = ImmutableSet.copyOf(BAMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getGlobalPredicates()));
                ImmutableSetMultimap.Builder pmapBuilder = ImmutableSetMultimap.builder();
                Set keySet = lExpandedPredicatePrecision == null ? this.rootPredicatePrecision.getLocalPredicates().keySet() : lExpandedPredicatePrecision.approximatePredicateMap().keySet();
                for (CFANode node : keySet) {
                    if (!this.context.getNodes().contains(node)) continue;
                    Set<AbstractionPredicate> set = BAMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getPredicates(node, 0));
                    pmapBuilder.putAll((Object)node, set);
                }
                this.evaluatedPredicateMap = pmapBuilder.build();
            }
        }

        private SetMultimap<CFANode, AbstractionPredicate> approximatePredicateMap() {
            if (this.evaluatedPredicateMap == null) {
                return this.rootPredicatePrecision.getLocalPredicates();
            }
            return this.evaluatedPredicateMap;
        }

        @Override
        public ImmutableSetMultimap<CFANode, AbstractionPredicate> getLocalPredicates() {
            this.computeView();
            return this.evaluatedPredicateMap;
        }

        @Override
        public ImmutableSetMultimap<String, AbstractionPredicate> getFunctionPredicates() {
            return this.rootPredicatePrecision.getFunctionPredicates();
        }

        @Override
        public Set<AbstractionPredicate> getGlobalPredicates() {
            if (this.evaluatedGlobalPredicates != null) {
                return this.evaluatedGlobalPredicates;
            }
            return BAMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getGlobalPredicates());
        }

        @Override
        public Set<AbstractionPredicate> getPredicates(CFANode loc, Integer locInstance) {
            if (!this.context.getNodes().contains(loc)) {
                BAMPredicateReducer.this.logger.log(Level.WARNING, new Object[]{this.context, "was left in an unexpected way. Analysis might be unsound."});
            }
            if (this.evaluatedPredicateMap != null) {
                ImmutableSet<AbstractionPredicate> result = this.evaluatedPredicateMap.get((Object)loc);
                if (result.isEmpty()) {
                    result = this.evaluatedGlobalPredicates;
                }
                String functionName = loc.getFunctionName();
                return Sets.union(result, (Set)this.rootPredicatePrecision.getFunctionPredicates().get((Object)functionName)).immutableCopy();
            }
            Set<AbstractionPredicate> result = BAMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getPredicates(loc, locInstance));
            if (result.isEmpty()) {
                result = BAMPredicateReducer.this.relevantComputer.getRelevantPredicates(this.context, this.rootPredicatePrecision.getGlobalPredicates());
            }
            return result;
        }

        @Override
        public boolean equals(Object pObj) {
            if (pObj == this) {
                return true;
            }
            if (pObj == null) {
                return false;
            }
            if (!pObj.getClass().equals(this.getClass())) {
                return false;
            }
            this.computeView();
            return this.evaluatedPredicateMap.equals(((ReducedPredicatePrecision)pObj).evaluatedPredicateMap);
        }

        @Override
        public int hashCode() {
            this.computeView();
            return this.evaluatedPredicateMap.hashCode();
        }

        @Override
        public String toString() {
            if (this.evaluatedPredicateMap != null) {
                return this.evaluatedPredicateMap.toString();
            }
            return "ReducedPredicatePrecision (view not computed yet)";
        }
    }
}

