/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMBasedRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateReducer;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAssumeStore;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStaticRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RefineableRelevantPredicatesComputer;
import org.sosy_lab.cpachecker.cpa.predicate.relevantpredicates.RelevantPredicatesComputer;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public final class BAMPredicateRefiner
extends AbstractBAMBasedRefiner
implements StatisticsProvider {
    private final ExtendedPredicateRefiner refiner;

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        return new BAMPredicateRefiner(pCpa);
    }

    public BAMPredicateRefiner(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(BAMPredicateRefiner.class.getSimpleName() + " could not find the PredicateCPA");
        }
        BAMPredicateCPA predicateCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(BAMPredicateCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(BAMPredicateRefiner.class.getSimpleName() + " needs an BAMPredicateCPA");
        }
        LogManager logger = predicateCpa.getLogger();
        InterpolationManager manager = new InterpolationManager(predicateCpa.getPathFormulaManager(), predicateCpa.getSolver(), predicateCpa.getConfiguration(), predicateCpa.getShutdownNotifier(), logger);
        PathChecker pathChecker = new PathChecker(logger, predicateCpa.getShutdownNotifier(), predicateCpa.getPathFormulaManager(), predicateCpa.getSolver(), predicateCpa.getMachineModel());
        BAMPredicateAbstractionRefinementStrategy strategy = new BAMPredicateAbstractionRefinementStrategy(predicateCpa.getConfiguration(), logger, predicateCpa, predicateCpa.getSolver(), predicateCpa.getPredicateManager(), predicateCpa.getStaticRefiner());
        this.refiner = new ExtendedPredicateRefiner(predicateCpa.getConfiguration(), logger, pCpa, manager, pathChecker, predicateCpa.getPathFormulaManager(), strategy, predicateCpa.getSolver(), predicateCpa.getAssumesStore(), predicateCpa.getCfa());
    }

    @Override
    protected final CounterexampleInfo performRefinement0(ARGReachedSet pReached, ARGPath pPath) throws CPAException, InterruptedException {
        return this.refiner.performRefinement(pReached, pPath);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.refiner.collectStatistics(pStatsCollection);
    }

    private static class BAMPredicateAbstractionRefinementStrategy
    extends PredicateAbstractionRefinementStrategy {
        private final RefineableRelevantPredicatesComputer relevantPredicatesComputer;
        private final BAMPredicateCPA predicateCpa;
        private List<Region> lastAbstractions = null;
        private boolean refinedLastRelevantPredicatesComputer = false;
        private static final Function<PredicateAbstractState, Region> GET_REGION = new Function<PredicateAbstractState, Region>(){

            public Region apply(PredicateAbstractState e) {
                assert (e.isAbstractionState());
                return e.getAbstractionFormula().asRegion();
            }
        };

        private BAMPredicateAbstractionRefinementStrategy(Configuration config, LogManager logger, BAMPredicateCPA predicateCpa, Solver pSolver, PredicateAbstractionManager pPredAbsMgr, PredicateStaticRefiner pStaticRefiner) throws CPAException, InvalidConfigurationException {
            super(config, logger, predicateCpa.getShutdownNotifier(), pPredAbsMgr, pStaticRefiner, pSolver);
            RelevantPredicatesComputer relevantPredicatesComputer = predicateCpa.getRelevantPredicatesComputer();
            this.relevantPredicatesComputer = relevantPredicatesComputer instanceof RefineableRelevantPredicatesComputer ? (RefineableRelevantPredicatesComputer)relevantPredicatesComputer : null;
            this.predicateCpa = predicateCpa;
        }

        private List<Region> getRegionsForPath(List<ARGState> path) throws CPATransferException {
            return FluentIterable.from(path).transform(AbstractStates.toState(PredicateAbstractState.class)).transform(GET_REGION).toList();
        }

        @Override
        public void performRefinement(ARGReachedSet pReached, List<ARGState> pPath, List<BooleanFormula> pInterpolants, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
            boolean refinedRelevantPredicatesComputer = false;
            if (pRepeatedCounterexample && (pRepeatedCounterexample = this.getRegionsForPath(pPath).equals(this.lastAbstractions)) && !this.refinedLastRelevantPredicatesComputer && this.relevantPredicatesComputer != null) {
                this.refineRelevantPredicatesComputer(pPath, pReached);
                pRepeatedCounterexample = false;
                refinedRelevantPredicatesComputer = true;
            }
            this.lastAbstractions = this.getRegionsForPath(pPath);
            this.refinedLastRelevantPredicatesComputer = refinedRelevantPredicatesComputer;
            super.performRefinement(pReached, pPath, pInterpolants, pRepeatedCounterexample);
        }

        private void refineRelevantPredicatesComputer(List<ARGState> pPath, ARGReachedSet pReached) {
            UnmodifiableReachedSet reached = pReached.asReachedSet();
            Precision oldPrecision = reached.getPrecision(reached.getLastState());
            PredicatePrecision oldPredicatePrecision = Precisions.extractPrecisionByType(oldPrecision, PredicatePrecision.class);
            BlockPartitioning partitioning = this.predicateCpa.getPartitioning();
            ArrayDeque<Block> openBlocks = new ArrayDeque<Block>();
            openBlocks.push(partitioning.getMainBlock());
            for (ARGState pathElement : pPath) {
                CFANode currentNode = AbstractStates.extractLocation(pathElement);
                Integer currentNodeInstance = (Integer)PredicateAbstractState.getPredicateState(pathElement).getAbstractionLocationsOnPath().get((Object)currentNode);
                if (partitioning.isCallNode(currentNode)) {
                    openBlocks.push(partitioning.getBlockForCallNode(currentNode));
                }
                Set<AbstractionPredicate> localPreds = oldPredicatePrecision.getPredicates(currentNode, currentNodeInstance);
                for (Block block : openBlocks) {
                    for (AbstractionPredicate pred : localPreds) {
                        this.relevantPredicatesComputer.considerPredicateAsRelevant(block, pred);
                    }
                }
                while (((Block)openBlocks.peek()).isReturnNode(currentNode)) {
                    openBlocks.pop();
                }
            }
            this.predicateCpa.getReducer().clearCaches();
        }

        @Override
        protected void analyzePathPrecisions(ARGReachedSet argReached, List<ARGState> path) {
        }
    }

    private static final class ExtendedPredicateRefiner
    extends PredicateCPARefiner {
        private final Timer ssaRenamingTimer = new Timer();

        private ExtendedPredicateRefiner(Configuration config, LogManager logger, ConfigurableProgramAnalysis pCpa, InterpolationManager pInterpolationManager, PathChecker pPathChecker, PathFormulaManager pPathFormulaManager, RefinementStrategy pStrategy, Solver pSolver, PredicateAssumeStore pAssumesStore, CFA pCfa) throws CPAException, InvalidConfigurationException {
            super(config, logger, pCpa, pInterpolationManager, pPathChecker, pPathFormulaManager, pStrategy, pSolver, pAssumesStore, pCfa);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final List<BooleanFormula> getFormulasForPath(List<ARGState> pPath, ARGState initialState) throws CPATransferException, InterruptedException {
            this.ssaRenamingTimer.start();
            try {
                List<BooleanFormula> list = this.computeBlockFormulas(initialState);
                return list;
            }
            finally {
                this.ssaRenamingTimer.stop();
            }
        }

        private List<BooleanFormula> computeBlockFormulas(ARGState pRoot) throws CPATransferException, InterruptedException {
            HashMap callStacks = new HashMap();
            HashMap<ARGState, PathFormula> finishedFormulas = new HashMap<ARGState, PathFormula>();
            ArrayList<BooleanFormula> abstractionFormulas = new ArrayList<BooleanFormula>();
            ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
            assert (pRoot.getParents().isEmpty()) : "rootState must be the first state of the program";
            callStacks.put(pRoot, null);
            finishedFormulas.put(pRoot, this.pfmgr.makeEmptyPathFormula());
            waitlist.addAll(pRoot.getChildren());
            while (!waitlist.isEmpty()) {
                PathFormula currentFormula;
                ARGState currentState = (ARGState)waitlist.pollFirst();
                if (finishedFormulas.containsKey(currentState)) continue;
                if (!finishedFormulas.keySet().containsAll(currentState.getParents())) {
                    waitlist.addLast(currentState);
                    continue;
                }
                ArrayList<PathFormula> currentFormulas = new ArrayList<PathFormula>(currentState.getParents().size());
                ArrayList<ARGState> currentStacks = new ArrayList<ARGState>(currentState.getParents().size());
                for (ARGState parentElement : currentState.getParents()) {
                    ARGState prevCallState;
                    PathFormula parentFormula = (PathFormula)finishedFormulas.get(parentElement);
                    CFAEdge edge = parentElement.getEdgeToChild(currentState);
                    assert (edge != null) : "ARG is invalid: parent has no edge to child";
                    if (edge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
                        prevCallState = parentElement;
                    } else if (edge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                        assert (callStacks.containsKey(parentElement));
                        ARGState callState = (ARGState)callStacks.get(parentElement);
                        assert (AbstractStates.extractLocation(callState).getLeavingSummaryEdge().getSuccessor() == AbstractStates.extractLocation(currentState)) : "callstack does not match entry of current function-exit.";
                        assert (callState != null || currentState.getChildren().isEmpty()) : "returning from empty callstack is only possible at program-exit";
                        prevCallState = (ARGState)callStacks.get(callState);
                        parentFormula = this.rebuildStateAfterFunctionCall(parentFormula, (PathFormula)finishedFormulas.get(callState));
                    } else {
                        assert (callStacks.containsKey(parentElement));
                        prevCallState = (ARGState)callStacks.get(parentElement);
                    }
                    PathFormula currentFormula2 = this.pfmgr.makeAnd(parentFormula, edge);
                    currentFormulas.add(currentFormula2);
                    currentStacks.add(prevCallState);
                }
                assert (currentFormulas.size() >= 1) : "each state except root must have parents";
                assert (currentStacks.size() == currentFormulas.size()) : "number of callstacks must match predecessors";
                assert (Sets.newHashSet(currentStacks).size() <= 1) : "function with multiple entry-states not supported";
                callStacks.put(currentState, currentStacks.get(0));
                PredicateAbstractState predicateElement = AbstractStates.extractStateByType(currentState, PredicateAbstractState.class);
                if (predicateElement.isAbstractionState()) {
                    assert (waitlist.isEmpty()) : "todo should be empty, because of the special ARG structure";
                    assert (currentState.getParents().size() == 1) : "there should be only one parent, because of the special ARG structure";
                    currentFormula = (PathFormula)Iterables.getOnlyElement(currentFormulas);
                    abstractionFormulas.add(currentFormula.getFormula());
                    currentFormula = this.pfmgr.makeEmptyPathFormula(currentFormula);
                } else {
                    Iterator it = currentFormulas.iterator();
                    currentFormula = (PathFormula)it.next();
                    while (it.hasNext()) {
                        currentFormula = this.pfmgr.makeOr(currentFormula, (PathFormula)it.next());
                    }
                }
                assert (!finishedFormulas.containsKey(currentState)) : "a state should only be finished once";
                finishedFormulas.put(currentState, currentFormula);
                waitlist.addAll(currentState.getChildren());
            }
            return abstractionFormulas;
        }

        private PathFormula rebuildStateAfterFunctionCall(PathFormula parentFormula, PathFormula rootFormula) {
            SSAMap newSSA = BAMPredicateReducer.updateIndices(rootFormula.getSsa(), parentFormula.getSsa());
            return this.pfmgr.makeNewPathFormula(parentFormula, newSSA);
        }

        @Override
        public void collectStatistics(Collection<Statistics> pStatsCollection) {
            pStatsCollection.add(new PredicateCPARefiner.Stats(){

                @Override
                public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
                    super.printStatistics(out, result, reached);
                    out.println("Time for SSA renaming:                " + ExtendedPredicateRefiner.this.ssaRenamingTimer);
                }
            });
        }
    }
}

