/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class BlockFormulaSlicer {
    private static final boolean IS_BLANK_EDGE_IMPORTANT = false;
    private final PathFormulaManager pfmgr;
    private final boolean sliceBlockFormulas;
    private final Multimap<ARGState, ARGState> importantEdges = ArrayListMultimap.create();
    private static final Function<PredicateAbstractState, BooleanFormula> GET_BLOCK_FORMULA = new Function<PredicateAbstractState, BooleanFormula>(){

        public BooleanFormula apply(PredicateAbstractState e) {
            assert (e.isAbstractionState());
            return e.getAbstractionFormula().getBlockFormula().getFormula();
        }
    };
    private static final Function<PathFormula, BooleanFormula> GET_BOOLEAN_FORMULA = new Function<PathFormula, BooleanFormula>(){

        public BooleanFormula apply(PathFormula pf) {
            return pf.getFormula();
        }
    };

    public BlockFormulaSlicer(PathFormulaManager pPfmgr) {
        this.pfmgr = pPfmgr;
        this.sliceBlockFormulas = true;
    }

    public List<BooleanFormula> sliceFormulasForPath(List<ARGState> path, ARGState initialState) throws CPATransferException, InterruptedException {
        ArrayList<Set<ARGState>> blocks = new ArrayList<Set<ARGState>>(path.size());
        for (int i = 0; i < path.size(); ++i) {
            ARGState start = i > 0 ? path.get(i - 1) : initialState;
            ARGState end = path.get(i);
            blocks.add(this.getARGStatesOfBlock(start, end));
        }
        assert (path.size() == blocks.size());
        Collection<String> importantVars = new LinkedHashSet<String>();
        for (int i = path.size() - 1; i >= 0; --i) {
            ARGState start = i > 0 ? path.get(i - 1) : initialState;
            ARGState end = path.get(i);
            Set block = (Set)blocks.get(i);
            importantVars = this.sliceBlock(start, end, block, importantVars);
        }
        PathFormula pf = this.pfmgr.makeEmptyPathFormula();
        ArrayList<PathFormula> pfs = new ArrayList<PathFormula>(path.size());
        for (int i = 0; i < path.size(); ++i) {
            ARGState start = i > 0 ? path.get(i - 1) : initialState;
            ARGState end = path.get(i);
            Set block = (Set)blocks.remove(0);
            PathFormula oldPf = this.pfmgr.makeEmptyPathFormula(pf);
            pf = this.buildFormula(start, end, block, oldPf);
            pfs.add(pf);
        }
        return FluentIterable.from(pfs).transform(GET_BOOLEAN_FORMULA).toList();
    }

    private Set<ARGState> getARGStatesOfBlock(ARGState start, ARGState end) {
        HashSet<ARGState> states = new HashSet<ARGState>();
        states.add(start);
        states.add(end);
        LinkedList<ARGState> waitlist = new LinkedList<ARGState>();
        waitlist.add(end);
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)waitlist.remove(0);
            for (ARGState parent : current.getParents()) {
                if (!states.add(parent)) continue;
                waitlist.add(parent);
            }
        }
        return states;
    }

    private Collection<String> sliceBlock(ARGState start, ARGState end, Set<ARGState> block, Collection<String> importantVars) {
        HashMap s2v = Maps.newHashMapWithExpectedSize((int)block.size());
        HashMultimap s2s = HashMultimap.create((int)block.size(), (int)1);
        LinkedHashSet<ARGState> waitlist = new LinkedHashSet<ARGState>();
        s2v.put(end, importantVars);
        s2s.put((Object)end, (Object)end);
        for (ARGState parent : end.getParents()) {
            if (!block.contains(parent)) continue;
            waitlist.add(parent);
        }
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)Iterables.getFirst(waitlist, null);
            waitlist.remove(current);
            assert (!s2v.keySet().contains(current));
            if (!this.isAllChildrenDone(current, s2v.keySet(), block)) {
                waitlist.add(current);
                continue;
            }
            for (ARGState parent : current.getParents()) {
                if (!block.contains(parent)) continue;
                waitlist.add(parent);
            }
            Collection<String> vars = this.handleEdgesForState(current, s2v, (Multimap<ARGState, ARGState>)s2s, block);
            s2v.put(current, vars);
            for (ARGState child : current.getChildren()) {
                if (!block.contains(child) || !this.isAllParentsDone(child, s2v.keySet(), block)) continue;
                s2v.remove(child);
                s2s.removeAll((Object)child);
            }
        }
        return (Collection)s2v.get(start);
    }

    private Collection<String> handleEdgesForState(ARGState current, Map<ARGState, Collection<String>> s2v, Multimap<ARGState, ARGState> s2s, Set<ARGState> block) {
        ImmutableList usedChildren = FluentIterable.from(current.getChildren()).filter(Predicates.in(block)).toList();
        assert (usedChildren.size() > 0) : "no child for " + current.getStateId();
        if (this.isAssumptionWithSameImpChild((List<ARGState>)usedChildren, current, s2s)) {
            ARGState child1 = (ARGState)usedChildren.get(0);
            s2s.putAll((Object)current, (Iterable)s2s.get((Object)child1));
            LinkedHashSet<String> iVars = new LinkedHashSet<String>();
            iVars.addAll(s2v.get(child1));
            return iVars;
        }
        Collection<String> iVars = null;
        for (ARGState child : usedChildren) {
            Collection<String> newVars;
            Collection<String> oldVars = s2v.get(child);
            if (child.getParents().size() == 1) {
                newVars = oldVars;
            } else {
                newVars = new LinkedHashSet<String>();
                newVars.addAll(oldVars);
            }
            CFAEdge edge = current.getEdgeToChild(child);
            boolean isImportant = this.handleEdge(edge, newVars);
            assert (!this.importantEdges.containsEntry((Object)current, (Object)child));
            if (isImportant) {
                this.importantEdges.put((Object)current, (Object)child);
                s2s.put((Object)current, (Object)current);
            } else {
                s2s.putAll((Object)current, (Iterable)s2s.get((Object)child));
            }
            if (iVars == null) {
                iVars = newVars;
                continue;
            }
            iVars.addAll(newVars);
        }
        Preconditions.checkNotNull(iVars);
        return iVars;
    }

    private boolean isAssumptionWithSameImpChild(List<ARGState> usedChildren, ARGState current, Multimap<ARGState, ARGState> s2s) {
        if (usedChildren.size() == 2) {
            ARGState child1 = usedChildren.get(0);
            ARGState child2 = usedChildren.get(1);
            CFAEdge edge1 = current.getEdgeToChild(child1);
            CFAEdge edge2 = current.getEdgeToChild(child2);
            if (edge1.getEdgeType() == CFAEdgeType.AssumeEdge && edge2.getEdgeType() == CFAEdgeType.AssumeEdge) {
                CAssumeEdge assume1 = (CAssumeEdge)edge1;
                CAssumeEdge assume2 = (CAssumeEdge)edge2;
                return assume1.getExpression() == assume2.getExpression() && assume1.getTruthAssumption() != assume2.getTruthAssumption() && s2s.get((Object)child1).equals(s2s.get((Object)child2));
            }
        }
        return false;
    }

    private boolean handleEdge(CFAEdge edge, Collection<String> importantVars) {
        boolean result;
        switch (edge.getEdgeType()) {
            case DeclarationEdge: {
                result = this.handleDeclaration((CDeclarationEdge)edge, importantVars);
                break;
            }
            case AssumeEdge: {
                result = this.handleAssumption((CAssumeEdge)edge, importantVars);
                break;
            }
            case StatementEdge: {
                result = this.handleStatement((CStatementEdge)edge, importantVars);
                break;
            }
            case ReturnStatementEdge: {
                result = this.handleReturnStatement((CReturnStatementEdge)edge, importantVars);
                break;
            }
            case FunctionReturnEdge: {
                result = this.handleFunctionReturn((CFunctionReturnEdge)edge, importantVars);
                break;
            }
            case FunctionCallEdge: {
                result = this.handleFunctionCall((CFunctionCallEdge)edge, importantVars);
                break;
            }
            case BlankEdge: {
                result = false;
                break;
            }
            case MultiEdge: {
                throw new AssertionError((Object)("multiEdge not supported: " + edge.getRawStatement()));
            }
            default: {
                throw new AssertionError((Object)("unhandled edge: " + edge.getRawStatement()));
            }
        }
        return result;
    }

    private boolean handleDeclaration(CDeclarationEdge edge, Collection<String> importantVars) {
        CDeclaration decl = edge.getDeclaration();
        if (decl instanceof CVariableDeclaration) {
            CVariableDeclaration vdecl = (CVariableDeclaration)decl;
            String functionName = edge.getPredecessor().getFunctionName();
            if (importantVars.remove(this.buildVarName(vdecl.isGlobal() ? null : functionName, vdecl.getName()))) {
                CInitializer initializer = vdecl.getInitializer();
                if (initializer != null && initializer instanceof CInitializerExpression) {
                    CExpression init = ((CInitializerExpression)initializer).getExpression();
                    this.addAllVarsFromExpr(init, functionName, importantVars);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean handleAssumption(CAssumeEdge edge, Collection<String> importantVars) {
        CExpression expression = edge.getExpression();
        String functionName = edge.getPredecessor().getFunctionName();
        this.addAllVarsFromExpr(expression, functionName, importantVars);
        return true;
    }

    private boolean handleStatement(CStatementEdge edge, Collection<String> importantVars) {
        CStatement statement = edge.getStatement();
        if (statement instanceof CAssignment) {
            return this.handleAssignment((CAssignment)statement, edge, importantVars);
        }
        if (statement instanceof CFunctionCallStatement) {
            return this.handleExternalFunctionCall(edge, ((CFunctionCallStatement)statement).getFunctionCallExpression().getParameterExpressions());
        }
        if (statement instanceof CExpressionStatement) {
            return false;
        }
        throw new AssertionError((Object)("unhandled statement: " + edge.getRawStatement()));
    }

    private boolean handleAssignment(CAssignment statement, CFAEdge edge, Collection<String> importantVars) {
        CLeftHandSide lhs = statement.getLeftHandSide();
        if (lhs instanceof CIdExpression) {
            String varName;
            String functionName = edge.getPredecessor().getFunctionName();
            String scopedFunctionName = BlockFormulaSlicer.isGlobal(lhs) ? null : functionName;
            if (importantVars.remove(this.buildVarName(scopedFunctionName, varName = ((CIdExpression)lhs).getName()))) {
                CRightHandSide rhs = statement.getRightHandSide();
                if (rhs instanceof CExpression) {
                    this.addAllVarsFromExpr((CExpression)rhs, functionName, importantVars);
                    return true;
                }
                if (rhs instanceof CFunctionCallExpression) {
                    return true;
                }
                throw new AssertionError((Object)"unknown class");
            }
            return false;
        }
        return true;
    }

    private boolean handleExternalFunctionCall(CStatementEdge pEdge, List<CExpression> parameterExpressions) {
        return true;
    }

    private boolean handleReturnStatement(CReturnStatementEdge edge, Collection<String> importantVars) {
        if (!edge.asAssignment().isPresent()) {
            return false;
        }
        return this.handleAssignment((CAssignment)edge.asAssignment().get(), edge, importantVars);
    }

    private boolean handleFunctionReturn(CFunctionReturnEdge edge, Collection<String> importantVars) {
        CFunctionSummaryEdge fnkCall = edge.getSummaryEdge();
        CFunctionCall call = fnkCall.getExpression();
        if (call instanceof CFunctionCallAssignmentStatement) {
            Optional<CVariableDeclaration> returnVar;
            String outerFunctionName;
            CFunctionCallAssignmentStatement cAssignment = (CFunctionCallAssignmentStatement)call;
            CLeftHandSide lhs = cAssignment.getLeftHandSide();
            String innerFunctionName = edge.getPredecessor().getFunctionName();
            String string = outerFunctionName = BlockFormulaSlicer.isGlobal(lhs) ? null : edge.getSuccessor().getFunctionName();
            if (importantVars.remove(this.buildVarName(outerFunctionName, lhs.toASTString())) && (returnVar = edge.getFunctionEntry().getReturnVariable()).isPresent()) {
                importantVars.add(this.buildVarName(innerFunctionName, ((CVariableDeclaration)returnVar.get()).getName()));
                return true;
            }
            return false;
        }
        if (call instanceof CFunctionCallStatement) {
            return false;
        }
        throw new AssertionError((Object)("unhandled functionreturn " + call));
    }

    private boolean handleFunctionCall(CFunctionCallEdge edge, Collection<String> importantVars) {
        List<CExpression> args = edge.getArguments();
        List<CParameterDeclaration> params = edge.getSuccessor().getFunctionParameters();
        assert (args.size() >= params.size());
        String innerFunctionName = edge.getSuccessor().getFunctionName();
        String outerFunctionName = edge.getPredecessor().getFunctionName();
        for (int i = 0; i < params.size(); ++i) {
            if (!importantVars.remove(this.buildVarName(innerFunctionName, params.get(i).getName()))) continue;
            this.addAllVarsFromExpr(args.get(i), outerFunctionName, importantVars);
        }
        return true;
    }

    private String buildVarName(String function, String var) {
        if (function == null) {
            return var;
        }
        return function + "::" + var;
    }

    private void addAllVarsFromExpr(CExpression exp, String functionName, Collection<String> importantVars) {
        exp.accept(new VarCollector(functionName, importantVars));
    }

    private PathFormula buildFormula(ARGState start, ARGState end, Collection<ARGState> block, PathFormula oldPf) throws CPATransferException, InterruptedException {
        HashMap s2f = Maps.newHashMapWithExpectedSize((int)block.size());
        LinkedHashSet<ARGState> waitlist = new LinkedHashSet<ARGState>();
        s2f.put(start, oldPf);
        for (ARGState child : start.getChildren()) {
            if (!block.contains(child)) continue;
            waitlist.add(child);
        }
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)Iterables.getFirst(waitlist, null);
            waitlist.remove(current);
            assert (!s2f.keySet().contains(current));
            if (!this.isAllParentsDone(current, s2f.keySet(), block)) {
                waitlist.add(current);
                continue;
            }
            for (ARGState child : current.getChildren()) {
                if (!block.contains(child)) continue;
                waitlist.add(child);
            }
            PathFormula pf = this.makeFormulaForState(current, s2f);
            s2f.put(current, pf);
            for (ARGState parent : current.getParents()) {
                if (!block.contains(parent) || !this.isAllChildrenDone(parent, s2f.keySet(), block)) continue;
                s2f.remove(parent);
            }
        }
        return (PathFormula)s2f.get(end);
    }

    private PathFormula makeFormulaForState(ARGState current, Map<ARGState, PathFormula> s2f) throws CPATransferException, InterruptedException {
        assert (current.getParents().size() > 0) : "no parent for " + current.getStateId();
        ArrayList<PathFormula> pfs = new ArrayList<PathFormula>(current.getParents().size());
        for (ARGState parent : current.getParents()) {
            PathFormula oldPf = s2f.get(parent);
            pfs.add(this.buildFormulaForEdge(parent, current, oldPf));
        }
        PathFormula joined = (PathFormula)pfs.get(0);
        for (int i = 1; i < pfs.size(); ++i) {
            joined = this.pfmgr.makeOr(joined, (PathFormula)pfs.get(i));
        }
        return joined;
    }

    private PathFormula buildFormulaForEdge(ARGState parent, ARGState child, PathFormula oldFormula) throws CPATransferException, InterruptedException {
        if (this.sliceBlockFormulas && !this.importantEdges.containsEntry((Object)parent, (Object)child)) {
            return oldFormula;
        }
        return this.pfmgr.makeAnd(oldFormula, parent.getEdgeToChild(child));
    }

    private static boolean isGlobal(CExpression exp) {
        CSimpleDeclaration decl;
        if (exp instanceof CIdExpression && (decl = ((CIdExpression)exp).getDeclaration()) instanceof CDeclaration) {
            return ((CDeclaration)decl).isGlobal();
        }
        return false;
    }

    private boolean isAllChildrenDone(ARGState s, Collection<ARGState> done, Collection<ARGState> subset) {
        for (ARGState child : s.getChildren()) {
            if (!subset.contains(child) || done.contains(child)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllParentsDone(ARGState s, Collection<ARGState> done, Collection<ARGState> subset) {
        for (ARGState parent : s.getParents()) {
            if (!subset.contains(parent) || done.contains(parent)) continue;
            return false;
        }
        return true;
    }

    private static String printFormula(String formula) {
        StringBuilder str = new StringBuilder();
        String IND = "    ";
        int indent = 0;
        int pos = 0;
        boolean closed = false;
        while (pos != -1) {
            int i;
            int open = formula.indexOf(40, pos + 1);
            int close = formula.indexOf(41, pos + 1);
            if (open != -1 && open < close) {
                str.append('\n');
                for (i = 0; i < indent; ++i) {
                    str.append("    ");
                }
                ++indent;
                if (closed) {
                    str.append("    ");
                }
                closed = false;
                str.append(formula.substring(pos, open));
                pos = open;
                continue;
            }
            if (close == -1) break;
            str.append('\n');
            for (i = 0; i < indent; ++i) {
                str.append("    ");
            }
            --indent;
            if (closed) {
                str.append("    ");
            }
            closed = true;
            str.append(formula.substring(pos, close));
            pos = close;
        }
        return str.toString();
    }

    private class VarCollector
    extends DefaultCExpressionVisitor<Void, RuntimeException> {
        final Collection<String> vars;
        private final String functionName;

        VarCollector(String functionName, Collection<String> vars) {
            this.functionName = functionName;
            this.vars = vars;
        }

        @Override
        protected Void visitDefault(CExpression pExp) {
            return null;
        }

        @Override
        public Void visit(CBinaryExpression exp) {
            exp.getOperand1().accept(this);
            exp.getOperand2().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression exp) {
            exp.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CComplexCastExpression exp) {
            exp.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CIdExpression exp) {
            String var = exp.getName();
            String function = BlockFormulaSlicer.isGlobal(exp) ? null : this.functionName;
            this.vars.add(BlockFormulaSlicer.this.buildVarName(function, var));
            return null;
        }

        @Override
        public Void visit(CUnaryExpression exp) {
            exp.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CPointerExpression exp) {
            exp.getOperand().accept(this);
            return null;
        }
    }
}

