/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.ImpactUtility;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;

class ImpactRefinementStrategy
extends RefinementStrategy {
    private final Stats stats = new Stats();
    private final BooleanFormulaManagerView bfmgr;
    private final PredicateAbstractionManager predAbsMgr;
    private final ImpactUtility impact;
    private AbstractionFormula lastAbstraction = null;

    protected ImpactRefinementStrategy(Configuration config, LogManager logger, Solver pSolver, PredicateAbstractionManager pPredAbsMgr) throws InvalidConfigurationException, CPAException {
        super(pSolver);
        this.bfmgr = pSolver.getFormulaManager().getBooleanFormulaManager();
        this.predAbsMgr = pPredAbsMgr;
        this.impact = new ImpactUtility(config, pSolver.getFormulaManager(), pPredAbsMgr);
    }

    @Override
    protected void startRefinementOfPath() {
        Preconditions.checkState((this.lastAbstraction == null ? 1 : 0) != 0);
        this.lastAbstraction = this.predAbsMgr.makeTrueAbstractionFormula(null);
    }

    @Override
    protected boolean performRefinementForState(BooleanFormula itp, ARGState s) throws SolverException, InterruptedException {
        Preconditions.checkArgument((!this.bfmgr.isTrue(itp) ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.bfmgr.isFalse(itp) ? 1 : 0) != 0);
        boolean stateChanged = this.impact.strengthenStateWithInterpolant(itp, s, this.lastAbstraction);
        this.lastAbstraction = PredicateAbstractState.getPredicateState(s).getAbstractionFormula();
        return !stateChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishRefinementOfPath(ARGState infeasiblePartOfART, List<ARGState> changedElements, ARGReachedSet pReached, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        Preconditions.checkState((this.lastAbstraction != null ? 1 : 0) != 0);
        this.lastAbstraction = null;
        this.stats.argUpdate.start();
        for (ARGState w : changedElements) {
            pReached.removeCoverageOf(w);
        }
        pReached.removeInfeasiblePartofARG(infeasiblePartOfART);
        this.stats.argUpdate.stop();
        this.stats.coverTime.start();
        try {
            for (ARGState w : changedElements) {
                if (!pReached.tryToCover(w)) continue;
                break;
            }
        }
        finally {
            this.stats.coverTime.stop();
        }
    }

    @Override
    public Statistics getStatistics() {
        return this.stats;
    }

    private class Stats
    implements Statistics {
        private final Timer coverTime = new Timer();
        private final Timer argUpdate = new Timer();

        private Stats() {
        }

        @Override
        public String getName() {
            return "Impact Refiner";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("  Computing abstraction of itp:       " + ((ImpactRefinementStrategy)ImpactRefinementStrategy.this).impact.abstractionTime);
            out.println("  Checking whether itp is new:        " + ((ImpactRefinementStrategy)ImpactRefinementStrategy.this).impact.itpCheckTime);
            out.println("  Coverage checks:                    " + this.coverTime);
            out.println("  ARG update:                         " + this.argUpdate);
            out.println();
            out.println("Number of abstractions during refinements:  " + ((ImpactRefinementStrategy)ImpactRefinementStrategy.this).impact.abstractionTime.getNumberOfIntervals());
            ImpactRefinementStrategy.this.basicRefinementStatistics.printStatistics(out, pResult, pReached);
        }
    }
}

