/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

@Options(prefix="cpa.predicate.refinement")
final class ImpactUtility {
    @Option(secure=true, description="If an abstraction is computed during refinement, use only the interpolant as input, not the concrete block.")
    private boolean abstractInterpolantOnly = false;
    @Option(secure=true, description="Actually compute an abstraction, otherwise just convert the interpolants to BDDs as they are.")
    private boolean doAbstractionComputation = false;
    final Timer abstractionTime = new Timer();
    final Timer itpCheckTime = new Timer();
    private final FormulaManagerView fmgr;
    private final PredicateAbstractionManager predAbsMgr;

    ImpactUtility(Configuration config, FormulaManagerView pFmgr, PredicateAbstractionManager pPredAbsMgr) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (!this.doAbstractionComputation && this.abstractInterpolantOnly) {
            throw new InvalidConfigurationException("Setting cpa.predicate.refinement.abstractInterpolantOnly=true is not possible without cpa.predicate.refinement.doAbstractionComputation=true.");
        }
        this.fmgr = pFmgr;
        this.predAbsMgr = pPredAbsMgr;
    }

    boolean requiresPreviousBlockAbstraction() {
        return this.doAbstractionComputation && !this.abstractInterpolantOnly;
    }

    boolean strengthenStateWithInterpolant(BooleanFormula itp, ARGState s, AbstractionFormula lastAbstraction) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.requiresPreviousBlockAbstraction() || lastAbstraction != null ? 1 : 0) != 0);
        if (this.fmgr.getBooleanFormulaManager().isTrue(itp)) {
            return false;
        }
        PredicateAbstractState predicateState = PredicateAbstractState.getPredicateState(s);
        AbstractionFormula existingAbstraction = predicateState.getAbstractionFormula();
        PathFormula blockFormula = existingAbstraction.getBlockFormula();
        if (itp.equals(existingAbstraction.asInstantiatedFormula())) {
            return false;
        }
        CFANode location = AbstractStates.extractLocation(s);
        Collection<AbstractionPredicate> preds = this.predAbsMgr.extractPredicates(itp);
        this.abstractionTime.start();
        AbstractionFormula newAbstraction = !this.doAbstractionComputation ? this.predAbsMgr.buildAbstraction(this.fmgr.uninstantiate(itp), blockFormula) : (this.abstractInterpolantOnly ? this.predAbsMgr.buildAbstraction(location, itp, blockFormula, preds) : this.predAbsMgr.buildAbstraction(location, lastAbstraction, blockFormula, preds));
        this.abstractionTime.stop();
        this.itpCheckTime.start();
        boolean isNewItp = !this.predAbsMgr.checkCoverage(existingAbstraction, newAbstraction);
        this.itpCheckTime.stop();
        if (isNewItp) {
            newAbstraction = this.predAbsMgr.makeAnd(existingAbstraction, newAbstraction);
            predicateState.setAbstraction(newAbstraction);
        }
        return isNewItp;
    }
}

