/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.predicate")
public class PredicateAbstractDomain
implements AbstractDomain {
    @Option(secure=true, description="whether to include the symbolic path formula in the coverage checks or do only the fast abstract checks")
    private boolean symbolicCoverageCheck = false;
    public final Timer coverageCheckTimer = new Timer();
    public final Timer bddCoverageCheckTimer = new Timer();
    public final Timer symbolicCoverageCheckTimer = new Timer();
    private final PredicateAbstractionManager mgr;

    public PredicateAbstractDomain(PredicateCPA pCpa, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this, PredicateAbstractDomain.class);
        this.mgr = pCpa.getPredicateManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLessOrEqual(AbstractState element1, AbstractState element2) throws CPAException, InterruptedException {
        this.coverageCheckTimer.start();
        try {
            PredicateAbstractState e1 = (PredicateAbstractState)element1;
            PredicateAbstractState e2 = (PredicateAbstractState)element2;
            if (e1.isAbstractionState() && e2.isAbstractionState()) {
                this.bddCoverageCheckTimer.start();
                boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e2.getAbstractionFormula());
                this.bddCoverageCheckTimer.stop();
                boolean bl = result;
                return bl;
            }
            if (e2.isAbstractionState()) {
                if (this.symbolicCoverageCheck) {
                    this.symbolicCoverageCheckTimer.start();
                    boolean result = this.mgr.checkCoverage(e1.getAbstractionFormula(), e1.getPathFormula(), e2.getAbstractionFormula());
                    this.symbolicCoverageCheckTimer.stop();
                    boolean bl = result;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (e1.isAbstractionState()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = e1.getMergedInto() == e2;
            return bl;
        }
        finally {
            this.coverageCheckTimer.stop();
        }
    }

    @Override
    public AbstractState join(AbstractState pElement1, AbstractState pElement2) throws CPAException {
        throw new UnsupportedOperationException();
    }
}

