/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.NonMergeableAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public abstract class PredicateAbstractState
implements AbstractState,
Partitionable,
Serializable {
    private static final long serialVersionUID = -265763837277453447L;
    public static final Predicate<PredicateAbstractState> FILTER_ABSTRACTION_STATES = new Predicate<PredicateAbstractState>(){

        public boolean apply(PredicateAbstractState ae) {
            return ae.isAbstractionState();
        }
    };
    private PathFormula pathFormula;
    private AbstractionFormula abstractionFormula;
    private final transient PersistentMap<CFANode, Integer> abstractionLocations;

    public static PredicateAbstractState getPredicateState(AbstractState pState) {
        return (PredicateAbstractState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(pState, PredicateAbstractState.class));
    }

    public static PredicateAbstractState mkAbstractionState(BooleanFormulaManager bfmgr, PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
        return new AbstractionState(bfmgr, pF, pA, pAbstractionLocations);
    }

    public static PredicateAbstractState mkNonAbstractionStateWithNewPathFormula(PathFormula pF, PredicateAbstractState oldState) {
        return new NonAbstractionState(pF, oldState.getAbstractionFormula(), oldState.getAbstractionLocationsOnPath());
    }

    private PredicateAbstractState(PathFormula pf, AbstractionFormula a, PersistentMap<CFANode, Integer> pAbstractionLocations) {
        this.pathFormula = pf;
        this.abstractionFormula = a;
        this.abstractionLocations = pAbstractionLocations;
    }

    public abstract boolean isAbstractionState();

    PredicateAbstractState getMergedInto() {
        throw new UnsupportedOperationException("Assuming wrong PredicateAbstractStates were merged!");
    }

    void setMergedInto(PredicateAbstractState pMergedInto) {
        throw new UnsupportedOperationException("Merging wrong PredicateAbstractStates!");
    }

    public PersistentMap<CFANode, Integer> getAbstractionLocationsOnPath() {
        return this.abstractionLocations;
    }

    public AbstractionFormula getAbstractionFormula() {
        return this.abstractionFormula;
    }

    void setAbstraction(AbstractionFormula pAbstractionFormula) {
        if (!this.isAbstractionState()) {
            throw new UnsupportedOperationException("Changing abstraction formula is only supported for abstraction elements");
        }
        this.abstractionFormula = (AbstractionFormula)Preconditions.checkNotNull((Object)pAbstractionFormula);
    }

    public void setPathFormula(PathFormula pPathFormula) {
        this.pathFormula = (PathFormula)Preconditions.checkNotNull((Object)pPathFormula);
    }

    public PathFormula getPathFormula() {
        return this.pathFormula;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this instanceof AbstractionState) {
            FormulaManagerView mgr = GlobalInfo.getInstance().getFormulaManager();
            return new AbstractionState(mgr.getBooleanFormulaManager(), this.pathFormula, this.abstractionFormula, (PersistentMap)PathCopyingPersistentTreeMap.of());
        }
        return new NonAbstractionState(this.pathFormula, this.abstractionFormula, (PersistentMap)PathCopyingPersistentTreeMap.of());
    }

    public static class ComputeAbstractionState
    extends PredicateAbstractState {
        private static final long serialVersionUID = -3961784113582993743L;
        private final transient CFANode location;

        public ComputeAbstractionState(PathFormula pf, AbstractionFormula pA, CFANode pLoc, PersistentMap<CFANode, Integer> pAbstractionLocations) {
            super(pf, pA, pAbstractionLocations);
            this.location = pLoc;
        }

        @Override
        public boolean isAbstractionState() {
            return false;
        }

        @Override
        public Object getPartitionKey() {
            return this;
        }

        public String toString() {
            return "Abstraction location: true, Abstraction: <TO COMPUTE>";
        }

        public CFANode getLocation() {
            return this.location;
        }
    }

    private static class NonAbstractionState
    extends PredicateAbstractState {
        private static final long serialVersionUID = -6912172362012773999L;
        private transient PredicateAbstractState mergedInto = null;

        private NonAbstractionState(PathFormula pF, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
            super(pF, pA, pAbstractionLocations);
        }

        @Override
        public boolean isAbstractionState() {
            return false;
        }

        @Override
        PredicateAbstractState getMergedInto() {
            return this.mergedInto;
        }

        @Override
        void setMergedInto(PredicateAbstractState pMergedInto) {
            Preconditions.checkNotNull((Object)pMergedInto);
            this.mergedInto = pMergedInto;
        }

        @Override
        public Object getPartitionKey() {
            return this.getAbstractionFormula();
        }

        public String toString() {
            return "Abstraction location: false";
        }
    }

    private static class AbstractionState
    extends PredicateAbstractState
    implements NonMergeableAbstractState,
    Graphable {
        private static final long serialVersionUID = 8341054099315063986L;

        private AbstractionState(BooleanFormulaManager bfmgr, PathFormula pf, AbstractionFormula pA, PersistentMap<CFANode, Integer> pAbstractionLocations) {
            super(pf, pA, pAbstractionLocations);
        }

        @Override
        public Object getPartitionKey() {
            if (((PredicateAbstractState)this).abstractionFormula.isFalse()) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public boolean isAbstractionState() {
            return true;
        }

        public String toString() {
            return "Abstraction location: true, Abstraction: " + ((PredicateAbstractState)this).abstractionFormula;
        }

        @Override
        public String toDOTLabel() {
            return ((PredicateAbstractState)this).abstractionFormula.toString();
        }

        @Override
        public boolean shouldBeHighlighted() {
            return true;
        }
    }
}

