/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.NestedTimer;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateAbstractionsStorage;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.DefaultCanonicalizer;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.LinCombineRule;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;

@Options(prefix="cpa.predicate")
public class PredicateAbstractionManager {
    final Stats stats = new Stats();
    private final LogManager logger;
    private final FormulaManagerView fmgr;
    private final AbstractionManager amgr;
    private final AbstractionManager.RegionCreator rmgr;
    private final PathFormulaManager pfmgr;
    private final Solver solver;
    private static final Set<Integer> noAbstractionReuse = ImmutableSet.of();
    @Option(secure=true, name="abstraction.cartesian", description="whether to use Boolean (false) or Cartesian (true) abstraction")
    @Deprecated
    private boolean cartesianAbstraction = false;
    @Option(secure=true, name="abstraction.computation", description="whether to use Boolean or Cartesian abstraction or both")
    private AbstractionType abstractionType = AbstractionType.BOOLEAN;
    @Option(secure=true, name="abstraction.dumpHardQueries", description="dump the abstraction formulas if they took to long")
    private boolean dumpHardAbstractions = false;
    @Option(secure=true, name="abstraction.reuseAbstractionsFrom", description="An initial set of comptued abstractions that might be reusable")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path reuseAbstractionsFrom;
    @Option(secure=true, description="Max. number of edge of the abstraction tree to prescan for reuse")
    private int maxAbstractionReusePrescan = 1;
    @Option(secure=true, name="abs.useCache", description="use caching of abstractions")
    private boolean useCache = true;
    @Option(secure=true, name="refinement.splitItpAtoms", description="split each arithmetic equality into two inequalities when extracting predicates from interpolants")
    private boolean splitItpAtoms = false;
    @Option(secure=true, name="abstraction.identifyTrivialPredicates", description="Identify those predicates where the result is trivially known before abstraction computation and omit them.")
    private boolean identifyTrivialPredicates = false;
    @Option(secure=true, name="abstraction.simplify", description="Simplify the abstraction formula that is stored to represent the state space. Helpful when debugging (formulas get smaller).")
    private boolean simplifyAbstractionFormula = false;
    @Option(secure=true, name="abstraction.elimDeadVariablePreds", description="Eliminate propositions about dead variables in abstraction predicates by running a generalization procedure.")
    private boolean elimDeadVariablePredsByGeneralization = false;
    private boolean warnedOfCartesianAbstraction = false;
    private boolean abstractionReuseDisabledBecauseOfAmbiguity = false;
    private final Map<Pair<BooleanFormula, ImmutableSet<AbstractionPredicate>>, AbstractionFormula> abstractionCache;
    private final Set<BooleanFormula> unsatisfiabilityCache;
    private final Map<Pair<BooleanFormula, AbstractionPredicate>, Byte> cartesianAbstractionCache;
    private final BooleanFormulaManagerView bfmgr;
    private final PredicateAbstractionsStorage abstractionStorage;
    private Optional<LiveVariables> liveVars;
    private Function<AbstractionPredicate, BooleanFormula> predicateToFormula = new Function<AbstractionPredicate, BooleanFormula>(){

        public BooleanFormula apply(AbstractionPredicate pArg0) {
            return pArg0.getSymbolicAtom();
        }
    };
    private Function<BooleanFormula, AbstractionPredicate> formulaToPredicate = new Function<BooleanFormula, AbstractionPredicate>(){

        public AbstractionPredicate apply(BooleanFormula pArg0) {
            return PredicateAbstractionManager.this.createPredicateFor(pArg0);
        }
    };

    public PredicateAbstractionManager(AbstractionManager pAmgr, FormulaManagerView pFmgr, PathFormulaManager pPfmgr, Solver pSolver, Configuration config, LogManager pLogger, Optional<LiveVariables> pLiveVars) throws InvalidConfigurationException, PredicatePersistenceUtils.PredicateParsingFailedException {
        config.inject((Object)this, PredicateAbstractionManager.class);
        this.logger = pLogger;
        this.fmgr = pFmgr;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.amgr = pAmgr;
        this.rmgr = this.amgr.getRegionCreator();
        this.pfmgr = pPfmgr;
        this.solver = pSolver;
        this.liveVars = pLiveVars;
        if (this.cartesianAbstraction) {
            this.abstractionType = AbstractionType.CARTESIAN;
        }
        if (this.abstractionType == AbstractionType.COMBINED) {
            this.warnedOfCartesianAbstraction = true;
        }
        if (this.useCache) {
            this.abstractionCache = new HashMap<Pair<BooleanFormula, ImmutableSet<AbstractionPredicate>>, AbstractionFormula>();
            this.unsatisfiabilityCache = new HashSet<BooleanFormula>();
        } else {
            this.abstractionCache = null;
            this.unsatisfiabilityCache = null;
        }
        this.cartesianAbstractionCache = this.useCache && this.abstractionType != AbstractionType.BOOLEAN ? new HashMap<Pair<BooleanFormula, AbstractionPredicate>, Byte>() : null;
        this.abstractionStorage = new PredicateAbstractionsStorage(this.reuseAbstractionsFrom, this.logger, this.fmgr);
        SSAMap extractionSsa = SSAMap.emptySSAMap().withDefault(1);
        for (PredicateAbstractionsStorage.AbstractionNode an : this.abstractionStorage.getAbstractions().values()) {
            BooleanFormula instanceFm = this.fmgr.instantiate(an.getFormula(), extractionSsa);
            this.extractPredicates(instanceFm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractionFormula buildAbstraction(CFANode location, AbstractionFormula abstractionFormula, PathFormula pathFormula, Collection<AbstractionPredicate> pPredicates) throws SolverException, InterruptedException {
        Region abs;
        Pair absKey;
        ImmutableSet predicates;
        SSAMap ssa;
        BooleanFormula f;
        block65: {
            Object instantiatedFormula;
            ++this.stats.numCallsAbstraction;
            this.logger.log(Level.FINEST, new Object[]{"Computing abstraction", this.stats.numCallsAbstraction, "with", pPredicates.size(), "predicates"});
            this.logger.log(Level.ALL, new Object[]{"Old abstraction:", abstractionFormula.asFormula()});
            this.logger.log(Level.ALL, new Object[]{"Path formula:", pathFormula});
            this.logger.log(Level.ALL, new Object[]{"Predicates:", pPredicates});
            BooleanFormula absFormula = abstractionFormula.asInstantiatedFormula();
            BooleanFormula symbFormula = this.buildFormula(pathFormula.getFormula());
            f = this.bfmgr.and(absFormula, symbFormula);
            ssa = pathFormula.getSsa();
            predicates = this.getRelevantPredicates(pPredicates, f, ssa, location);
            if (this.reuseAbstractionsFrom != null && !this.abstractionReuseDisabledBecauseOfAmbiguity) {
                this.stats.abstractionReuseTime.start();
                ProverEnvironment reuseEnv = this.solver.newProverEnvironment();
                try {
                    reuseEnv.push(f);
                    ArrayDeque<Pair> tryReuseBasedOnPredecessors = new ArrayDeque<Pair>();
                    ImmutableSet<Integer> idsOfStoredAbstractionReused = abstractionFormula.getIdsOfStoredAbstractionReused();
                    for (Integer id : idsOfStoredAbstractionReused) {
                        tryReuseBasedOnPredecessors.add(Pair.of((Object)id, (Object)0));
                    }
                    if (tryReuseBasedOnPredecessors.isEmpty()) {
                        tryReuseBasedOnPredecessors.add(Pair.of((Object)this.abstractionStorage.getRootAbstractionId(), (Object)0));
                    }
                    while (!tryReuseBasedOnPredecessors.isEmpty()) {
                        Pair tryBasedOn = (Pair)tryReuseBasedOnPredecessors.pop();
                        int tryBasedOnAbstractionId = (Integer)tryBasedOn.getFirst();
                        int tryLevel = (Integer)tryBasedOn.getSecond();
                        if (tryLevel > this.maxAbstractionReusePrescan) continue;
                        Set<PredicateAbstractionsStorage.AbstractionNode> candidateAbstractions = this.getSuccessorsInAbstractionTree(tryBasedOnAbstractionId);
                        Preconditions.checkNotNull(candidateAbstractions);
                        Iterator<PredicateAbstractionsStorage.AbstractionNode> candidateIterator = candidateAbstractions.iterator();
                        while (candidateIterator.hasNext()) {
                            PredicateAbstractionsStorage.AbstractionNode an = candidateIterator.next();
                            Preconditions.checkNotNull((Object)an);
                            tryReuseBasedOnPredecessors.add(Pair.of((Object)an.getId(), (Object)(tryLevel + 1)));
                            if (this.bfmgr.isTrue(an.getFormula())) {
                                candidateIterator.remove();
                                continue;
                            }
                            if (!an.getLocationId().isPresent() || location.getNodeNumber() == ((Integer)an.getLocationId().get()).intValue()) continue;
                            candidateIterator.remove();
                        }
                        if (candidateAbstractions.size() > 1) {
                            this.logger.log(Level.WARNING, new Object[]{"Too many abstraction candidates on location", location, "for abstraction", tryBasedOnAbstractionId, ". Disabling abstraction reuse!"});
                            this.abstractionReuseDisabledBecauseOfAmbiguity = true;
                            tryReuseBasedOnPredecessors.clear();
                            continue;
                        }
                        TreeSet reuseIds = Sets.newTreeSet();
                        BooleanFormula reuseFormula = this.bfmgr.makeBoolean(true);
                        for (PredicateAbstractionsStorage.AbstractionNode an : candidateAbstractions) {
                            reuseFormula = this.bfmgr.and(reuseFormula, an.getFormula());
                            this.abstractionStorage.markAbstractionBeingReused(an.getId());
                            reuseIds.add(an.getId());
                        }
                        BooleanFormula instantiatedReuseFormula = this.fmgr.instantiate(reuseFormula, ssa);
                        this.stats.abstractionReuseImplicationTime.start();
                        reuseEnv.push(this.bfmgr.not(instantiatedReuseFormula));
                        boolean implication = reuseEnv.isUnsat();
                        reuseEnv.pop();
                        this.stats.abstractionReuseImplicationTime.stop();
                        if (!implication) continue;
                        ++this.stats.numAbstractionReuses;
                        Region reuseFormulaRegion = this.buildRegionFromFormula(reuseFormula);
                        AbstractionFormula abstractionFormula2 = new AbstractionFormula(this.fmgr, reuseFormulaRegion, reuseFormula, instantiatedReuseFormula, pathFormula, reuseIds);
                        return abstractionFormula2;
                    }
                }
                finally {
                    reuseEnv.close();
                    this.stats.abstractionReuseTime.stop();
                }
            }
            if (pPredicates.isEmpty() && this.abstractionType != AbstractionType.ELIMINATION) {
                this.logger.log(Level.FINEST, new Object[]{"Abstraction", this.stats.numCallsAbstraction, "with empty precision is true"});
                ++this.stats.numSymbolicAbstractions;
                return this.makeTrueAbstractionFormula(pathFormula);
            }
            absKey = null;
            if (this.useCache) {
                boolean unsatisfiable;
                absKey = Pair.of((Object)f, predicates);
                AbstractionFormula result = this.abstractionCache.get(absKey);
                if (result != null) {
                    BooleanFormula stateFormula = result.asFormula();
                    instantiatedFormula = this.fmgr.instantiate(stateFormula, ssa);
                    result = new AbstractionFormula(this.fmgr, result.asRegion(), stateFormula, (BooleanFormula)instantiatedFormula, pathFormula, (Set<Integer>)result.getIdsOfStoredAbstractionReused());
                    this.logger.log(Level.FINEST, new Object[]{"Abstraction", this.stats.numCallsAbstraction, "was cached"});
                    this.logger.log(Level.ALL, new Object[]{"Abstraction result is", result.asFormula()});
                    ++this.stats.numCallsAbstractionCached;
                    return result;
                }
                boolean bl = unsatisfiable = this.unsatisfiabilityCache.contains(symbFormula) || this.unsatisfiabilityCache.contains(f);
                if (unsatisfiable) {
                    this.logger.log(Level.FINEST, new Object[]{"Block feasibility of abstraction", this.stats.numCallsAbstraction, "was cached and is false."});
                    ++this.stats.numCallsAbstractionCached;
                    return new AbstractionFormula(this.fmgr, this.rmgr.makeFalse(), this.bfmgr.makeBoolean(false), this.bfmgr.makeBoolean(false), pathFormula, noAbstractionReuse);
                }
            }
            this.stats.numTotalPredicates += pPredicates.size();
            this.stats.maxPredicates = Math.max(this.stats.maxPredicates, pPredicates.size());
            this.stats.numIrrelevantPredicates += pPredicates.size() - predicates.size();
            abs = this.rmgr.makeTrue();
            if (this.identifyTrivialPredicates) {
                this.stats.trivialPredicatesTime.start();
                abs = this.identifyTrivialPredicates((Collection<AbstractionPredicate>)predicates, abstractionFormula, pathFormula);
                predicates = FluentIterable.from(predicates).filter(Predicates.not((Predicate)Predicates.in(this.amgr.extractPredicates(abs)))).toSet();
                this.stats.trivialPredicatesTime.stop();
            }
            ProverEnvironment thmProver = this.solver.newProverEnvironment();
            instantiatedFormula = null;
            try {
                thmProver.push(f);
                if (predicates.isEmpty() && this.abstractionType != AbstractionType.ELIMINATION) {
                    boolean feasibility;
                    ++this.stats.numSatCheckAbstractions;
                    this.stats.abstractionSolveTime.start();
                    try {
                        feasibility = !thmProver.isUnsat();
                    }
                    finally {
                        this.stats.abstractionSolveTime.stop();
                    }
                    if (!feasibility) {
                        abs = this.rmgr.makeFalse();
                    }
                    break block65;
                }
                if (this.abstractionType == AbstractionType.ELIMINATION) {
                    this.stats.quantifierEliminationTime.start();
                    try {
                        abs = this.rmgr.makeAnd(abs, this.eliminateIrrelevantVariablePropositions(f, location, ssa, thmProver, (ImmutableSet<AbstractionPredicate>)predicates));
                        break block65;
                    }
                    finally {
                        this.stats.quantifierEliminationTime.stop();
                    }
                }
                if (this.abstractionType != AbstractionType.BOOLEAN) {
                    this.stats.cartesianAbstractionTime.start();
                    try {
                        abs = this.rmgr.makeAnd(abs, this.buildCartesianAbstraction(f, ssa, thmProver, (Collection<AbstractionPredicate>)predicates));
                    }
                    finally {
                        this.stats.cartesianAbstractionTime.stop();
                    }
                }
                if (this.abstractionType == AbstractionType.COMBINED) {
                    predicates = FluentIterable.from((Iterable)predicates).filter(Predicates.not((Predicate)Predicates.in(this.amgr.extractPredicates(abs)))).toSet();
                }
                if (this.abstractionType == AbstractionType.CARTESIAN || predicates.isEmpty()) break block65;
                this.stats.numBooleanAbsPredicates += predicates.size();
                this.stats.booleanAbstractionTime.start();
                try {
                    abs = this.rmgr.makeAnd(abs, this.buildBooleanAbstraction(ssa, thmProver, (Collection<AbstractionPredicate>)predicates));
                }
                finally {
                    this.stats.booleanAbstractionTime.stop();
                }
            }
            catch (Throwable throwable) {
                instantiatedFormula = throwable;
                throw throwable;
            }
            finally {
                if (thmProver != null) {
                    if (instantiatedFormula != null) {
                        try {
                            thmProver.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)instantiatedFormula).addSuppressed(x2);
                        }
                    } else {
                        thmProver.close();
                    }
                }
            }
        }
        AbstractionFormula result = this.makeAbstractionFormula(abs, ssa, pathFormula);
        if (this.useCache) {
            this.abstractionCache.put((Pair<BooleanFormula, ImmutableSet<AbstractionPredicate>>)absKey, result);
            if (result.isFalse()) {
                this.unsatisfiabilityCache.add(f);
            }
        }
        long abstractionTime = TimeSpan.sum((TimeSpan)this.stats.abstractionSolveTime.getLengthOfLastInterval(), (TimeSpan)this.stats.abstractionEnumTime.getLengthOfLastOuterInterval()).asMillis();
        this.logger.log(Level.FINEST, new Object[]{"Computing abstraction took", abstractionTime, "ms"});
        this.logger.log(Level.ALL, new Object[]{"Abstraction result is", result.asFormula()});
        if (this.dumpHardAbstractions && abstractionTime > 10000L) {
            Path dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", this.stats.numCallsAbstraction, "input", 0);
            this.fmgr.dumpFormulaToFile(f, dumpFile);
            dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", this.stats.numCallsAbstraction, "predicates", 0);
            try (Writer w = dumpFile.asCharSink(StandardCharsets.UTF_8, new FileWriteMode[0]).openBufferedStream();){
                Joiner.on((char)'\n').appendTo((Appendable)w, (Iterable)predicates);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to wrote predicates to file");
            }
            dumpFile = this.fmgr.formatFormulaOutputFile("abstraction", this.stats.numCallsAbstraction, "result", 0);
            this.fmgr.dumpFormulaToFile(result.asInstantiatedFormula(), dumpFile);
        }
        return result;
    }

    private Region eliminateIrrelevantVariablePropositions(BooleanFormula pF, CFANode pLocation, SSAMap pSsa, ProverEnvironment pThmProver, ImmutableSet<AbstractionPredicate> pPredicates) throws InterruptedException, SolverException {
        BooleanFormula eliminationResult = this.fmgr.uninstantiate(this.fmgr.eliminateDeadVariables(pF, pSsa));
        Collection<BooleanFormula> atoms = this.fmgr.extractAtoms(eliminationResult, false, false);
        for (BooleanFormula atom : atoms) {
            this.amgr.makePredicate(atom);
            this.extractPredicates(atom);
        }
        return this.amgr.buildRegionFromFormula(eliminationResult);
    }

    private ImmutableSet<AbstractionPredicate> getRelevantPredicates(Collection<AbstractionPredicate> pPredicates, BooleanFormula f, SSAMap ssa, CFANode pLocation) throws SolverException, InterruptedException {
        Set<String> variables = this.fmgr.extractVariableNames(f);
        HashMultimap elimPredicatesOnDeadVariables = HashMultimap.create();
        ImmutableSet.Builder predicateBuilder = ImmutableSet.builder();
        for (AbstractionPredicate predicate : pPredicates) {
            Sets.SetView deadPredVariables;
            BooleanFormula predicateTerm = predicate.getSymbolicAtom();
            if (this.bfmgr.isFalse(predicateTerm)) {
                this.logger.log(Level.FINEST, new Object[]{"Ignoring predicate 'false'"});
                continue;
            }
            BooleanFormula instantiatedPredicate = this.fmgr.instantiate(predicateTerm, ssa);
            Map<String, Formula> predVariables = this.fmgr.extractFreeVariableMap(instantiatedPredicate);
            if (this.liveVars.isPresent()) {
                Set<String> liveVariabes = this.fmgr.instantiate(((LiveVariables)this.liveVars.get()).getLiveVariableNamesForNode(pLocation), ssa);
                deadPredVariables = Sets.difference(predVariables.keySet(), liveVariabes);
            } else {
                deadPredVariables = Collections.emptySet();
            }
            if (!deadPredVariables.isEmpty() && this.elimDeadVariablePredsByGeneralization) {
                for (String var : deadPredVariables) {
                    elimPredicatesOnDeadVariables.put((Object)predVariables.get(var), (Object)predicate);
                }
                continue;
            }
            if (predVariables.isEmpty() || !Sets.intersection(predVariables.keySet(), variables).isEmpty()) {
                predicateBuilder.add((Object)predicate);
                continue;
            }
            this.logger.log(Level.FINEST, new Object[]{"Ignoring predicate about variables", predVariables.keySet()});
        }
        if (!elimPredicatesOnDeadVariables.isEmpty()) {
            for (Formula deadVar : elimPredicatesOnDeadVariables.keySet()) {
                Collection referencingPreds = elimPredicatesOnDeadVariables.get((Object)deadVar);
                Collection<AbstractionPredicate> predsWithoutVar = this.deriveNewPredsWithoutVar(deadVar, referencingPreds);
                predicateBuilder.addAll(predsWithoutVar);
            }
        }
        return predicateBuilder.build();
    }

    private ImmutableSet<AbstractionPredicate> filterSubsumedPredicates(Collection<AbstractionPredicate> pPredicates, BooleanFormula f, SSAMap ssa, CFANode pLocation) throws SolverException, InterruptedException {
        return null;
    }

    private Collection<AbstractionPredicate> deriveNewPredsWithoutVar(Formula pDeadVar, Collection<AbstractionPredicate> pReferencingPreds) throws SolverException, InterruptedException {
        LinCombineRule linComb = new LinCombineRule(this.solver, this.solver.getSmtAstMatcher());
        DefaultCanonicalizer canon = new DefaultCanonicalizer(this.solver, this.solver.getSmtAstMatcher());
        HashMultimap ruleVarBinding = HashMultimap.create();
        ruleVarBinding.put((Object)"e", (Object)this.fmgr.uninstantiate(pDeadVar));
        Collection conjunctiveInputPredicates = Collections2.transform(pReferencingPreds, this.predicateToFormula);
        ArrayList canonicalized = Lists.newArrayListWithExpectedSize((int)conjunctiveInputPredicates.size());
        for (BooleanFormula f : conjunctiveInputPredicates) {
            canonicalized.add(canon.canonicalize(f));
        }
        Set<BooleanFormula> inferred = linComb.apply(conjunctiveInputPredicates, (Multimap<String, Formula>)ruleVarBinding);
        return Collections2.transform(inferred, this.formulaToPredicate);
    }

    private Region identifyTrivialPredicates(Collection<AbstractionPredicate> pPredicates, AbstractionFormula pOldAbs, PathFormula pBlockFormula) throws SolverException, InterruptedException {
        SSAMap ssa = pBlockFormula.getSsa();
        Set<String> blockVariables = this.fmgr.extractVariableNames(pBlockFormula.getFormula());
        Region oldAbs = pOldAbs.asRegion();
        AbstractionManager.RegionCreator regionCreator = this.amgr.getRegionCreator();
        Region region = regionCreator.makeTrue();
        for (AbstractionPredicate predicate : pPredicates) {
            BooleanFormula predicateTerm = predicate.getSymbolicAtom();
            BooleanFormula instantiatedPredicate = this.fmgr.instantiate(predicateTerm, ssa);
            Set<String> predVariables = this.fmgr.extractVariableNames(instantiatedPredicate);
            if (!Sets.intersection(predVariables, blockVariables).isEmpty()) continue;
            Region predicateVar = predicate.getAbstractVariable();
            if (this.amgr.entails(oldAbs, predicateVar)) {
                region = regionCreator.makeAnd(region, predicateVar);
                ++this.stats.numTrivialPredicates;
                this.logger.log(Level.FINEST, new Object[]{"Predicate", predicate, "is unconditionally true in old abstraction and can be copied to the result."});
                continue;
            }
            Region negatedPredicateVar = regionCreator.makeNot(predicateVar);
            if (this.amgr.entails(oldAbs, negatedPredicateVar)) {
                region = regionCreator.makeAnd(region, negatedPredicateVar);
                ++this.stats.numTrivialPredicates;
                this.logger.log(Level.FINEST, new Object[]{"Negation of predicate", predicate, "is unconditionally true in old abstraction and can be copied to the result."});
                continue;
            }
            this.logger.log(Level.FINEST, new Object[]{"Predicate", predicate, "is relevant because it appears in the old abstraction."});
        }
        assert (this.amgr.entails(oldAbs, region));
        return region;
    }

    public AbstractionFormula buildAbstraction(CFANode location, BooleanFormula f, PathFormula blockFormula, Collection<AbstractionPredicate> predicates) throws SolverException, InterruptedException {
        PathFormula pf = new PathFormula(f, blockFormula.getSsa(), blockFormula.getPointerTargetSet(), 0);
        AbstractionFormula emptyAbstraction = this.makeTrueAbstractionFormula(null);
        AbstractionFormula newAbstraction = this.buildAbstraction(location, emptyAbstraction, pf, predicates);
        return new AbstractionFormula(this.fmgr, newAbstraction.asRegion(), newAbstraction.asFormula(), newAbstraction.asInstantiatedFormula(), blockFormula, noAbstractionReuse);
    }

    public AbstractionFormula buildAbstraction(BooleanFormula f, PathFormula blockFormula) {
        Region r = this.amgr.buildRegionFromFormula(f);
        return this.makeAbstractionFormula(r, blockFormula.getSsa(), blockFormula);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region buildCartesianAbstraction(BooleanFormula f, SSAMap ssa, ProverEnvironment thmProver, Collection<AbstractionPredicate> predicates) throws SolverException, InterruptedException {
        this.stats.abstractionSolveTime.start();
        boolean feasibility = !thmProver.isUnsat();
        this.stats.abstractionSolveTime.stop();
        if (!feasibility) {
            return this.rmgr.makeFalse();
        }
        if (!this.warnedOfCartesianAbstraction && !this.fmgr.isPurelyConjunctive(f)) {
            this.logger.log(Level.WARNING, new Object[]{"Using cartesian abstraction when formulas contain disjunctions may be imprecise. This might lead to failing refinements."});
            this.warnedOfCartesianAbstraction = true;
        }
        this.stats.abstractionEnumTime.startOuter();
        try {
            Region absbdd = this.rmgr.makeTrue();
            for (AbstractionPredicate p : predicates) {
                Pair cacheKey = Pair.of((Object)f, (Object)p);
                if (this.useCache && this.cartesianAbstractionCache.containsKey(cacheKey)) {
                    byte predVal = this.cartesianAbstractionCache.get(cacheKey);
                    ++this.stats.numCartesianAbsPredicatesCached;
                    this.stats.abstractionEnumTime.getCurentInnerTimer().start();
                    Region v = p.getAbstractVariable();
                    if (predVal == -1) {
                        ++this.stats.numCartesianAbsPredicates;
                        v = this.rmgr.makeNot(v);
                        absbdd = this.rmgr.makeAnd(absbdd, v);
                    } else if (predVal == 1) {
                        ++this.stats.numCartesianAbsPredicates;
                        absbdd = this.rmgr.makeAnd(absbdd, v);
                    } else assert (predVal == 0) : "predicate value is neither false, true, nor unknown";
                    this.stats.abstractionEnumTime.getCurentInnerTimer().stop();
                    continue;
                }
                this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "CHECKING VALUE OF PREDICATE: ", p.getSymbolicAtom()});
                BooleanFormula predTrue = this.fmgr.instantiate(p.getSymbolicAtom(), ssa);
                BooleanFormula predFalse = this.bfmgr.not(predTrue);
                int predVal = 0;
                thmProver.push(predFalse);
                boolean isTrue = thmProver.isUnsat();
                thmProver.pop();
                if (isTrue) {
                    ++this.stats.numCartesianAbsPredicates;
                    this.stats.abstractionEnumTime.getCurentInnerTimer().start();
                    Region v = p.getAbstractVariable();
                    absbdd = this.rmgr.makeAnd(absbdd, v);
                    this.stats.abstractionEnumTime.getCurentInnerTimer().stop();
                    predVal = 1;
                } else {
                    thmProver.push(predTrue);
                    boolean isFalse = thmProver.isUnsat();
                    thmProver.pop();
                    if (isFalse) {
                        ++this.stats.numCartesianAbsPredicates;
                        this.stats.abstractionEnumTime.getCurentInnerTimer().start();
                        Region v = p.getAbstractVariable();
                        v = this.rmgr.makeNot(v);
                        absbdd = this.rmgr.makeAnd(absbdd, v);
                        this.stats.abstractionEnumTime.getCurentInnerTimer().stop();
                        predVal = -1;
                    }
                }
                if (!this.useCache) continue;
                this.cartesianAbstractionCache.put((Pair<BooleanFormula, AbstractionPredicate>)cacheKey, (byte)predVal);
            }
            Region region = absbdd;
            return region;
        }
        finally {
            this.stats.abstractionEnumTime.stopOuter();
        }
    }

    private BooleanFormula buildFormula(BooleanFormula symbFormula) {
        BooleanFormula bitwiseAxioms;
        if (this.fmgr.useBitwiseAxioms() && !this.bfmgr.isTrue(bitwiseAxioms = this.fmgr.getBitwiseAxioms(symbFormula))) {
            symbFormula = this.bfmgr.and(symbFormula, bitwiseAxioms);
            this.logger.log(Level.ALL, new Object[]{"DEBUG_3", "ADDED BITWISE AXIOMS:", bitwiseAxioms});
        }
        return symbFormula;
    }

    private Region buildBooleanAbstraction(SSAMap ssa, ProverEnvironment thmProver, Collection<AbstractionPredicate> predicates) throws InterruptedException {
        BooleanFormula predDef = this.bfmgr.makeBoolean(true);
        ArrayList<BooleanFormula> predVars = new ArrayList<BooleanFormula>(predicates.size());
        for (AbstractionPredicate p : predicates) {
            BooleanFormula var = p.getSymbolicVariable();
            BooleanFormula def = p.getSymbolicAtom();
            assert (!this.bfmgr.isFalse(def));
            def = this.fmgr.instantiate(def, ssa);
            BooleanFormula equiv = this.bfmgr.equivalence(var, def);
            predDef = this.bfmgr.and(predDef, equiv);
            predVars.add(var);
        }
        thmProver.push(predDef);
        ProverEnvironment.AllSatResult allSatResult = thmProver.allSat(predVars, this.rmgr, this.stats.abstractionSolveTime, this.stats.abstractionEnumTime);
        int numModels = allSatResult.getCount();
        if (numModels < Integer.MAX_VALUE) {
            this.stats.maxAllSatCount = Math.max(numModels, this.stats.maxAllSatCount);
            this.stats.allSatCount += (long)numModels;
        }
        return allSatResult.getResult();
    }

    public boolean checkCoverage(AbstractionFormula a1, AbstractionFormula a2) throws SolverException, InterruptedException {
        return this.amgr.entails(a1.asRegion(), a2.asRegion());
    }

    public boolean checkCoverage(AbstractionFormula a1, PathFormula p1, AbstractionFormula a2) throws SolverException, InterruptedException {
        BooleanFormula absFormula = a1.asInstantiatedFormula();
        BooleanFormula symbFormula = this.buildFormula(p1.getFormula());
        BooleanFormula a = this.bfmgr.and(absFormula, symbFormula);
        BooleanFormula b = this.fmgr.instantiate(a2.asFormula(), p1.getSsa());
        return this.solver.implies(a, b);
    }

    public boolean unsat(AbstractionFormula abstractionFormula, PathFormula pathFormula) throws SolverException, InterruptedException {
        BooleanFormula absFormula = abstractionFormula.asInstantiatedFormula();
        BooleanFormula symbFormula = this.buildFormula(pathFormula.getFormula());
        BooleanFormula f = this.bfmgr.and(absFormula, symbFormula);
        this.logger.log(Level.ALL, new Object[]{"Checking satisfiability of formula", f});
        return this.solver.isUnsat(f);
    }

    public AbstractionFormula makeTrueAbstractionFormula(PathFormula pPreviousBlockFormula) {
        if (pPreviousBlockFormula == null) {
            pPreviousBlockFormula = this.pfmgr.makeEmptyPathFormula();
        }
        return new AbstractionFormula(this.fmgr, this.amgr.getRegionCreator().makeTrue(), this.bfmgr.makeBoolean(true), this.bfmgr.makeBoolean(true), pPreviousBlockFormula, noAbstractionReuse);
    }

    public AbstractionFormula makeAnd(AbstractionFormula a1, AbstractionFormula a2) {
        Preconditions.checkArgument((boolean)a1.getBlockFormula().equals(a2.getBlockFormula()));
        Region region = this.amgr.getRegionCreator().makeAnd(a1.asRegion(), a2.asRegion());
        BooleanFormula formula = this.fmgr.makeAnd(a1.asFormula(), a2.asFormula());
        BooleanFormula instantiatedFormula = this.fmgr.makeAnd(a1.asInstantiatedFormula(), a2.asInstantiatedFormula());
        return new AbstractionFormula(this.fmgr, region, formula, instantiatedFormula, a1.getBlockFormula(), noAbstractionReuse);
    }

    private AbstractionFormula makeAbstractionFormula(Region abs, SSAMap ssaMap, PathFormula blockFormula) {
        BooleanFormula symbolicAbs = this.amgr.toConcrete(abs);
        BooleanFormula instantiatedSymbolicAbs = this.fmgr.instantiate(symbolicAbs, ssaMap);
        if (this.simplifyAbstractionFormula) {
            symbolicAbs = this.fmgr.simplify(symbolicAbs);
            instantiatedSymbolicAbs = this.fmgr.simplify(instantiatedSymbolicAbs);
        }
        return new AbstractionFormula(this.fmgr, abs, symbolicAbs, instantiatedSymbolicAbs, blockFormula, noAbstractionReuse);
    }

    public AbstractionFormula reduce(AbstractionFormula oldAbstraction, Collection<AbstractionPredicate> removePredicates, SSAMap ssaMap) {
        AbstractionManager.RegionCreator rmgr = this.amgr.getRegionCreator();
        Region newRegion = oldAbstraction.asRegion();
        for (AbstractionPredicate predicate : removePredicates) {
            newRegion = rmgr.makeExists(newRegion, predicate.getAbstractVariable());
        }
        return this.makeAbstractionFormula(newRegion, ssaMap, oldAbstraction.getBlockFormula());
    }

    public AbstractionFormula expand(AbstractionFormula reducedAbstraction, AbstractionFormula sourceAbstraction, Collection<AbstractionPredicate> relevantPredicates, SSAMap newSSA) {
        return this.expand(reducedAbstraction.asRegion(), sourceAbstraction.asRegion(), relevantPredicates, newSSA, reducedAbstraction.getBlockFormula());
    }

    public AbstractionFormula expand(Region reducedAbstraction, Region sourceAbstraction, Collection<AbstractionPredicate> relevantPredicates, SSAMap newSSA, PathFormula blockFormula) {
        AbstractionManager.RegionCreator rmgr = this.amgr.getRegionCreator();
        for (AbstractionPredicate predicate : relevantPredicates) {
            sourceAbstraction = rmgr.makeExists(sourceAbstraction, predicate.getAbstractVariable());
        }
        Region expandedRegion = rmgr.makeAnd(reducedAbstraction, sourceAbstraction);
        return this.makeAbstractionFormula(expandedRegion, newSSA, blockFormula);
    }

    public Collection<AbstractionPredicate> extractPredicates(BooleanFormula pFormula) {
        if (this.bfmgr.isFalse(pFormula)) {
            return ImmutableList.of((Object)this.amgr.makeFalsePredicate());
        }
        Collection<BooleanFormula> atoms = this.fmgr.extractAtoms(pFormula, this.splitItpAtoms, false);
        ArrayList<AbstractionPredicate> preds = new ArrayList<AbstractionPredicate>(atoms.size());
        for (BooleanFormula atom : atoms) {
            preds.add(this.amgr.makePredicate(atom));
        }
        return preds;
    }

    public AbstractionPredicate createPredicateFor(BooleanFormula pFormula) {
        Preconditions.checkArgument((!this.bfmgr.isTrue(pFormula) ? 1 : 0) != 0);
        return this.amgr.makePredicate(pFormula);
    }

    public Set<AbstractionPredicate> extractPredicates(Region pRegion) {
        return this.amgr.extractPredicates(pRegion);
    }

    public Region buildRegionFromFormula(BooleanFormula pF) {
        return this.amgr.buildRegionFromFormula(pF);
    }

    private Set<PredicateAbstractionsStorage.AbstractionNode> getSuccessorsInAbstractionTree(int pIdOfLastAbstractionReused) {
        Preconditions.checkNotNull((Object)this.reuseAbstractionsFrom);
        return this.abstractionStorage.getSuccessorAbstractions(pIdOfLastAbstractionReused);
    }

    private static enum AbstractionType {
        CARTESIAN,
        BOOLEAN,
        COMBINED,
        ELIMINATION;

    }

    static class Stats {
        public int numCallsAbstraction = 0;
        public int numAbstractionReuses = 0;
        public int numSymbolicAbstractions = 0;
        public int numSatCheckAbstractions = 0;
        public int numCallsAbstractionCached = 0;
        public int numTotalPredicates = 0;
        public int maxPredicates = 0;
        public int numIrrelevantPredicates = 0;
        public int numTrivialPredicates = 0;
        public int numCartesianAbsPredicates = 0;
        public int numCartesianAbsPredicatesCached = 0;
        public int numBooleanAbsPredicates = 0;
        public final Timer abstractionReuseTime = new Timer();
        public final StatTimer abstractionReuseImplicationTime = new StatTimer("Time for checking reusability of abstractions");
        public final Timer trivialPredicatesTime = new Timer();
        public final Timer cartesianAbstractionTime = new Timer();
        public final Timer quantifierEliminationTime = new Timer();
        public final Timer booleanAbstractionTime = new Timer();
        public final NestedTimer abstractionEnumTime = new NestedTimer();
        public final Timer abstractionSolveTime = new Timer();
        public long allSatCount = 0L;
        public int maxAllSatCount = 0;

        Stats() {
        }
    }
}

