/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStaticRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateMapWriter;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.FormulaMeasuring;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.predicate")
public class PredicateAbstractionRefinementStrategy
extends RefinementStrategy {
    @Option(secure=true, name="refinement.atomicPredicates", description="use only the atoms from the interpolants as predicates, and not the whole interpolant")
    private boolean atomicPredicates = true;
    @Option(secure=true, name="precision.sharing", description="Where to apply the found predicates to?")
    private PredicateSharing predicateSharing = PredicateSharing.LOCATION;
    @Option(secure=true, name="refinement.keepAllPredicates", description="During refinement, keep predicates from all removed parts of the ARG. Otherwise, only predicates from the error path are kept.")
    private boolean keepAllPredicates = false;
    @Option(secure=true, name="refinement.restartAfterRefinements", description="Do a complete restart (clearing the reached set) after N refinements. 0 to disable, 1 for always.")
    @IntegerOption(min=0L)
    private int restartAfterRefinements = 0;
    @Option(secure=true, name="refinement.sharePredicates", description="During refinement, add all new predicates to the precisions of all abstract states in the reached set.")
    private boolean sharePredicates = false;
    @Option(secure=true, name="refinement.useBddInterpolantSimplification", description="Use BDDs to simplify interpolants (removing irrelevant predicates)")
    private boolean useBddInterpolantSimplification = false;
    @Option(secure=true, name="refinement.dumpPredicates", description="After each refinement, dump the newly found predicates.")
    private boolean dumpPredicates = false;
    @Option(secure=true, name="refinement.dumpPredicatesFile", description="File name for the predicates dumped after refinements.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dumpPredicatesFile = PathTemplate.ofFormatString((String)"refinement%04d-predicates.prec");
    private int refinementCount = 0;
    private int heuristicsCount = 0;
    private boolean lastRefinementUsedHeuristics = false;
    protected final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PredicateAbstractionManager predAbsMgr;
    private final PredicateStaticRefiner staticRefiner;
    private final FormulaMeasuring formulaMeasuring;
    private final PredicateMapWriter precisionWriter;
    private StatCounter numberOfRefinementsWithStrategy2 = new StatCounter("Number of refs with location-based cutoff");
    private StatInt irrelevantPredsInItp = new StatInt(StatKind.SUM, "Number of irrelevant preds in interpolants");
    private StatTimer predicateCreation = new StatTimer(StatKind.SUM, "Predicate creation");
    private StatTimer precisionUpdate = new StatTimer(StatKind.SUM, "Precision update");
    private StatTimer argUpdate = new StatTimer(StatKind.SUM, "ARG update");
    private StatTimer itpSimplification = new StatTimer(StatKind.SUM, "Itp simplification with BDDs");
    private StatInt simplifyDeltaConjunctions = new StatInt(StatKind.SUM, "Conjunctions Delta");
    private StatInt simplifyDeltaDisjunctions = new StatInt(StatKind.SUM, "Disjunctions Delta");
    private StatInt simplifyDeltaNegations = new StatInt(StatKind.SUM, "Negations Delta");
    private StatInt simplifyDeltaAtoms = new StatInt(StatKind.SUM, "Atoms Delta");
    private StatInt simplifyDeltaVariables = new StatInt(StatKind.SUM, "Variables Delta");
    private StatInt simplifyVariablesBefore = new StatInt(StatKind.SUM, "Variables Before");
    private StatInt simplifyVariablesAfter = new StatInt(StatKind.SUM, "Variables After");
    private ListMultimap<Pair<CFANode, Integer>, AbstractionPredicate> newPredicates;

    public PredicateAbstractionRefinementStrategy(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, PredicateAbstractionManager pPredAbsMgr, PredicateStaticRefiner pStaticRefiner, Solver pSolver) throws CPAException, InvalidConfigurationException {
        super(pSolver);
        config.inject((Object)this, PredicateAbstractionRefinementStrategy.class);
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.fmgr = pSolver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.predAbsMgr = pPredAbsMgr;
        this.staticRefiner = pStaticRefiner;
        this.formulaMeasuring = new FormulaMeasuring(this.fmgr);
        this.precisionWriter = this.dumpPredicates && this.dumpPredicatesFile != null ? new PredicateMapWriter(config, this.fmgr) : null;
    }

    @Override
    public boolean needsInterpolants() {
        return !this.useStaticRefinement();
    }

    private boolean useStaticRefinement() {
        return this.staticRefiner != null && this.heuristicsCount == 0;
    }

    @Override
    public void performRefinement(ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, List<BooleanFormula> pInterpolants, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        boolean bl = pRepeatedCounterexample = !this.lastRefinementUsedHeuristics && pRepeatedCounterexample;
        if (this.useStaticRefinement()) {
            PredicatePrecision heuristicPrecision;
            UnmodifiableReachedSet reached = pReached.asReachedSet();
            ARGState root = (ARGState)reached.getFirstState();
            ARGState refinementRoot = (ARGState)Iterables.getLast(root.getChildren());
            try {
                heuristicPrecision = this.staticRefiner.extractPrecisionFromCfa(pReached.asReachedSet(), abstractionStatesTrace, this.atomicPredicates);
            }
            catch (CPATransferException | SolverException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Static refinement failed");
                this.lastRefinementUsedHeuristics = false;
                super.performRefinement(pReached, abstractionStatesTrace, pInterpolants, pRepeatedCounterexample);
                return;
            }
            this.shutdownNotifier.shutdownIfNecessary();
            pReached.removeSubtree(refinementRoot, heuristicPrecision, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
            ++this.heuristicsCount;
            this.lastRefinementUsedHeuristics = true;
        } else {
            this.lastRefinementUsedHeuristics = false;
            super.performRefinement(pReached, abstractionStatesTrace, pInterpolants, pRepeatedCounterexample);
        }
    }

    @Override
    public void startRefinementOfPath() {
        Preconditions.checkState((this.newPredicates == null ? 1 : 0) != 0);
        this.newPredicates = Multimaps.newListMultimap(new LinkedHashMap(), (Supplier)new Supplier<List<AbstractionPredicate>>(){

            public List<AbstractionPredicate> get() {
                return new ArrayList<AbstractionPredicate>();
            }
        });
    }

    @Override
    public boolean performRefinementForState(BooleanFormula pInterpolant, ARGState interpolationPoint) {
        Preconditions.checkState((this.newPredicates != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.bfmgr.isTrue(pInterpolant) ? 1 : 0) != 0);
        this.predicateCreation.start();
        PredicateAbstractState predicateState = PredicateAbstractState.getPredicateState(interpolationPoint);
        PathFormula blockFormula = predicateState.getAbstractionFormula().getBlockFormula();
        Collection<AbstractionPredicate> localPreds = this.convertInterpolant(pInterpolant, blockFormula);
        CFANode loc = AbstractStates.extractLocation(interpolationPoint);
        int locInstance = (Integer)predicateState.getAbstractionLocationsOnPath().get((Object)loc);
        this.newPredicates.putAll((Object)Pair.of((Object)loc, (Object)locInstance), localPreds);
        this.predicateCreation.stop();
        return false;
    }

    protected final Collection<AbstractionPredicate> convertInterpolant(BooleanFormula pInterpolant, PathFormula blockFormula) {
        ImmutableList preds;
        BooleanFormula interpolant = pInterpolant;
        if (this.bfmgr.isTrue(interpolant)) {
            return Collections.emptySet();
        }
        int allPredsCount = 0;
        if (this.useBddInterpolantSimplification) {
            FormulaMeasuring.FormulaMeasures itpBeforeSimple = this.formulaMeasuring.measure(interpolant);
            this.itpSimplification.start();
            allPredsCount = this.predAbsMgr.extractPredicates(interpolant).size();
            interpolant = this.predAbsMgr.buildAbstraction(this.fmgr.uninstantiate(interpolant), blockFormula).asInstantiatedFormula();
            this.itpSimplification.stop();
            FormulaMeasuring.FormulaMeasures itpAfterSimple = this.formulaMeasuring.measure(interpolant);
            this.simplifyDeltaAtoms.setNextValue(itpAfterSimple.getAtoms() - itpBeforeSimple.getAtoms());
            this.simplifyDeltaDisjunctions.setNextValue(itpAfterSimple.getDisjunctions() - itpBeforeSimple.getDisjunctions());
            this.simplifyDeltaConjunctions.setNextValue(itpAfterSimple.getConjunctions() - itpBeforeSimple.getConjunctions());
            this.simplifyDeltaNegations.setNextValue(itpAfterSimple.getNegations() - itpBeforeSimple.getNegations());
            this.simplifyDeltaVariables.setNextValue(itpAfterSimple.getVariables().size() - itpBeforeSimple.getVariables().size());
            this.simplifyVariablesBefore.setNextValue(itpBeforeSimple.getVariables().size());
            this.simplifyVariablesAfter.setNextValue(itpAfterSimple.getVariables().size());
        }
        if (this.atomicPredicates) {
            preds = this.predAbsMgr.extractPredicates(interpolant);
            if (this.useBddInterpolantSimplification) {
                this.irrelevantPredsInItp.setNextValue(allPredsCount - preds.size());
            }
        } else {
            preds = ImmutableList.of((Object)this.predAbsMgr.createPredicateFor(this.fmgr.uninstantiate(interpolant)));
        }
        assert (!preds.isEmpty()) : "Interpolant without relevant predicates: " + pInterpolant + "; simplified to " + interpolant;
        this.logger.log(Level.FINEST, new Object[]{"Got predicates", preds});
        return preds;
    }

    @Override
    public void finishRefinementOfPath(ARGState pUnreachableState, List<ARGState> pAffectedStates, ARGReachedSet pReached, boolean pRepeatedCounterexample) throws CPAException {
        PredicatePrecision newPrecision;
        CFANode loc = AbstractStates.extractLocation(pUnreachableState);
        int locInstance = (Integer)PredicateAbstractState.getPredicateState(pUnreachableState).getAbstractionLocationsOnPath().get((Object)loc);
        this.newPredicates.put((Object)Pair.of((Object)loc, (Object)locInstance), (Object)this.predAbsMgr.createPredicateFor(this.bfmgr.makeBoolean(false)));
        pAffectedStates.add(pUnreachableState);
        UnmodifiableReachedSet reached = pReached.asReachedSet();
        PredicatePrecision targetStatePrecision = this.extractPredicatePrecision(reached.getPrecision(reached.getLastState()));
        ARGState refinementRoot = this.getRefinementRoot(pAffectedStates, targetStatePrecision, pRepeatedCounterexample);
        this.logger.log(Level.FINEST, new Object[]{"Removing everything below", refinementRoot, "from ARG."});
        ++this.refinementCount;
        if (this.restartAfterRefinements > 0 && this.refinementCount >= this.restartAfterRefinements) {
            ARGState root = (ARGState)reached.getFirstState();
            assert (root.getChildren().size() == 1) : "ARG root should have exactly one child";
            refinementRoot = (ARGState)Iterables.getLast(root.getChildren());
            this.logger.log(Level.FINEST, new Object[]{"Restarting analysis after", this.refinementCount, "refinements by clearing the ARG."});
            this.refinementCount = 0;
        }
        this.precisionUpdate.start();
        PredicatePrecision basePrecision = this.keepAllPredicates ? this.findAllPredicatesFromSubgraph(refinementRoot, reached) : targetStatePrecision;
        this.logger.log(Level.ALL, new Object[]{"Old predicate map is", basePrecision});
        this.logger.log(Level.ALL, new Object[]{"New predicates are", this.newPredicates});
        switch (this.predicateSharing) {
            case GLOBAL: {
                newPrecision = basePrecision.addGlobalPredicates(this.newPredicates.values());
                break;
            }
            case FUNCTION: {
                newPrecision = basePrecision.addFunctionPredicates((Multimap<String, AbstractionPredicate>)PredicatePrecision.mergePredicatesPerFunction(this.newPredicates));
                break;
            }
            case LOCATION: {
                newPrecision = basePrecision.addLocalPredicates((Multimap<CFANode, AbstractionPredicate>)PredicatePrecision.mergePredicatesPerLocation(this.newPredicates));
                break;
            }
            case LOCATION_INSTANCE: {
                newPrecision = basePrecision.addLocationInstancePredicates((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)this.newPredicates);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.logger.log(Level.ALL, new Object[]{"Predicate map now is", newPrecision});
        assert (basePrecision.calculateDifferenceTo(newPrecision) == 0) : "We forgot predicates during refinement!";
        assert (targetStatePrecision.calculateDifferenceTo(newPrecision) == 0) : "We forgot predicates during refinement!";
        if (this.dumpPredicates && this.dumpPredicatesFile != null) {
            Path precFile = this.dumpPredicatesFile.getPath(new Object[]{this.precisionUpdate.getUpdateCount()});
            try (Writer w = Files.openOutputFile((Path)precFile, (FileWriteMode[])new FileWriteMode[0]);){
                this.precisionWriter.writePredicateMap((SetMultimap<Pair<CFANode, Integer>, AbstractionPredicate>)ImmutableSetMultimap.copyOf(this.newPredicates), (SetMultimap<CFANode, AbstractionPredicate>)ImmutableSetMultimap.of(), (SetMultimap<String, AbstractionPredicate>)ImmutableSetMultimap.of(), (Set<AbstractionPredicate>)ImmutableSet.of(), this.newPredicates.values(), w);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not dump precision to file");
            }
        }
        this.precisionUpdate.stop();
        this.argUpdate.start();
        ArrayList<Precision> precisions = new ArrayList<Precision>(2);
        ArrayList<Predicate<? super Precision>> precisionTypes = new ArrayList<Predicate<? super Precision>>(2);
        precisions.add(newPrecision);
        precisionTypes.add(Predicates.instanceOf(PredicatePrecision.class));
        if (this.isValuePrecisionAvailable(pReached, refinementRoot)) {
            precisions.add(this.mergeAllValuePrecisionsFromSubgraph(refinementRoot, reached));
            precisionTypes.add(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
        }
        pReached.removeSubtree(refinementRoot, precisions, precisionTypes);
        assert (this.refinementCount > 0 || reached.size() == 1);
        if (this.sharePredicates) {
            pReached.updatePrecisionGlobally(newPrecision, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
        }
        this.argUpdate.stop();
        this.newPredicates = null;
    }

    protected final PredicatePrecision extractPredicatePrecision(Precision oldPrecision) throws IllegalStateException {
        PredicatePrecision oldPredicatePrecision = Precisions.extractPrecisionByType(oldPrecision, PredicatePrecision.class);
        if (oldPredicatePrecision == null) {
            throw new IllegalStateException("Could not find the PredicatePrecision for the error element");
        }
        return oldPredicatePrecision;
    }

    private ARGState getRefinementRoot(List<ARGState> pAffectedStates, PredicatePrecision targetStatePrecision, boolean pRepeatedCounterexample) throws RefinementFailedException {
        boolean newPredicatesFound = !targetStatePrecision.getLocalPredicates().entries().containsAll(this.newPredicates.entries());
        ARGState firstInterpolationPoint = pAffectedStates.get(0);
        if (!newPredicatesFound) {
            if (pRepeatedCounterexample) {
                throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, null);
            }
            this.numberOfRefinementsWithStrategy2.inc();
            CFANode firstInterpolationPointLocation = AbstractStates.extractLocation(firstInterpolationPoint);
            this.logger.log(Level.FINEST, new Object[]{"Found spurious counterexample,", "trying strategy 2: remove everything below node", firstInterpolationPointLocation, "from ARG."});
            ARGState current = firstInterpolationPoint;
            while (!current.getParents().isEmpty()) {
                CFANode loc;
                if (!PredicateAbstractState.getPredicateState(current = (ARGState)Iterables.get(current.getParents(), (int)0)).isAbstractionState() || !(loc = AbstractStates.extractLocation(current)).equals(firstInterpolationPointLocation)) continue;
                firstInterpolationPoint = current;
            }
        }
        return firstInterpolationPoint;
    }

    private PredicatePrecision findAllPredicatesFromSubgraph(ARGState refinementRoot, UnmodifiableReachedSet reached) {
        PredicatePrecision newPrecision = PredicatePrecision.empty();
        Set precisions = Sets.newIdentityHashSet();
        for (ARGState state : refinementRoot.getSubgraph()) {
            if (state.isCovered()) continue;
            precisions.add(reached.getPrecision(state));
        }
        for (Precision prec : precisions) {
            newPrecision = newPrecision.mergeWith(this.extractPredicatePrecision(prec));
        }
        return newPrecision;
    }

    private boolean isValuePrecisionAvailable(ARGReachedSet pReached, ARGState root) {
        if (!pReached.asReachedSet().contains(root)) {
            return false;
        }
        return Precisions.extractPrecisionByType(pReached.asReachedSet().getPrecision(root), VariableTrackingPrecision.class) != null;
    }

    private VariableTrackingPrecision mergeAllValuePrecisionsFromSubgraph(ARGState refinementRoot, UnmodifiableReachedSet reached) {
        VariableTrackingPrecision rootPrecision = Precisions.extractPrecisionByType(reached.getPrecision(refinementRoot), VariableTrackingPrecision.class);
        Set precisions = Sets.newIdentityHashSet();
        for (ARGState state : refinementRoot.getSubgraph()) {
            if (state.isCovered()) continue;
            precisions.add(reached.getPrecision(state));
        }
        for (Precision prec : precisions) {
            rootPrecision = rootPrecision.join(Precisions.extractPrecisionByType(prec, VariableTrackingPrecision.class));
        }
        return rootPrecision;
    }

    @Override
    public Statistics getStatistics() {
        return new Stats();
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public String getName() {
            return "Predicate-Abstraction Refiner";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            StatisticsWriter w0 = StatisticsWriter.writingStatisticsTo(out);
            StatisticsWriter w1 = w0.beginLevel();
            w1.put(PredicateAbstractionRefinementStrategy.this.predicateCreation).ifUpdatedAtLeastOnce(PredicateAbstractionRefinementStrategy.this.itpSimplification).put(PredicateAbstractionRefinementStrategy.this.itpSimplification).beginLevel().put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaConjunctions).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaDisjunctions).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaNegations).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaAtoms).put(PredicateAbstractionRefinementStrategy.this.simplifyDeltaVariables).put(PredicateAbstractionRefinementStrategy.this.simplifyVariablesBefore).put(PredicateAbstractionRefinementStrategy.this.simplifyVariablesAfter);
            w1.put(PredicateAbstractionRefinementStrategy.this.precisionUpdate).put(PredicateAbstractionRefinementStrategy.this.argUpdate).spacer();
            PredicateAbstractionRefinementStrategy.this.basicRefinementStatistics.printStatistics(out, pResult, pReached);
            w0.put(PredicateAbstractionRefinementStrategy.this.numberOfRefinementsWithStrategy2).ifUpdatedAtLeastOnce(PredicateAbstractionRefinementStrategy.this.itpSimplification).put(PredicateAbstractionRefinementStrategy.this.irrelevantPredsInItp);
        }
    }

    private static enum PredicateSharing {
        GLOBAL,
        FUNCTION,
        LOCATION,
        LOCATION_INSTANCE;

    }
}

