/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class PredicateAssumeStore
implements Statistics {
    private final Map<CFANode, BooleanFormula> locationAssumes = Maps.newHashMap();
    private final FormulaManagerView fmv;

    public PredicateAssumeStore(FormulaManagerView pFmv) {
        Preconditions.checkNotNull((Object)pFmv);
        this.fmv = pFmv;
    }

    public synchronized Optional<BooleanFormula> getAssumeOnLocation(CFANode pLocation) {
        BooleanFormula result = this.locationAssumes.get(pLocation);
        if (result == null) {
            return Optional.absent();
        }
        return Optional.of((Object)result);
    }

    public synchronized BooleanFormula conjunctAssumeToLocation(CFANode pLocation, BooleanFormula pAssume) {
        BooleanFormula result = this.locationAssumes.get(pLocation);
        if (result == null) {
            result = this.fmv.getBooleanFormulaManager().makeBoolean(true);
        }
        result = this.fmv.simplify(this.fmv.makeAnd(result, pAssume));
        this.locationAssumes.put(pLocation, result);
        return result;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

