/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.PrefixProvider;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class PredicateBasedPrefixProvider
implements PrefixProvider {
    private final LogManager logger;
    private final Solver solver;
    private final PathFormulaManager pathFormulaManager;
    private final FormulaManagerView formulaManager;

    public PredicateBasedPrefixProvider(LogManager pLogger, Solver pSolver, PathFormulaManager pPathFormulaManager) {
        this.logger = pLogger;
        this.solver = pSolver;
        this.pathFormulaManager = pPathFormulaManager;
        this.formulaManager = this.solver.getFormulaManager();
    }

    @Override
    public List<ARGPath> getInfeasilbePrefixes(ARGPath path) throws CPAException, InterruptedException {
        ArrayList<ARGPath> prefixes = new ArrayList<ARGPath>();
        try {
            MutableARGPath currentPrefix = new MutableARGPath();
            PathFormula satFormula = this.pathFormulaManager.makeEmptyPathFormula();
            ARGPath.PathIterator iterator = path.pathIterator();
            while (iterator.hasNext()) {
                PathFormula formula = this.pathFormulaManager.makeAnd(satFormula, iterator.getOutgoingEdge());
                currentPrefix.addLast(Pair.of((Object)iterator.getAbstractState(), (Object)iterator.getOutgoingEdge()));
                if (this.solver.isUnsat(formula.getFormula())) {
                    this.logger.log(Level.FINE, new Object[]{"found infeasible prefix: ", iterator.getOutgoingEdge(), " resulted in an unsat-formula"});
                    prefixes.add(currentPrefix.immutableCopy());
                    currentPrefix = new MutableARGPath();
                    satFormula = this.pathFormulaManager.makeAnd(satFormula, this.formulaManager.getBooleanFormulaManager().makeBoolean(true));
                } else {
                    satFormula = this.pathFormulaManager.makeAnd(satFormula, iterator.getOutgoingEdge());
                }
                iterator.advance();
            }
            if (prefixes.isEmpty()) {
                prefixes.add(path);
            }
            return prefixes;
        }
        catch (SolverException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Error during computation of prefixes, continuing with original error path");
            return Lists.newArrayList((Object[])new ARGPath[]{path});
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of path formula for prefix failed: " + e.getMessage(), e);
        }
    }
}

