/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.CPAInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.DoNothingInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractDomain;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAssumeStore;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPAStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateMergeOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePCCStopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionBootstrapper;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStaticRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.blocking.BlockedCFAReducer;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;

@Options(prefix="cpa.predicate")
public class PredicateCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
ProofChecker,
AutoCloseable {
    @Option(secure=true, name="abstraction.type", toUppercase=true, values={"BDD", "SYLVAN", "FORMULA"}, description="What to use for storing abstractions")
    private String abstractionType = "BDD";
    @Option(secure=true, name="blk.useCache", description="use caching of path formulas")
    private boolean useCache = true;
    @Option(secure=true, name="enableBlockreducer", description="Enable the possibility to precompute explicit abstraction locations.")
    private boolean enableBlockreducer = false;
    @Option(secure=true, name="merge", values={"SEP", "ABE"}, toUppercase=true, description="which merge operator to use for predicate cpa (usually ABE should be used)")
    private String mergeType = "ABE";
    @Option(secure=true, name="stop", values={"SEP", "SEPPCC"}, toUppercase=true, description="which stop operator to use for predicate cpa (usually SEP should be used in analysis)")
    private String stopType = "SEP";
    @Option(secure=true, name="refinement.performInitialStaticRefinement", description="use heuristic to extract predicates from the CFA statically on first refinement")
    private boolean performInitialStaticRefinement = false;
    @Option(secure=true, description="Generate invariants and strengthen the formulas during abstraction with them.")
    private boolean useInvariantsForAbstraction = false;
    @Option(secure=true, description="Direction of the analysis?")
    private AnalysisDirection direction = AnalysisDirection.FORWARD;
    protected final Configuration config;
    protected final LogManager logger;
    protected final ShutdownNotifier shutdownNotifier;
    private final PredicateAbstractDomain domain;
    private final PredicateTransferRelation transfer;
    private final MergeOperator merge;
    private final PredicatePrecisionAdjustment prec;
    private final StopOperator stop;
    private final PredicatePrecision initialPrecision;
    private final PathFormulaManager pathFormulaManager;
    private final Solver solver;
    private final PredicateAbstractionManager predicateManager;
    private final PredicateCPAStatistics stats;
    private final PredicateAbstractState topState;
    private final PredicatePrecisionBootstrapper precisionBootstraper;
    private final PredicateStaticRefiner staticRefiner;
    private final CFA cfa;
    private final PredicateAssumeStore assumesStore;
    private final AbstractionManager abstractionManager;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(PredicateCPA.class).withOptions(BlockOperator.class);
    }

    protected PredicateCPA(Configuration config, LogManager logger, BlockOperator blk, CFA pCfa, ReachedSetFactory reachedSetFactory, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, CPAException {
        RegionManager regionManager;
        config.inject((Object)this, PredicateCPA.class);
        this.config = config;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        if (this.enableBlockreducer) {
            BlockedCFAReducer blockComputer = new BlockedCFAReducer(config, logger);
            blk.setExplicitAbstractionNodes(blockComputer.computeAbstractionNodes(this.cfa));
        }
        blk.setCFA(this.cfa);
        this.solver = Solver.create(config, logger, pShutdownNotifier);
        FormulaManagerView formulaManager = this.solver.getFormulaManager();
        String libraries = formulaManager.getVersion();
        PathFormulaManager pfMgr = new PathFormulaManagerImpl(formulaManager, config, logger, this.shutdownNotifier, this.cfa, this.direction);
        if (this.useCache) {
            pfMgr = new CachingPathFormulaManager(pfMgr);
        }
        this.pathFormulaManager = pfMgr;
        if (this.abstractionType.equals("FORMULA")) {
            regionManager = new SymbolicRegionManager(formulaManager, this.solver);
        } else {
            assert (this.abstractionType.equals("BDD"));
            regionManager = new BDDManagerFactory(config, logger).createRegionManager();
            libraries = libraries + " and " + regionManager.getVersion();
        }
        logger.log(Level.INFO, new Object[]{"Using predicate analysis with", libraries + "."});
        this.abstractionManager = new AbstractionManager(regionManager, formulaManager, config, logger);
        this.assumesStore = new PredicateAssumeStore(formulaManager);
        this.predicateManager = new PredicateAbstractionManager(this.abstractionManager, formulaManager, this.pathFormulaManager, this.solver, config, logger, this.cfa.getLiveVariables());
        this.transfer = new PredicateTransferRelation(this, blk, config, this.direction);
        this.topState = PredicateAbstractState.mkAbstractionState(formulaManager.getBooleanFormulaManager(), this.pathFormulaManager.makeEmptyPathFormula(), this.predicateManager.makeTrueAbstractionFormula(null), (PersistentMap<CFANode, Integer>)PathCopyingPersistentTreeMap.of());
        this.domain = new PredicateAbstractDomain(this, config);
        if (this.mergeType.equals("SEP")) {
            this.merge = MergeSepOperator.getInstance();
        } else if (this.mergeType.equals("ABE")) {
            this.merge = new PredicateMergeOperator(this);
        } else {
            throw new InternalError("Update list of allowed merge operators");
        }
        InvariantGenerator invariantGenerator = this.useInvariantsForAbstraction ? new CPAInvariantGenerator(config, logger, reachedSetFactory, pShutdownNotifier, this.cfa) : new DoNothingInvariantGenerator(reachedSetFactory);
        this.staticRefiner = this.performInitialStaticRefinement ? new PredicateStaticRefiner(config, logger, this.solver, this.pathFormulaManager, formulaManager, this.predicateManager, this.cfa) : null;
        this.precisionBootstraper = new PredicatePrecisionBootstrapper(config, logger, this.cfa, this.pathFormulaManager, this.abstractionManager, formulaManager);
        this.initialPrecision = this.precisionBootstraper.prepareInitialPredicates();
        logger.log(Level.FINEST, new Object[]{"Initial precision is", this.initialPrecision});
        this.stats = new PredicateCPAStatistics(this, blk, regionManager, this.abstractionManager, this.cfa, invariantGenerator.getTimeOfExecution(), config);
        GlobalInfo.getInstance().storeFormulaManager(formulaManager);
        GlobalInfo.getInstance().storeAbstractionManager(this.abstractionManager);
        this.prec = new PredicatePrecisionAdjustment(this, invariantGenerator);
        if (this.stopType.equals("SEP")) {
            this.stop = new PredicateStopOperator(this.domain);
        } else if (this.stopType.equals("SEPPCC")) {
            this.stop = new PredicatePCCStopOperator(this);
        } else {
            throw new InternalError("Update list of allowed stop operators");
        }
    }

    public PredicateAssumeStore getAssumesStore() {
        return this.assumesStore;
    }

    @Override
    public PredicateAbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public PredicateTransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    public PredicateAbstractionManager getPredicateManager() {
        return this.predicateManager;
    }

    public PathFormulaManager getPathFormulaManager() {
        return this.pathFormulaManager;
    }

    public Solver getSolver() {
        return this.solver;
    }

    Configuration getConfiguration() {
        return this.config;
    }

    LogManager getLogger() {
        return this.logger;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    @Nullable
    public PredicateStaticRefiner getStaticRefiner() {
        return this.staticRefiner;
    }

    @Override
    public PredicateAbstractState getInitialState(CFANode node, StateSpacePartition pPartition) {
        this.prec.setInitialLocation(node);
        return this.topState;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.initialPrecision;
    }

    @Override
    public PredicatePrecisionAdjustment getPrecisionAdjustment() {
        return this.prec;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        this.precisionBootstraper.collectStatistics(pStatsCollection);
    }

    @Override
    public void close() throws Exception {
        this.solver.close();
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        try {
            return this.getTransferRelation().areAbstractSuccessors(pElement, pCfaEdge, pSuccessors);
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver failed during abstract-successor check", e);
        }
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        PredicateAbstractState e1 = (PredicateAbstractState)pElement;
        PredicateAbstractState e2 = (PredicateAbstractState)pOtherElement;
        if (e1.isAbstractionState() && e2.isAbstractionState()) {
            return this.predicateManager.checkCoverage(e1.getAbstractionFormula(), this.pathFormulaManager.makeEmptyPathFormula(e1.getPathFormula()), e2.getAbstractionFormula());
        }
        return false;
    }

    public CFA getCfa() {
        return this.cfa;
    }

    public MachineModel getMachineModel() {
        return this.cfa.getMachineModel();
    }

    public AbstractionManager getAbstractionManager() {
        return this.abstractionManager;
    }
}

