/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaSlicer;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAssumeStore;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateBasedPrefixProvider;
import org.sosy_lab.cpachecker.cpa.predicate.RefinementStrategy;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ErrorPathClassifier;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.PrefixProvider;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.predicate.refinement")
public class PredicateCPARefiner
extends AbstractARGBasedRefiner
implements StatisticsProvider {
    @Option(secure=true, description="slice block formulas, experimental feature!")
    private boolean sliceBlockFormulas = false;
    @Option(secure=true, description="Conjunct the formulas that were computed as preconditions to get (infeasible) interpolation problems!")
    private boolean conjunctPreconditionFormulas = false;
    @Option(secure=true, description="where to dump the counterexample formula in case the error location is reached")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dumpCounterexampleFile = PathTemplate.ofFormatString((String)"ErrorPath.%d.smt2");
    @Option(secure=true, description="prefixPreference")
    private ErrorPathClassifier.ErrorPathPrefixPreference prefixPreference = ErrorPathClassifier.ErrorPathPrefixPreference.DEFAULT;
    @Option(secure=true, description="prefixProvider")
    private String prefixProvider = "SMT";
    Configuration config;
    private List<BooleanFormula> lastErrorPath = null;
    private final StatInt totalPathLength = new StatInt(StatKind.AVG, "Avg. length of target path (in blocks)");
    private final StatTimer totalRefinement = new StatTimer("Time for refinement");
    private final StatTimer errorPathProcessing = new StatTimer("Error path post-processing");
    private final StatTimer getFormulasForPathTime = new StatTimer("Path-formulas extraction");
    private final StatTimer buildCounterexampeTraceTime = new StatTimer("Building the counterexample trace");
    private final StatTimer preciseCouterexampleTime = new StatTimer("Extracting precise counterexample");
    private final LogManager logger;
    protected final PathFormulaManager pfmgr;
    private final FormulaManagerView fmgr;
    private final InterpolationManager formulaManager;
    private final PathChecker pathChecker;
    private final RefinementStrategy strategy;
    private final Solver solver;
    private final PredicateAssumeStore assumesStore;
    private final CFA cfa;
    private static final Function<PredicateAbstractState, BooleanFormula> GET_BLOCK_FORMULA = new Function<PredicateAbstractState, BooleanFormula>(){

        public BooleanFormula apply(PredicateAbstractState e) {
            assert (e.isAbstractionState());
            return e.getAbstractionFormula().getBlockFormula().getFormula();
        }
    };

    public PredicateCPARefiner(Configuration pConfig, LogManager pLogger, ConfigurableProgramAnalysis pCpa, InterpolationManager pInterpolationManager, PathChecker pPathChecker, PathFormulaManager pPathFormulaManager, RefinementStrategy pStrategy, Solver pSolver, PredicateAssumeStore pAssumesStore, CFA pCfa) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        pConfig.inject((Object)this, PredicateCPARefiner.class);
        this.assumesStore = pAssumesStore;
        this.solver = pSolver;
        this.logger = pLogger;
        this.formulaManager = pInterpolationManager;
        this.pathChecker = pPathChecker;
        this.pfmgr = pPathFormulaManager;
        this.fmgr = this.solver.getFormulaManager();
        this.strategy = pStrategy;
        this.cfa = pCfa;
        this.config = pConfig;
        this.logger.log(Level.INFO, new Object[]{"Using refinement for predicate analysis with " + this.strategy.getClass().getSimpleName() + " strategy."});
    }

    @Override
    public final CounterexampleInfo performRefinement(ARGReachedSet pReached, ARGPath allStatesTrace) throws CPAException, InterruptedException {
        CounterexampleTraceInfo preciseCounterexample;
        ARGPath targetPath;
        List<BooleanFormula> formulas;
        this.totalRefinement.start();
        if (this.isRefinementSelectionEnabled(allStatesTrace)) {
            allStatesTrace = this.performRefinementSelection(allStatesTrace);
        }
        Set<ARGState> elementsOnPath = ARGUtils.getAllStatesOnPathsTo(allStatesTrace.getLastState());
        assert (elementsOnPath.containsAll((Collection<?>)allStatesTrace.getStateSet()));
        assert (elementsOnPath.size() >= allStatesTrace.size());
        boolean branchingOccurred = true;
        if (elementsOnPath.size() == allStatesTrace.size()) {
            elementsOnPath = Collections.emptySet();
            branchingOccurred = false;
        }
        this.logger.log(Level.FINEST, new Object[]{"Starting interpolation-based refinement"});
        List<ARGState> abstractionStatesTrace = PredicateCPARefiner.transformPath(allStatesTrace);
        this.totalPathLength.setNextValue(abstractionStatesTrace.size());
        this.logger.log(Level.ALL, new Object[]{"Abstraction trace is", abstractionStatesTrace});
        List<BooleanFormula> list = formulas = this.isRefinementSelectionEnabled(allStatesTrace) ? this.recomputePathFormulae(allStatesTrace) : this.getFormulasForPath(abstractionStatesTrace, allStatesTrace.getFirstState());
        assert (abstractionStatesTrace.size() == formulas.size());
        this.logger.log(Level.ALL, new Object[]{"Error path formulas: ", formulas});
        this.buildCounterexampeTraceTime.start();
        CounterexampleTraceInfo counterexample = this.formulaManager.buildCounterexampleTrace(formulas, Lists.newArrayList(abstractionStatesTrace), elementsOnPath, this.strategy.needsInterpolants());
        this.buildCounterexampeTraceTime.stop();
        if (counterexample.isSpurious()) {
            this.logger.log(Level.FINEST, new Object[]{"Error trace is spurious, refining the abstraction"});
            boolean repeatedCounterexample = formulas.equals(this.lastErrorPath);
            this.lastErrorPath = formulas;
            this.strategy.performRefinement(pReached, abstractionStatesTrace, counterexample.getInterpolants(), repeatedCounterexample);
            this.totalRefinement.stop();
            return CounterexampleInfo.spurious();
        }
        this.logger.log(Level.FINEST, new Object[]{"Error trace is not spurious"});
        this.preciseCouterexampleTime.start();
        if (branchingOccurred) {
            Pair<ARGPath, CounterexampleTraceInfo> preciseInfo = this.findPreciseErrorPath(allStatesTrace, counterexample);
            if (preciseInfo != null) {
                targetPath = (ARGPath)preciseInfo.getFirst();
                if (preciseInfo.getSecond() != null) {
                    preciseCounterexample = (CounterexampleTraceInfo)preciseInfo.getSecond();
                } else {
                    this.logger.log(Level.WARNING, new Object[]{"The satisfying assignment may be imprecise!"});
                    preciseCounterexample = counterexample;
                }
            } else {
                this.logger.log(Level.WARNING, new Object[]{"The error path and the satisfying assignment may be imprecise!"});
                targetPath = allStatesTrace;
                preciseCounterexample = counterexample;
            }
        } else {
            targetPath = allStatesTrace;
            preciseCounterexample = this.addVariableAssignmentToCounterexample(counterexample, targetPath);
        }
        this.preciseCouterexampleTime.stop();
        CounterexampleInfo cex = CounterexampleInfo.feasible(targetPath, preciseCounterexample.getModel());
        cex.addFurtherInformation(this.formulaManager.dumpCounterexample(preciseCounterexample), this.dumpCounterexampleFile);
        this.totalRefinement.stop();
        return cex;
    }

    private ARGPath performRefinementSelection(ARGPath allStatesTrace) throws CPAException, InterruptedException {
        try {
            PrefixProvider provider = this.prefixProvider.equals("SMT") ? new PredicateBasedPrefixProvider(this.logger, this.solver, this.pfmgr) : new ValueAnalysisFeasibilityChecker(this.logger, this.cfa, this.config);
            ErrorPathClassifier classifier = new ErrorPathClassifier(this.cfa.getVarClassification(), this.cfa.getLoopStructure());
            allStatesTrace = classifier.obtainPrefix(this.prefixPreference, allStatesTrace, provider.getInfeasilbePrefixes(allStatesTrace));
        }
        catch (InvalidConfigurationException e) {
            throw new CPAException("Configuring ValueAnalysisFeasibilityChecker failed: " + e.getMessage(), e);
        }
        return allStatesTrace;
    }

    private boolean isRefinementSelectionEnabled(ARGPath errorPath) {
        return this.prefixPreference != ErrorPathClassifier.ErrorPathPrefixPreference.DEFAULT && errorPath.size() - PredicateCPARefiner.transformPath(errorPath).size() == 1;
    }

    static List<ARGState> transformPath(ARGPath pPath) {
        ImmutableList result = FluentIterable.from(pPath.asStatesList()).skip(1).filter(Predicates.compose(PredicateAbstractState.FILTER_ABSTRACTION_STATES, AbstractStates.toState(PredicateAbstractState.class))).toList();
        assert (FluentIterable.from((Iterable)result).allMatch((Predicate)new Predicate<ARGState>(){

            public boolean apply(ARGState pInput) {
                boolean correct;
                boolean bl = correct = pInput.getParents().size() <= 1;
                assert (correct) : "PredicateCPARefiner expects abstraction states to have only one parent, but this state has more:" + pInput;
                return correct;
            }
        }));
        assert (pPath.getLastState() == result.get(result.size() - 1));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BooleanFormula> getFormulasForPath(List<ARGState> path, ARGState initialState) throws CPATransferException, InterruptedException, SolverException {
        this.getFormulasForPathTime.start();
        try {
            if (this.conjunctPreconditionFormulas) {
                ImmutableList predicateStates = FluentIterable.from(path).toList();
                ArrayList result = Lists.newArrayList();
                UnmodifiableIterator abstractionIt = predicateStates.iterator();
                BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
                BooleanFormula traceFormula = bfmgr.makeBoolean(true);
                while (abstractionIt.hasNext()) {
                    ARGState argState = (ARGState)abstractionIt.next();
                    LocationState locState = AbstractStates.extractStateByType(argState, LocationState.class);
                    CFANode loc = locState.getLocationNode();
                    PredicateAbstractState predState = AbstractStates.extractStateByType(argState, PredicateAbstractState.class);
                    assert (predState.isAbstractionState());
                    BooleanFormula blockFormula = predState.getAbstractionFormula().getBlockFormula().getFormula();
                    SSAMap blockSsaMap = predState.getAbstractionFormula().getBlockFormula().getSsa();
                    traceFormula = bfmgr.and(traceFormula, blockFormula);
                    if (!BlockOperator.isFirstLocationInFunctionBody(loc) || this.solver.isUnsat(traceFormula)) {
                        result.add(blockFormula);
                        continue;
                    }
                    BooleanFormula eliminationResult = this.fmgr.eliminateDeadVariables(traceFormula, blockSsaMap);
                    BooleanFormula blockPrecondition = this.assumesStore.conjunctAssumeToLocation(loc, this.fmgr.makeNot(eliminationResult));
                    result.add(bfmgr.and(blockFormula, blockPrecondition));
                }
                ArrayList arrayList = result;
                return arrayList;
            }
            if (this.sliceBlockFormulas) {
                BlockFormulaSlicer bfs = new BlockFormulaSlicer(this.pfmgr);
                List<BooleanFormula> list = bfs.sliceFormulasForPath(path, initialState);
                return list;
            }
            ImmutableList immutableList = FluentIterable.from(path).transform(AbstractStates.toState(PredicateAbstractState.class)).transform(GET_BLOCK_FORMULA).toList();
            return immutableList;
        }
        finally {
            this.getFormulasForPathTime.stop();
        }
    }

    private List<BooleanFormula> recomputePathFormulae(ARGPath pAllStatesTrace) throws CPATransferException, InterruptedException {
        ArrayList<BooleanFormula> list = new ArrayList<BooleanFormula>(pAllStatesTrace.size() - 1);
        PathFormula pathFormula = this.pfmgr.makeEmptyPathFormula();
        for (CFAEdge edge : pAllStatesTrace.getInnerEdges()) {
            pathFormula = this.pfmgr.makeAnd(this.pfmgr.makeEmptyPathFormula(pathFormula), edge);
            list.add(pathFormula.getFormula());
        }
        assert (list.size() == pAllStatesTrace.size() - 1);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<ARGPath, CounterexampleTraceInfo> findPreciseErrorPath(ARGPath pPath, CounterexampleTraceInfo counterexample) throws InterruptedException {
        this.errorPathProcessing.start();
        try {
            Pair pair;
            CounterexampleTraceInfo info2;
            ARGPath targetPath;
            Map<Integer, Boolean> preds = counterexample.getBranchingPredicates();
            if (preds.isEmpty()) {
                this.logger.log(Level.WARNING, new Object[]{"No information about ARG branches available!"});
                Pair<ARGPath, CounterexampleTraceInfo> pair2 = null;
                return pair2;
            }
            try {
                ARGState root = pPath.getFirstState();
                ARGState target = pPath.getLastState();
                Set<ARGState> pathElements = ARGUtils.getAllStatesOnPathsTo(target);
                targetPath = ARGUtils.getPathFromBranchingInformation(root, target, pathElements, preds);
            }
            catch (IllegalArgumentException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, null);
                Pair<ARGPath, CounterexampleTraceInfo> target = null;
                this.errorPathProcessing.stop();
                return target;
            }
            try {
                info2 = this.pathChecker.checkPath(targetPath.getInnerEdges());
            }
            catch (CPATransferException | SolverException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not replay error path");
                Pair<ARGPath, CounterexampleTraceInfo> pair3 = null;
                this.errorPathProcessing.stop();
                return pair3;
            }
            if (info2.isSpurious()) {
                this.logger.log(Level.WARNING, new Object[]{"Inconsistent replayed error path!"});
                pair = Pair.of((Object)targetPath, null);
                return pair;
            }
            pair = Pair.of((Object)targetPath, (Object)info2);
            return pair;
        }
        finally {
            this.errorPathProcessing.stop();
        }
    }

    private CounterexampleTraceInfo addVariableAssignmentToCounterexample(CounterexampleTraceInfo counterexample, ARGPath targetPath) throws CPATransferException, InterruptedException {
        List<CFAEdge> edges = targetPath.getInnerEdges();
        List<SSAMap> ssamaps = this.pathChecker.calculatePreciseSSAMaps(edges);
        Model model = counterexample.getModel();
        Pair<CFAPathWithAssumptions, Multimap<CFAEdge, Model.AssignableTerm>> pathAndTerms = this.pathChecker.extractVariableAssignment(edges, ssamaps, model);
        CFAPathWithAssumptions pathWithAssignments = (CFAPathWithAssumptions)pathAndTerms.getFirst();
        Multimap termsPerEdge = (Multimap)pathAndTerms.getSecond();
        model = model.withAssignmentInformation(pathWithAssignments, (Multimap<CFAEdge, Model.AssignableTerm>)termsPerEdge);
        return CounterexampleTraceInfo.feasible(counterexample.getCounterExampleFormulas(), model, counterexample.getBranchingPredicates());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
    }

    class Stats
    extends AbstractStatistics {
        private final Statistics statistics;

        Stats() {
            this.statistics = PredicateCPARefiner.this.strategy.getStatistics();
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            StatisticsWriter w0 = StatisticsWriter.writingStatisticsTo(out);
            int numberOfRefinements = PredicateCPARefiner.this.totalRefinement.getUpdateCount();
            if (numberOfRefinements > 0) {
                w0.put(PredicateCPARefiner.this.totalPathLength).spacer().put(PredicateCPARefiner.this.totalRefinement);
                PredicateCPARefiner.this.formulaManager.printStatistics(out, result, reached);
                w0.beginLevel().put(PredicateCPARefiner.this.errorPathProcessing);
                w0.beginLevel().put(PredicateCPARefiner.this.getFormulasForPathTime);
                w0.beginLevel().put(PredicateCPARefiner.this.buildCounterexampeTraceTime);
                w0.beginLevel().put(PredicateCPARefiner.this.preciseCouterexampleTime);
            }
            this.statistics.printStatistics(out, result, reached);
        }

        @Override
        public String getName() {
            return PredicateCPARefiner.this.strategy.getStatistics().getName();
        }
    }
}

