/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractDomain;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateMergeOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.LoopInvariantsWriter;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateAbstractionsWriter;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateMapWriter;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="cpa.predicate")
class PredicateCPAStatistics
extends AbstractStatistics {
    @Option(secure=true, description="export final predicate map", name="predmap.export")
    private boolean exportPredmap = true;
    @Option(secure=true, description="file for exporting final predicate map", name="predmap.file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path predmapFile = Paths.get((String)"predmap.txt", (String[])new String[0]);
    @Option(secure=true, name="precondition.file", description="File for exporting the weakest precondition.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path preconditionFile = Paths.get((String)"precondition.txt", (String[])new String[0]);
    @Option(secure=true, name="precondition.export", description="Export the weakest precondition?")
    private boolean preconditionExport = false;
    @Option(secure=true, description="export final loop invariants", name="invariants.export")
    private boolean exportInvariants = true;
    @Option(secure=true, description="export invariants as precision file?", name="invariants.exportAsPrecision")
    private boolean exportInvariantsAsPrecision = true;
    @Option(secure=true, description="file for exporting final loop invariants", name="invariants.file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path invariantsFile = Paths.get((String)"invariants.txt", (String[])new String[0]);
    @Option(secure=true, description="file for precision that consists of invariants.", name="invariants.precisionFile")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path invariantPrecisionsFile = Paths.get((String)"invariantPrecs.txt", (String[])new String[0]);
    @Option(description="Export one abstraction formula for each abstraction state into a file?", name="abstractions.export")
    private boolean abstractionsExport = true;
    @Option(secure=true, description="file that consists of one abstraction formula for each abstraction state", name="abstractions.file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path abstractionsFile = Paths.get((String)"abstractions.txt", (String[])new String[0]);
    @Option(description="enable export of all relations that were collected to synthecise the abstract precision?", name="relations.export")
    private boolean relationsExport = false;
    @Option(description="file that consists all relations that were collected to synthecise the abstract precision", name="relations.file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path relationsFile = Paths.get((String)"relations.txt", (String[])new String[0]);
    private final PredicateCPA cpa;
    private final BlockOperator blk;
    private final RegionManager rmgr;
    private final AbstractionManager absmgr;
    private final PredicateMapWriter precisionWriter;
    private final LoopInvariantsWriter loopInvariantsWriter;
    private final PredicateAbstractionsWriter abstractionsWriter;
    private final Timer invariantGeneratorTime;

    public PredicateCPAStatistics(PredicateCPA pCpa, BlockOperator pBlk, RegionManager pRmgr, AbstractionManager pAbsmgr, CFA pCfa, Timer pInvariantGeneratorTimer, Configuration pConfig) throws InvalidConfigurationException {
        this.cpa = pCpa;
        this.blk = pBlk;
        this.rmgr = pRmgr;
        this.absmgr = pAbsmgr;
        this.invariantGeneratorTime = (Timer)Preconditions.checkNotNull((Object)pInvariantGeneratorTimer);
        pConfig.inject((Object)this, PredicateCPAStatistics.class);
        FormulaManagerView fmgr = this.cpa.getSolver().getFormulaManager();
        this.loopInvariantsWriter = new LoopInvariantsWriter(pCfa, this.cpa.getLogger(), pAbsmgr, fmgr, pRmgr);
        this.abstractionsWriter = new PredicateAbstractionsWriter(this.cpa.getLogger(), fmgr);
        this.precisionWriter = this.exportPredmap && this.predmapFile != null ? new PredicateMapWriter(this.cpa.getConfiguration(), fmgr) : null;
    }

    @Override
    public String getName() {
        return "PredicateCPA";
    }

    private void exportPredmapToFile(Path targetFile, MutablePredicateSets predicates) {
        Preconditions.checkNotNull((Object)targetFile);
        Preconditions.checkNotNull((Object)predicates);
        HashSet allPredicates = Sets.newHashSet((Iterable)predicates.global);
        allPredicates.addAll(predicates.function.values());
        allPredicates.addAll(predicates.location.values());
        allPredicates.addAll(predicates.locationInstance.values());
        try (Writer w = Files.openOutputFile((Path)targetFile, (FileWriteMode[])new FileWriteMode[0]);){
            this.precisionWriter.writePredicateMap((SetMultimap<Pair<CFANode, Integer>, AbstractionPredicate>)predicates.locationInstance, (SetMultimap<CFANode, AbstractionPredicate>)predicates.location, (SetMultimap<String, AbstractionPredicate>)predicates.function, predicates.global, allPredicates, w);
        }
        catch (IOException e) {
            this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write predicate map to file");
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        MergeOperator merge;
        int numAbstractions;
        PredicateAbstractionManager amgr = this.cpa.getPredicateManager();
        MutablePredicateSets predicates = new MutablePredicateSets();
        Set seenPrecisions = Collections.newSetFromMap(new IdentityHashMap());
        for (Precision precision : reached.getPrecisions()) {
            if (!seenPrecisions.add(precision) || !(precision instanceof WrapperPrecision)) continue;
            PredicatePrecision preds = ((WrapperPrecision)precision).retrieveWrappedPrecision(PredicatePrecision.class);
            predicates.locationInstance.putAll(preds.getLocationInstancePredicates());
            predicates.location.putAll(preds.getLocalPredicates());
            predicates.function.putAll(preds.getFunctionPredicates());
            predicates.global.addAll(preds.getGlobalPredicates());
        }
        if (this.exportPredmap && this.predmapFile != null) {
            this.exportPredmapToFile(this.predmapFile, predicates);
        }
        int maxPredsPerLocation = 0;
        for (Collection p : predicates.location.asMap().values()) {
            maxPredsPerLocation = Math.max(maxPredsPerLocation, p.size());
        }
        int allLocs = predicates.location.keySet().size();
        int totPredsUsed = predicates.location.size();
        int avgPredsPerLocation = allLocs > 0 ? totPredsUsed / allLocs : 0;
        int allDistinctPreds = this.absmgr.getNumberOfPredicates();
        if (this.exportInvariants && this.invariantsFile != null) {
            this.loopInvariantsWriter.exportLoopInvariants(this.invariantsFile, reached);
        }
        if (this.abstractionsExport && this.abstractionsFile != null) {
            this.abstractionsWriter.writeAbstractions(this.abstractionsFile, reached);
        }
        if (this.exportInvariantsAsPrecision && this.invariantPrecisionsFile != null) {
            this.loopInvariantsWriter.exportLoopInvariantsAsPrecision(this.invariantPrecisionsFile, reached);
        }
        PredicateAbstractionManager.Stats as = amgr.stats;
        PredicateAbstractDomain domain = this.cpa.getAbstractDomain();
        PredicateTransferRelation trans = this.cpa.getTransferRelation();
        PredicatePrecisionAdjustment prec = this.cpa.getPrecisionAdjustment();
        Solver solver = this.cpa.getSolver();
        CachingPathFormulaManager pfMgr = null;
        if (this.cpa.getPathFormulaManager() instanceof CachingPathFormulaManager) {
            pfMgr = (CachingPathFormulaManager)this.cpa.getPathFormulaManager();
        }
        out.println("Number of abstractions:            " + prec.numAbstractions + " (" + StatisticsUtils.toPercent(prec.numAbstractions, trans.postTimer.getNumberOfIntervals()) + " of all post computations)");
        if (prec.numAbstractions > 0) {
            out.println("  Times abstraction was reused:    " + as.numAbstractionReuses);
            out.println("  Because of function entry/exit:  " + StatisticsUtils.valueWithPercentage(this.blk.numBlkFunctions, prec.numAbstractions));
            out.println("  Because of loop head:            " + StatisticsUtils.valueWithPercentage(this.blk.numBlkLoops, prec.numAbstractions));
            out.println("  Because of join nodes:           " + StatisticsUtils.valueWithPercentage(this.blk.numBlkJoins, prec.numAbstractions));
            out.println("  Because of threshold:            " + StatisticsUtils.valueWithPercentage(this.blk.numBlkThreshold, prec.numAbstractions));
            out.println("  Times precision was empty:       " + StatisticsUtils.valueWithPercentage(as.numSymbolicAbstractions, as.numCallsAbstraction));
            out.println("  Times precision was {false}:     " + StatisticsUtils.valueWithPercentage(as.numSatCheckAbstractions, as.numCallsAbstraction));
            out.println("  Times result was cached:         " + StatisticsUtils.valueWithPercentage(as.numCallsAbstractionCached, as.numCallsAbstraction));
            out.println("  Times cartesian abs was used:    " + StatisticsUtils.valueWithPercentage(as.cartesianAbstractionTime.getNumberOfIntervals(), as.numCallsAbstraction));
            out.println("  Times boolean abs was used:      " + StatisticsUtils.valueWithPercentage(as.booleanAbstractionTime.getNumberOfIntervals(), as.numCallsAbstraction));
            out.println("  Times result was 'false':        " + StatisticsUtils.valueWithPercentage(prec.numAbstractionsFalse, prec.numAbstractions));
        }
        if (trans.satCheckTimer.getNumberOfIntervals() > 0) {
            out.println("Number of satisfiability checks:   " + trans.satCheckTimer.getNumberOfIntervals());
            out.println("  Times result was 'false':        " + trans.numSatChecksFalse + " (" + StatisticsUtils.toPercent(trans.numSatChecksFalse, trans.satCheckTimer.getNumberOfIntervals()) + ")");
        }
        out.println("Number of strengthen sat checks:   " + trans.strengthenCheckTimer.getNumberOfIntervals());
        if (trans.strengthenCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Times result was 'false':        " + trans.numStrengthenChecksFalse + " (" + StatisticsUtils.toPercent(trans.numStrengthenChecksFalse, trans.strengthenCheckTimer.getNumberOfIntervals()) + ")");
        }
        out.println("Number of coverage checks:         " + domain.coverageCheckTimer.getNumberOfIntervals());
        out.println("  BDD entailment checks:           " + domain.bddCoverageCheckTimer.getNumberOfIntervals());
        if (domain.symbolicCoverageCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Symbolic coverage check:         " + domain.symbolicCoverageCheckTimer.getNumberOfIntervals());
        }
        out.println("Number of SMT sat checks:          " + solver.satChecks);
        out.println("  trivial:                         " + solver.trivialSatChecks);
        out.println("  cached:                          " + solver.cachedSatChecks);
        out.println();
        out.println("Max ABE block size:                       " + prec.maxBlockSize);
        out.println("Number of predicates discovered:          " + allDistinctPreds);
        if (allDistinctPreds > 0) {
            out.println("Number of abstraction locations:          " + allLocs);
            out.println("Max number of predicates per location:    " + maxPredsPerLocation);
            out.println("Avg number of predicates per location:    " + avgPredsPerLocation);
        }
        if ((numAbstractions = as.numCallsAbstraction - as.numSymbolicAbstractions) > 0) {
            int numRealAbstractions = as.numCallsAbstraction - as.numSymbolicAbstractions - as.numCallsAbstractionCached;
            out.println("Total predicates per abstraction:         " + as.numTotalPredicates);
            out.println("Max number of predicates per abstraction: " + as.maxPredicates);
            out.println("Avg number of predicates per abstraction: " + StatisticsUtils.div(as.numTotalPredicates, numRealAbstractions));
            out.println("Number of irrelevant predicates:          " + StatisticsUtils.valueWithPercentage(as.numIrrelevantPredicates, as.numTotalPredicates));
            if (as.trivialPredicatesTime.getNumberOfIntervals() > 0) {
                out.println("Number of trivially used predicates:      " + StatisticsUtils.valueWithPercentage(as.numTrivialPredicates, as.numTotalPredicates));
            }
            if (as.cartesianAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("Number of preds cached for cartesian abs: " + StatisticsUtils.valueWithPercentage(as.numCartesianAbsPredicatesCached, as.numTotalPredicates));
                out.println("Number of preds solved by cartesian abs:  " + StatisticsUtils.valueWithPercentage(as.numCartesianAbsPredicates, as.numTotalPredicates));
            }
            if (as.booleanAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("Number of preds handled by boolean abs:   " + StatisticsUtils.valueWithPercentage(as.numBooleanAbsPredicates, as.numTotalPredicates));
                out.println("  Total number of models for allsat:      " + as.allSatCount);
                out.println("  Max number of models for allsat:        " + as.maxAllSatCount);
                out.println("  Avg number of models for allsat:        " + StatisticsUtils.div(as.allSatCount, as.booleanAbstractionTime.getNumberOfIntervals()));
            }
        }
        out.println();
        if (pfMgr != null) {
            int pathFormulaCacheHits = pfMgr.pathFormulaCacheHits;
            int totalPathFormulaComputations = pfMgr.pathFormulaComputationTimer.getNumberOfIntervals() + pathFormulaCacheHits;
            out.println("Number of path formula cache hits:   " + pathFormulaCacheHits + " (" + StatisticsUtils.toPercent(pathFormulaCacheHits, totalPathFormulaComputations) + ")");
        }
        out.println();
        out.println("Time for post operator:              " + trans.postTimer);
        out.println("  Time for path formula creation:    " + trans.pathFormulaTimer);
        if (pfMgr != null) {
            out.println("    Actual computation:              " + pfMgr.pathFormulaComputationTimer);
        }
        if (trans.satCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for satisfiability checks:    " + trans.satCheckTimer);
        }
        out.println("Time for strengthen operator:        " + trans.strengthenTimer);
        if (trans.strengthenCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for satisfiability checks:    " + trans.strengthenCheckTimer);
        }
        out.println("Time for prec operator:              " + prec.totalPrecTime);
        if (prec.numAbstractions > 0) {
            if (this.invariantGeneratorTime.getNumberOfIntervals() > 0) {
                out.println("  Time for generating invariants:    " + this.invariantGeneratorTime);
                out.println("  Time for extracting invariants:    " + prec.invariantGenerationTime);
            }
            out.println("  Time for abstraction:              " + prec.computingAbstractionTime + " (Max: " + prec.computingAbstractionTime.getMaxTime().formatAs(TimeUnit.SECONDS) + ", Count: " + prec.computingAbstractionTime.getNumberOfIntervals() + ")");
            if (as.trivialPredicatesTime.getNumberOfIntervals() > 0) {
                out.println("    Relevant predicate analysis:     " + as.trivialPredicatesTime);
            }
            if (as.cartesianAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("    Cartesian abstraction:           " + as.cartesianAbstractionTime);
            }
            if (as.booleanAbstractionTime.getNumberOfIntervals() > 0) {
                out.println("    Boolean abstraction:             " + as.booleanAbstractionTime);
            }
            if (as.abstractionReuseTime.getNumberOfIntervals() > 0) {
                out.println("    Abstraction reuse:              " + as.abstractionReuseTime);
                out.println("    Abstraction reuse implication:  " + as.abstractionReuseImplicationTime);
            }
            out.println("    Solving time:                    " + as.abstractionSolveTime + " (Max: " + as.abstractionSolveTime.getMaxTime().formatAs(TimeUnit.SECONDS) + ")");
            out.println("    Model enumeration time:          " + as.abstractionEnumTime.getOuterSumTime().formatAs(TimeUnit.SECONDS));
            out.println("    Time for BDD construction:       " + as.abstractionEnumTime.getInnerSumTime().formatAs(TimeUnit.SECONDS) + " (Max: " + as.abstractionEnumTime.getInnerMaxTime().formatAs(TimeUnit.SECONDS) + ")");
        }
        if ((merge = this.cpa.getMergeOperator()) instanceof PredicateMergeOperator) {
            out.println("Time for merge operator:             " + ((PredicateMergeOperator)merge).totalMergeTime);
        }
        out.println("Time for coverage check:             " + domain.coverageCheckTimer);
        if (domain.bddCoverageCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for BDD entailment checks:    " + domain.bddCoverageCheckTimer);
        }
        if (domain.symbolicCoverageCheckTimer.getNumberOfIntervals() > 0) {
            out.println("  Time for symbolic coverage checks: " + domain.symbolicCoverageCheckTimer);
        }
        out.println("Total time for SMT solver (w/o itp): " + TimeSpan.sum((TimeSpan[])new TimeSpan[]{solver.solverTime.getSumTime(), as.abstractionSolveTime.getSumTime(), as.abstractionEnumTime.getOuterSumTime()}).formatAs(TimeUnit.SECONDS));
        if (trans.abstractionCheckTimer.getNumberOfIntervals() > 0) {
            out.println("Time for abstraction checks:       " + trans.abstractionCheckTimer);
            out.println("Time for unsat checks:             " + trans.satCheckTimer + " (Calls: " + trans.satCheckTimer.getNumberOfIntervals() + ")");
        }
        out.println();
        this.rmgr.printStatistics(out);
    }

    private static class MutablePredicateSets {
        private static Supplier<Set<AbstractionPredicate>> hashSetSupplier = new Supplier<Set<AbstractionPredicate>>(){

            public Set<AbstractionPredicate> get() {
                return Sets.newHashSet();
            }
        };
        private final SetMultimap<Pair<CFANode, Integer>, AbstractionPredicate> locationInstance = Multimaps.newSetMultimap(new TreeMap(Pair.lexicographicalNaturalComparator()), hashSetSupplier);
        private final SetMultimap<CFANode, AbstractionPredicate> location = Multimaps.newSetMultimap(new TreeMap(), hashSetSupplier);
        private final SetMultimap<String, AbstractionPredicate> function = Multimaps.newSetMultimap(new TreeMap(), hashSetSupplier);
        private final Set<AbstractionPredicate> global = Sets.newHashSet();

        private MutablePredicateSets() {
        }
    }
}

