/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class PredicateMergeOperator
implements MergeOperator {
    private final LogManager logger;
    private final PathFormulaManager formulaManager;
    final Timer totalMergeTime = new Timer();

    public PredicateMergeOperator(PredicateCPA pCpa) {
        this.logger = pCpa.getLogger();
        this.formulaManager = pCpa.getPathFormulaManager();
    }

    @Override
    public AbstractState merge(AbstractState element1, AbstractState element2, Precision precision) throws InterruptedException {
        PredicateAbstractState merged;
        PredicateAbstractState elem1 = (PredicateAbstractState)element1;
        PredicateAbstractState elem2 = (PredicateAbstractState)element2;
        if (elem1.isAbstractionState() || elem2.isAbstractionState()) {
            merged = elem2;
        } else if (!elem1.getAbstractionFormula().equals(elem2.getAbstractionFormula())) {
            merged = elem2;
        } else {
            this.totalMergeTime.start();
            assert (elem1.getAbstractionLocationsOnPath().equals(elem2.getAbstractionLocationsOnPath()));
            this.logger.log(Level.FINEST, new Object[]{"Merging two non-abstraction nodes."});
            PathFormula pathFormula = this.formulaManager.makeOr(elem1.getPathFormula(), elem2.getPathFormula());
            this.logger.log(Level.ALL, new Object[]{"New path formula is", pathFormula});
            merged = PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(pathFormula, elem1);
            elem1.setMergedInto(merged);
            this.totalMergeTime.stop();
        }
        return merged;
    }
}

