/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import java.util.Collection;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class PredicatePCCStopOperator
implements StopOperator {
    private final PredicateAbstractionManager paMgr;
    private final PathFormulaManager pMgr;
    private final AbstractionFormula trueAbs;

    public PredicatePCCStopOperator(PredicateCPA pCPA) throws InvalidConfigurationException {
        this.paMgr = pCPA.getPredicateManager();
        this.pMgr = pCPA.getPathFormulaManager();
        this.trueAbs = this.paMgr.makeTrueAbstractionFormula(null);
    }

    @Override
    public boolean stop(AbstractState pState, Collection<AbstractState> pReached, Precision pPrecision) throws CPAException, InterruptedException {
        PredicateAbstractState e1 = (PredicateAbstractState)pState;
        for (AbstractState reachedState : pReached) {
            PredicateAbstractState e2 = (PredicateAbstractState)reachedState;
            if (!this.isCoveredBy(e1, e2)) continue;
            return true;
        }
        return false;
    }

    private boolean isCoveredBy(PredicateAbstractState e1, PredicateAbstractState e2) throws CPAException, InterruptedException {
        if (e1.isAbstractionState() && e2.isAbstractionState()) {
            return this.paMgr.checkCoverage(e1.getAbstractionFormula(), e2.getAbstractionFormula());
        }
        if (e2.isAbstractionState()) {
            return this.paMgr.checkCoverage(e1.getAbstractionFormula(), e1.getPathFormula(), e2.getAbstractionFormula());
        }
        if (e1.isAbstractionState()) {
            return false;
        }
        if (e1.getAbstractionFormula() == e2.getAbstractionFormula()) {
            PathFormula pF = e1.getPathFormula();
            return this.paMgr.unsat(this.trueAbs, new PathFormula(this.pMgr.buildImplicationTestAsUnsat(pF, e2.getPathFormula()), pF.getSsa(), pF.getPointerTargetSet(), pF.getLength()));
        }
        return false;
    }
}

