/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;

public class PredicatePrecision
implements Precision {
    private final ImmutableSetMultimap<Pair<CFANode, Integer>, AbstractionPredicate> mLocationInstancePredicates;
    private final ImmutableSetMultimap<CFANode, AbstractionPredicate> mLocalPredicates;
    private final ImmutableSetMultimap<String, AbstractionPredicate> mFunctionPredicates;
    private final ImmutableSet<AbstractionPredicate> mGlobalPredicates;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final int id = idGenerator.getFreshId();

    public PredicatePrecision(Multimap<Pair<CFANode, Integer>, AbstractionPredicate> pLocationInstancePredicates, Multimap<CFANode, AbstractionPredicate> pLocalPredicates, Multimap<String, AbstractionPredicate> pFunctionPredicates, Collection<AbstractionPredicate> pGlobalPredicates) {
        this.mLocationInstancePredicates = ImmutableSetMultimap.copyOf(pLocationInstancePredicates);
        this.mLocalPredicates = PredicatePrecision.sortedImmutableSetCopyOf(pLocalPredicates);
        this.mFunctionPredicates = PredicatePrecision.sortedImmutableSetCopyOf(pFunctionPredicates);
        this.mGlobalPredicates = ImmutableSet.copyOf(pGlobalPredicates);
    }

    private static <K extends Comparable<? super K>, V> ImmutableSetMultimap<K, V> sortedImmutableSetCopyOf(Multimap<K, V> m) {
        return ImmutableSetMultimap.builder().orderKeysBy((Comparator)Ordering.natural()).putAll(m).build();
    }

    public static PredicatePrecision empty() {
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<CFANode, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<String, AbstractionPredicate>)ImmutableSetMultimap.of(), (Collection<AbstractionPredicate>)ImmutableSet.of());
    }

    public ImmutableSetMultimap<Pair<CFANode, Integer>, AbstractionPredicate> getLocationInstancePredicates() {
        return this.mLocationInstancePredicates;
    }

    public ImmutableSetMultimap<CFANode, AbstractionPredicate> getLocalPredicates() {
        return this.mLocalPredicates;
    }

    public ImmutableSetMultimap<String, AbstractionPredicate> getFunctionPredicates() {
        return this.mFunctionPredicates;
    }

    public Set<AbstractionPredicate> getGlobalPredicates() {
        return this.mGlobalPredicates;
    }

    public Set<AbstractionPredicate> getPredicates(CFANode loc, Integer locInstance) {
        Object result = this.getLocationInstancePredicates().get((Object)Pair.of((Object)loc, (Object)locInstance));
        if (result.isEmpty()) {
            result = this.getLocalPredicates().get((Object)loc);
        }
        if (result.isEmpty()) {
            result = this.getFunctionPredicates().get((Object)loc.getFunctionName());
        }
        if (result.isEmpty()) {
            result = this.getGlobalPredicates();
        }
        return result;
    }

    public PredicatePrecision addGlobalPredicates(Collection<AbstractionPredicate> newPredicates) {
        ArrayList predicates = Lists.newArrayList(this.getGlobalPredicates());
        predicates.addAll(newPredicates);
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)this.getLocationInstancePredicates(), (Multimap<CFANode, AbstractionPredicate>)this.getLocalPredicates(), (Multimap<String, AbstractionPredicate>)this.getFunctionPredicates(), predicates);
    }

    public PredicatePrecision addFunctionPredicates(Multimap<String, AbstractionPredicate> newPredicates) {
        ArrayListMultimap predicates = ArrayListMultimap.create(this.getFunctionPredicates());
        predicates.putAll(newPredicates);
        if (!this.getGlobalPredicates().isEmpty()) {
            for (String function : newPredicates.keySet()) {
                predicates.putAll((Object)function, this.getGlobalPredicates());
            }
        }
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)this.getLocationInstancePredicates(), (Multimap<CFANode, AbstractionPredicate>)this.getLocalPredicates(), (Multimap<String, AbstractionPredicate>)predicates, (Collection<AbstractionPredicate>)this.getGlobalPredicates());
    }

    public PredicatePrecision addLocalPredicates(Multimap<CFANode, AbstractionPredicate> newPredicates) {
        ArrayListMultimap predicates = ArrayListMultimap.create(this.getLocalPredicates());
        predicates.putAll(newPredicates);
        if (!this.getGlobalPredicates().isEmpty() || !this.getFunctionPredicates().isEmpty()) {
            for (CFANode newLoc : newPredicates.keySet()) {
                predicates.putAll((Object)newLoc, (Iterable)this.getFunctionPredicates().get((Object)newLoc.getFunctionName()));
                predicates.putAll((Object)newLoc, this.getGlobalPredicates());
            }
        }
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)this.getLocationInstancePredicates(), (Multimap<CFANode, AbstractionPredicate>)predicates, (Multimap<String, AbstractionPredicate>)this.getFunctionPredicates(), (Collection<AbstractionPredicate>)this.getGlobalPredicates());
    }

    public PredicatePrecision addLocationInstancePredicates(Multimap<Pair<CFANode, Integer>, AbstractionPredicate> newPredicates) {
        ArrayListMultimap predicates = ArrayListMultimap.create(this.getLocationInstancePredicates());
        predicates.putAll(newPredicates);
        if (!(this.getGlobalPredicates().isEmpty() && this.getFunctionPredicates().isEmpty() && this.getLocalPredicates().isEmpty())) {
            for (Pair key : newPredicates.keySet()) {
                CFANode loc = (CFANode)key.getFirst();
                predicates.putAll((Object)key, (Iterable)this.getLocalPredicates().get((Object)loc));
                predicates.putAll((Object)key, (Iterable)this.getFunctionPredicates().get((Object)loc.getFunctionName()));
                predicates.putAll((Object)key, this.getGlobalPredicates());
            }
        }
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)predicates, (Multimap<CFANode, AbstractionPredicate>)this.getLocalPredicates(), (Multimap<String, AbstractionPredicate>)this.getFunctionPredicates(), (Collection<AbstractionPredicate>)this.getGlobalPredicates());
    }

    public PredicatePrecision mergeWith(PredicatePrecision prec) {
        ArrayList newGlobalPredicates = Lists.newArrayList(this.getGlobalPredicates());
        newGlobalPredicates.addAll(prec.getGlobalPredicates());
        newGlobalPredicates = ImmutableSet.copyOf((Collection)newGlobalPredicates);
        ArrayListMultimap newFunctionPredicates = ArrayListMultimap.create(this.getFunctionPredicates());
        newFunctionPredicates.putAll(prec.getFunctionPredicates());
        if (!newGlobalPredicates.isEmpty()) {
            for (String function : newFunctionPredicates.keySet()) {
                newFunctionPredicates.putAll((Object)function, (Iterable)newGlobalPredicates);
            }
        }
        newFunctionPredicates = ImmutableSetMultimap.copyOf((Multimap)newFunctionPredicates);
        ArrayListMultimap newLocalPredicates = ArrayListMultimap.create(this.getLocalPredicates());
        newLocalPredicates.putAll(prec.getLocalPredicates());
        if (!newGlobalPredicates.isEmpty() || !newFunctionPredicates.isEmpty()) {
            for (CFANode loc : newLocalPredicates.keySet()) {
                newLocalPredicates.putAll((Object)loc, (Iterable)newGlobalPredicates);
                newLocalPredicates.putAll((Object)loc, (Iterable)newFunctionPredicates.get((Object)loc.getFunctionName()));
            }
        }
        ArrayListMultimap newLocationInstanceSpecificPredicates = ArrayListMultimap.create(this.getLocationInstancePredicates());
        newLocationInstanceSpecificPredicates.putAll(prec.getLocationInstancePredicates());
        if (!(newGlobalPredicates.isEmpty() && newFunctionPredicates.isEmpty() && newLocalPredicates.isEmpty())) {
            for (Pair key : newLocationInstanceSpecificPredicates.keySet()) {
                newLocationInstanceSpecificPredicates.putAll((Object)key, (Iterable)newGlobalPredicates);
                newLocationInstanceSpecificPredicates.putAll((Object)key, (Iterable)newFunctionPredicates.get((Object)((CFANode)key.getFirst()).getFunctionName()));
                newLocationInstanceSpecificPredicates.putAll((Object)key, (Iterable)newLocalPredicates.get(key.getFirst()));
            }
        }
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)newLocationInstanceSpecificPredicates, (Multimap<CFANode, AbstractionPredicate>)newLocalPredicates, (Multimap<String, AbstractionPredicate>)newFunctionPredicates, newGlobalPredicates);
    }

    public int calculateDifferenceTo(PredicatePrecision other) {
        int difference = 0;
        difference += Sets.difference(this.getGlobalPredicates(), other.getGlobalPredicates()).size();
        difference += Sets.difference((Set)this.getFunctionPredicates().entries(), (Set)other.getFunctionPredicates().entries()).size();
        difference += Sets.difference((Set)this.getLocalPredicates().entries(), (Set)other.getLocalPredicates().entries()).size();
        return difference += Sets.difference((Set)this.getLocationInstancePredicates().entries(), (Set)other.getLocationInstancePredicates().entries()).size();
    }

    public int hashCode() {
        return Objects.hash(this.getGlobalPredicates(), this.getFunctionPredicates(), this.getLocalPredicates(), this.getLocationInstancePredicates());
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (pObj == null) {
            return false;
        }
        if (!pObj.getClass().equals(this.getClass())) {
            return false;
        }
        PredicatePrecision other = (PredicatePrecision)pObj;
        return this.getLocationInstancePredicates().equals(other.getLocationInstancePredicates()) && this.getLocalPredicates().equals(other.getLocalPredicates()) && this.getFunctionPredicates().equals(other.getFunctionPredicates()) && this.getGlobalPredicates().equals(other.getGlobalPredicates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.getGlobalPredicates().isEmpty()) {
            sb.append("global predicates: ");
            sb.append(this.getGlobalPredicates());
        }
        if (!this.getFunctionPredicates().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("function predicates: ");
            sb.append(this.getFunctionPredicates());
        }
        if (!this.getLocalPredicates().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("local predicates: ");
            sb.append(this.getLocalPredicates());
        }
        if (!this.getLocationInstancePredicates().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("location-instance predicates: ");
            sb.append(this.getLocationInstancePredicates());
        }
        if (sb.length() == 0) {
            return "empty";
        }
        return sb.toString();
    }

    public int getId() {
        return this.id;
    }

    static ListMultimap<String, AbstractionPredicate> mergePredicatesPerFunction(Multimap<Pair<CFANode, Integer>, AbstractionPredicate> newPredicates) {
        return PredicatePrecision.transformAndMergeKeys(newPredicates, Functions.compose(CFAUtils.GET_FUNCTION, (Function)Pair.getProjectionToFirst()));
    }

    static ListMultimap<CFANode, AbstractionPredicate> mergePredicatesPerLocation(Multimap<Pair<CFANode, Integer>, AbstractionPredicate> newPredicates) {
        return PredicatePrecision.transformAndMergeKeys(newPredicates, Pair.getProjectionToFirst());
    }

    private static <K1, K2, V> ListMultimap<K2, V> transformAndMergeKeys(Multimap<K1, V> input, Function<? super K1, K2> transformFunction) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Map.Entry entry : input.asMap().entrySet()) {
            result.putAll(transformFunction.apply(entry.getKey()), (Iterable)entry.getValue());
        }
        return result;
    }
}

