/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class PredicatePrecisionAdjustment
implements PrecisionAdjustment {
    final Timer totalPrecTime = new Timer();
    final Timer invariantGenerationTime = new Timer();
    final Timer computingAbstractionTime = new Timer();
    int numAbstractions = 0;
    int numAbstractionsFalse = 0;
    int maxBlockSize = 0;
    private final LogManager logger;
    private final PredicateAbstractionManager formulaManager;
    private final PathFormulaManager pathFormulaManager;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    @Nullable
    private InvariantGenerator invariantGenerator;
    @Nullable
    private Map<CFANode, BooleanFormula> invariants = null;

    public PredicatePrecisionAdjustment(PredicateCPA pCpa, InvariantGenerator pInvariantGenerator) {
        this.logger = pCpa.getLogger();
        this.formulaManager = pCpa.getPredicateManager();
        this.pathFormulaManager = pCpa.getPathFormulaManager();
        this.fmgr = pCpa.getSolver().getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.invariantGenerator = (InvariantGenerator)Preconditions.checkNotNull((Object)pInvariantGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, AbstractState fullState) throws CPAException, InterruptedException {
        this.totalPrecTime.start();
        try {
            PredicateAbstractState element = (PredicateAbstractState)pElement;
            if (element instanceof PredicateAbstractState.ComputeAbstractionState) {
                PredicatePrecision precision = (PredicatePrecision)pPrecision;
                element = this.computeAbstraction((PredicateAbstractState.ComputeAbstractionState)element, precision);
            }
            PrecisionAdjustment.PrecisionAdjustmentResult precisionAdjustmentResult = PrecisionAdjustment.PrecisionAdjustmentResult.create(element, pPrecision, PrecisionAdjustment.Action.CONTINUE);
            return precisionAdjustmentResult;
        }
        finally {
            this.totalPrecTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PredicateAbstractState computeAbstraction(PredicateAbstractState.ComputeAbstractionState element, PredicatePrecision precision) throws CPAException, InterruptedException {
        AbstractionFormula abstractionFormula = element.getAbstractionFormula();
        PersistentMap abstractionLocations = element.getAbstractionLocationsOnPath();
        PathFormula pathFormula = element.getPathFormula();
        CFANode loc = element.getLocation();
        Integer newLocInstance = (Integer)MoreObjects.firstNonNull((Object)abstractionLocations.get((Object)loc), (Object)0) + 1;
        ++this.numAbstractions;
        this.logger.log(Level.FINEST, new Object[]{"Computing abstraction at instance", newLocInstance, "of node", loc, "in path."});
        this.maxBlockSize = Math.max(this.maxBlockSize, pathFormula.getLength());
        this.extractInvariants();
        BooleanFormula invariant = this.invariants.get(loc);
        if (invariant != null) {
            pathFormula = this.pathFormulaManager.makeAnd(pathFormula, invariant);
        }
        AbstractionFormula newAbstractionFormula = null;
        this.computingAbstractionTime.start();
        try {
            Set<AbstractionPredicate> preds = precision.getPredicates(loc, newLocInstance);
            newAbstractionFormula = this.formulaManager.buildAbstraction(loc, abstractionFormula, pathFormula, preds);
        }
        finally {
            this.computingAbstractionTime.stop();
        }
        if (newAbstractionFormula.isFalse()) {
            ++this.numAbstractionsFalse;
            this.logger.log(Level.FINEST, new Object[]{"Abstraction is false, node is not reachable"});
        }
        PathFormula newPathFormula = this.pathFormulaManager.makeEmptyPathFormula(pathFormula);
        if (invariant != null) {
            newPathFormula = this.pathFormulaManager.makeAnd(newPathFormula, invariant);
        }
        abstractionLocations = abstractionLocations.putAndCopy((Object)loc, (Object)newLocInstance);
        return PredicateAbstractState.mkAbstractionState(this.bfmgr, newPathFormula, newAbstractionFormula, (PersistentMap<CFANode, Integer>)abstractionLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractInvariants() throws CPAException {
        if (this.invariants != null) {
            return;
        }
        this.invariantGenerationTime.start();
        try {
            UnmodifiableReachedSet reached = this.invariantGenerator.get();
            if (reached.isEmpty()) {
                this.invariants = ImmutableMap.of();
                return;
            }
            this.invariants = new HashMap<CFANode, BooleanFormula>();
            for (AbstractState state : reached) {
                BooleanFormula invariant = AbstractStates.extractReportedFormulas(this.fmgr, state);
                if (this.bfmgr.isTrue(invariant)) continue;
                CFANode loc = AbstractStates.extractLocation(state);
                BooleanFormula oldInvariant = this.invariants.get(loc);
                if (oldInvariant != null) {
                    invariant = this.bfmgr.or(invariant, oldInvariant);
                }
                this.invariants.put(loc, invariant);
            }
            this.invariants = ImmutableMap.copyOf(this.invariants);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.invariants = ImmutableMap.of();
        }
        finally {
            this.invariantGenerator = null;
            this.invariantGenerationTime.stop();
        }
    }

    void setInitialLocation(CFANode initialLocation) {
        this.invariantGenerator.start(initialLocation);
    }
}

