/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateMapParser;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;

@Options(prefix="cpa.predicate")
public class PredicatePrecisionBootstrapper
implements StatisticsProvider {
    @Option(secure=true, name="abstraction.initialPredicates", description="get an initial map of predicates from a list of files (see source doc/examples/predmap.txt for an example)")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> predicatesFiles = ImmutableList.of();
    @Option(secure=true, description="always check satisfiability at end of block, even if precision is empty")
    private boolean checkBlockFeasibility = false;
    private final FormulaManagerView formulaManagerView;
    private final AbstractionManager abstractionManager;
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    private final PrecisionBootstrapStatistics statistics = new PrecisionBootstrapStatistics();

    public PredicatePrecisionBootstrapper(Configuration config, LogManager logger, CFA cfa, PathFormulaManager pathFormulaManager, AbstractionManager abstractionManager, FormulaManagerView formulaManagerView) throws InvalidConfigurationException {
        this.config = config;
        this.logger = logger;
        this.cfa = cfa;
        this.abstractionManager = abstractionManager;
        this.formulaManagerView = formulaManagerView;
        config.inject((Object)this);
    }

    private PredicatePrecision internalPrepareInitialPredicates() throws InvalidConfigurationException {
        PredicatePrecision result = PredicatePrecision.empty();
        if (this.checkBlockFeasibility) {
            result = result.addGlobalPredicates(Collections.singleton(this.abstractionManager.makeFalsePredicate()));
        }
        if (!this.predicatesFiles.isEmpty()) {
            PredicateMapParser parser = new PredicateMapParser(this.config, this.cfa, this.logger, this.formulaManagerView, this.abstractionManager);
            for (Path predicatesFile : this.predicatesFiles) {
                try {
                    result = result.mergeWith(parser.parsePredicates(predicatesFile));
                }
                catch (IOException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read predicate map from file");
                }
                catch (PredicatePersistenceUtils.PredicateParsingFailedException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read predicate map");
                }
            }
        }
        return result;
    }

    public PredicatePrecision prepareInitialPredicates() throws InvalidConfigurationException {
        PredicatePrecision result = this.internalPrepareInitialPredicates();
        this.statistics.addKeyValueStatistic("Init. global predicates", result.getGlobalPredicates().size());
        this.statistics.addKeyValueStatistic("Init. location predicates", result.getLocalPredicates().size());
        this.statistics.addKeyValueStatistic("Init. function predicates", result.getFunctionPredicates().size());
        return result;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    private static class PrecisionBootstrapStatistics
    extends AbstractStatistics {
        private PrecisionBootstrapStatistics() {
        }
    }
}

