/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpressionCollectorVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.StaticRefiner;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options(prefix="staticRefiner")
public class PredicateStaticRefiner
extends StaticRefiner {
    @Option(secure=true, description="Apply mined predicates on the corresponding scope. false = add them to the global precision.")
    private boolean applyScoped = true;
    @Option(secure=true, description="Add all assumtions along a error trace to the precision.")
    private boolean addAllErrorTraceAssumes = false;
    @Option(secure=true, description="Add all assumtions from the control flow automaton to the precision.")
    private boolean addAllControlFlowAssumes = false;
    @Option(secure=true, description="Add all assumtions along a error trace to the precision.")
    private boolean addAssumesByBoundedBackscan = true;
    @Option(secure=true, description="Dump CFA assume edges as SMTLIB2 formulas to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumePredicatesFile = null;
    private final PathFormulaManager pathFormulaManager;
    private final FormulaManagerView formulaManagerView;
    private final BooleanFormulaManager booleanManager;
    private final PredicateAbstractionManager predAbsManager;
    private final Optional<LoopStructure> loopStructure;
    private final Solver solver;
    private final CFA cfa;
    private Multimap<String, AStatementEdge> directlyAffectingStatements;

    public PredicateStaticRefiner(Configuration pConfig, LogManager pLogger, Solver pSolver, PathFormulaManager pPathFormulaManager, FormulaManagerView pFormulaManagerView, PredicateAbstractionManager pPredAbsManager, CFA pCfa) throws InvalidConfigurationException {
        super(pConfig, pLogger);
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.loopStructure = this.cfa.getLoopStructure();
        this.pathFormulaManager = pPathFormulaManager;
        this.predAbsManager = pPredAbsManager;
        this.solver = pSolver;
        this.formulaManagerView = pFormulaManagerView;
        this.booleanManager = this.formulaManagerView.getBooleanFormulaManager();
        if (this.assumePredicatesFile != null) {
            this.dumpAssumePredicate(this.assumePredicatesFile);
        }
    }

    private boolean isAssumeOnLoopVariable(AssumeEdge e) {
        if (!this.loopStructure.isPresent()) {
            return false;
        }
        Set<String> referenced = CIdExpressionCollectorVisitor.getVariablesOfExpression((CExpression)e.getExpression());
        for (String var : referenced) {
            if (!((LoopStructure)this.loopStructure.get()).getLoopExitConditionVariables().contains(var)) continue;
            return true;
        }
        return false;
    }

    private void buildDirectlyAffectingStatements() {
        if (this.directlyAffectingStatements != null) {
            return;
        }
        this.directlyAffectingStatements = LinkedHashMultimap.create();
        for (CFANode u : this.cfa.getAllNodes()) {
            ArrayDeque edgesToHandle = Queues.newArrayDeque(CFAUtils.leavingEdges(u));
            while (!edgesToHandle.isEmpty()) {
                CAssignment assign;
                CStatementEdge stmtEdge;
                CFAEdge e = (CFAEdge)edgesToHandle.pop();
                if (e instanceof MultiEdge) {
                    edgesToHandle.addAll(((MultiEdge)e).getEdges());
                    continue;
                }
                if (!(e instanceof CStatementEdge) || !((stmtEdge = (CStatementEdge)e).getStatement() instanceof CAssignment) || !((assign = (CAssignment)stmtEdge.getStatement()).getLeftHandSide() instanceof CIdExpression)) continue;
                String variable = ((CIdExpression)assign.getLeftHandSide()).getDeclaration().getQualifiedName();
                this.directlyAffectingStatements.put((Object)variable, (Object)stmtEdge);
            }
        }
    }

    private boolean isContradicting(AssumeEdge assume, AStatementEdge stmt) throws SolverException, CPATransferException, InterruptedException {
        BooleanFormula assumeFormula;
        BooleanFormula stmtFormula = this.pathFormulaManager.makeAnd(this.pathFormulaManager.makeEmptyPathFormula(), stmt).getFormula();
        BooleanFormula query = this.formulaManagerView.uninstantiate(this.booleanManager.and(stmtFormula, assumeFormula = this.pathFormulaManager.makeAnd(this.pathFormulaManager.makeEmptyPathFormula(), assume).getFormula()));
        boolean contra = this.solver.isUnsat(query);
        if (contra) {
            this.logger.log(Level.INFO, new Object[]{"Contradiction found ", query});
        }
        return contra;
    }

    private boolean hasContradictingOperationInFlow(AssumeEdge e) throws SolverException, CPATransferException, InterruptedException {
        this.buildDirectlyAffectingStatements();
        Set<String> referenced = CIdExpressionCollectorVisitor.getVariablesOfExpression((CExpression)e.getExpression());
        for (String varName : referenced) {
            Collection affectedByStmts = this.directlyAffectingStatements.get((Object)varName);
            for (AStatementEdge stmtEdge : affectedByStmts) {
                if (!this.isContradicting(e, stmtEdge)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<AssumeEdge> getAllNonLoopControlFlowAssumes() throws SolverException, CPATransferException, InterruptedException {
        HashSet<AssumeEdge> result = new HashSet<AssumeEdge>();
        for (CFANode u : this.cfa.getAllNodes()) {
            for (CFAEdge e : CFAUtils.leavingEdges(u)) {
                AssumeEdge assume;
                if (!(e instanceof AssumeEdge) || this.isAssumeOnLoopVariable(assume = (AssumeEdge)e) || !this.hasContradictingOperationInFlow(assume)) continue;
                result.add(assume);
            }
        }
        return result;
    }

    private Set<AssumeEdge> getAssumeEdgesAlongPath(UnmodifiableReachedSet reached, ARGState targetState) throws SolverException, CPATransferException, InterruptedException {
        HashSet<AssumeEdge> result = new HashSet<AssumeEdge>();
        Set<ARGState> allStatesOnPath = ARGUtils.getAllStatesOnPathsTo(targetState);
        for (ARGState s : allStatesOnPath) {
            CFANode u = AbstractStates.extractLocation(s);
            for (CFAEdge e : CFAUtils.leavingEdges(u)) {
                AssumeEdge assume;
                CFANode v = e.getSuccessor();
                Collection<AbstractState> reachedOnV = reached.getReached(v);
                boolean edgeOnTrace = false;
                for (AbstractState ve : reachedOnV) {
                    if (!allStatesOnPath.contains(ve)) continue;
                    edgeOnTrace = true;
                    break;
                }
                if (!edgeOnTrace || !(e instanceof AssumeEdge) || this.isAssumeOnLoopVariable(assume = (AssumeEdge)e) || !this.hasContradictingOperationInFlow(assume)) continue;
                result.add(assume);
            }
        }
        return result;
    }

    public PredicatePrecision extractPrecisionFromCfa(UnmodifiableReachedSet pReached, List<ARGState> abstractionStatesTrace, boolean atomicPredicates) throws SolverException, CPATransferException, InterruptedException {
        this.logger.log(Level.FINER, new Object[]{"Extracting precision from CFA..."});
        ArrayListMultimap functionPredicates = ArrayListMultimap.create();
        ArrayList globalPredicates = Lists.newArrayList();
        ARGState targetState = abstractionStatesTrace.get(abstractionStatesTrace.size() - 1);
        CFANode targetLocation = AbstractStates.extractLocation(targetState);
        HashSet<AssumeEdge> assumeEdges = new HashSet<AssumeEdge>();
        if (this.addAllControlFlowAssumes) {
            assumeEdges.addAll(this.getAllNonLoopControlFlowAssumes());
        } else {
            if (this.addAllErrorTraceAssumes) {
                assumeEdges.addAll(this.getAssumeEdgesAlongPath(pReached, targetState));
            }
            if (this.addAssumesByBoundedBackscan) {
                assumeEdges.addAll(this.getTargetLocationAssumes(Lists.newArrayList((Object[])new CFANode[]{targetLocation})).values());
            }
        }
        for (AssumeEdge assume : assumeEdges) {
            Collection<AbstractionPredicate> preds = this.assumeEdgeToPredicates(atomicPredicates, assume);
            boolean applyGlobal = true;
            if (this.applyScoped) {
                for (CIdExpression idExpr : this.getVariablesOfAssume(assume)) {
                    CSimpleDeclaration decl = idExpr.getDeclaration();
                    if (decl instanceof CVariableDeclaration) {
                        if (((CVariableDeclaration)decl).isGlobal()) continue;
                        applyGlobal = false;
                        continue;
                    }
                    if (!(decl instanceof CParameterDeclaration)) continue;
                    applyGlobal = false;
                }
            }
            if (applyGlobal) {
                this.logger.log(Level.FINEST, new Object[]{"Global predicates mined", preds});
                globalPredicates.addAll(preds);
                continue;
            }
            this.logger.log(Level.FINEST, new Object[]{"Function predicates mined", preds});
            String function = assume.getPredecessor().getFunctionName();
            functionPredicates.putAll((Object)function, preds);
        }
        this.logger.log(Level.FINER, new Object[]{"Extracting finished."});
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)ImmutableSetMultimap.of(), (Multimap<CFANode, AbstractionPredicate>)ArrayListMultimap.create(), (Multimap<String, AbstractionPredicate>)functionPredicates, globalPredicates);
    }

    private Collection<AbstractionPredicate> assumeEdgeToPredicates(boolean atomicPredicates, AssumeEdge assume) throws CPATransferException, InterruptedException {
        BooleanFormula relevantAssumesFormula = this.pathFormulaManager.makeAnd(this.pathFormulaManager.makeEmptyPathFormula(), assume).getFormula();
        ImmutableList preds = atomicPredicates ? this.predAbsManager.extractPredicates(relevantAssumesFormula) : ImmutableList.of((Object)this.predAbsManager.createPredicateFor(this.formulaManagerView.uninstantiate(relevantAssumesFormula)));
        return preds;
    }

    protected void dumpAssumePredicate(Path target) {
        try (Writer w = Files.openOutputFile((Path)target, (FileWriteMode[])new FileWriteMode[0]);){
            for (CFANode u : this.cfa.getAllNodes()) {
                for (CFAEdge e : CFAUtils.leavingEdges(u)) {
                    if (!(e instanceof AssumeEdge)) continue;
                    Collection<AbstractionPredicate> preds = this.assumeEdgeToPredicates(false, (AssumeEdge)e);
                    for (AbstractionPredicate p : preds) {
                        w.append(p.getSymbolicAtom().toString());
                        w.append("\n");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Interrupted, could not write assume predicates to file!");
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "IO exception! Could not write assume predicates to file!");
        }
        catch (CPATransferException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Transfer exception! Could not write assume predicates to file!");
        }
    }
}

