/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.predicate;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpressionCollectorVisitor;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAssumeStore;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

@Options(prefix="cpa.predicate")
public class PredicateTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, name="satCheck", description="maximum blocksize before a satisfiability check is done\n(non-negative number, 0 means never, if positive should be smaller than blocksize)")
    private int satCheckBlockSize = 0;
    @Option(secure=true, description="check satisfiability when a target state has been found (should be true)")
    private boolean targetStateSatCheck = true;
    final Timer postTimer = new Timer();
    final Timer satCheckTimer = new Timer();
    final Timer pathFormulaTimer = new Timer();
    final Timer strengthenTimer = new Timer();
    final Timer strengthenCheckTimer = new Timer();
    final Timer abstractionCheckTimer = new Timer();
    int numSatChecksFalse = 0;
    int numStrengthenChecksFalse = 0;
    private final LogManager logger;
    private final PredicateAbstractionManager formulaManager;
    private final PathFormulaManager pathFormulaManager;
    private final BlockOperator blk;
    private final PredicateAssumeStore assumeStore;
    private final Map<PredicateAbstractState, PathFormula> computedPathFormulae = new HashMap<PredicateAbstractState, PathFormula>();
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final AnalysisDirection direction;

    public PredicateTransferRelation(PredicateCPA pCpa, BlockOperator pBlk, Configuration config, AnalysisDirection pDirection) throws InvalidConfigurationException {
        config.inject((Object)this, PredicateTransferRelation.class);
        this.logger = pCpa.getLogger();
        this.formulaManager = pCpa.getPredicateManager();
        this.pathFormulaManager = pCpa.getPathFormulaManager();
        this.fmgr = pCpa.getSolver().getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.assumeStore = pCpa.getAssumesStore();
        this.blk = pBlk;
        this.direction = pDirection;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge edge) throws CPATransferException, InterruptedException {
        this.postTimer.start();
        try {
            BooleanFormula locAssume;
            PredicateAbstractState element = (PredicateAbstractState)pElement;
            CFANode loc = this.getAnalysisSuccesor(edge);
            CFANode predloc = this.getAnalysisPredecessor(edge);
            if (element.getAbstractionFormula().isFalse()) {
                Set set = Collections.emptySet();
                return set;
            }
            PathFormula pathFormula = this.convertEdgeToPathFormula(element.getPathFormula(), edge);
            this.logger.log(Level.ALL, new Object[]{"New path formula is", pathFormula});
            Optional<BooleanFormula> optLocAssume = this.assumeStore.getAssumeOnLocation(loc);
            if (optLocAssume.isPresent() && !this.bfmgr.isTrue(locAssume = (BooleanFormula)optLocAssume.get())) {
                pathFormula = this.pathFormulaManager.makeAnd(pathFormula, locAssume);
            }
            boolean doAbstraction = this.blk.isBlockEnd(loc, predloc, edge, pathFormula);
            Collection<? extends PredicateAbstractState> collection = this.createState(element, pathFormula, loc, doAbstraction);
            return collection;
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver failed during successor generation", e);
        }
        finally {
            this.postTimer.stop();
        }
    }

    private CFANode getAnalysisSuccesor(CFAEdge pEdge) {
        if (this.direction == AnalysisDirection.BACKWARD) {
            return pEdge.getPredecessor();
        }
        return pEdge.getSuccessor();
    }

    private CFANode getAnalysisPredecessor(CFAEdge pEdge) {
        if (this.direction == AnalysisDirection.BACKWARD) {
            return pEdge.getSuccessor();
        }
        return pEdge.getPredecessor();
    }

    private Collection<? extends PredicateAbstractState> createState(PredicateAbstractState oldState, PathFormula pathFormula, CFANode loc, boolean doAbstraction) throws SolverException, InterruptedException {
        if (doAbstraction) {
            return Collections.singleton(new PredicateAbstractState.ComputeAbstractionState(pathFormula, oldState.getAbstractionFormula(), loc, oldState.getAbstractionLocationsOnPath()));
        }
        return this.handleNonAbstractionFormulaLocation(pathFormula, oldState);
    }

    private Collection<PredicateAbstractState> handleNonAbstractionFormulaLocation(PathFormula pathFormula, PredicateAbstractState oldState) throws SolverException, InterruptedException {
        boolean satCheck = this.satCheckBlockSize > 0 && pathFormula.getLength() >= this.satCheckBlockSize;
        this.logger.log(Level.FINEST, new Object[]{"Handling non-abstraction location", satCheck ? "with satisfiability check" : ""});
        if (satCheck) {
            this.satCheckTimer.start();
            boolean unsat = this.formulaManager.unsat(oldState.getAbstractionFormula(), pathFormula);
            this.satCheckTimer.stop();
            if (unsat) {
                ++this.numSatChecksFalse;
                this.logger.log(Level.FINEST, new Object[]{"Abstraction & PathFormula is unsatisfiable."});
                return Collections.emptySet();
            }
        }
        return Collections.singleton(PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(pathFormula, oldState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathFormula convertEdgeToPathFormula(PathFormula pathFormula, CFAEdge edge) throws CPATransferException, InterruptedException {
        this.pathFormulaTimer.start();
        try {
            PathFormula pathFormula2 = this.pathFormulaManager.makeAnd(pathFormula, edge);
            return pathFormula2;
        }
        finally {
            this.pathFormulaTimer.stop();
        }
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, List<AbstractState> otherElements, CFAEdge edge, Precision pPrecision) throws CPATransferException, InterruptedException {
        this.strengthenTimer.start();
        try {
            Set<PredicateAbstractState> set;
            PredicateAbstractState element = (PredicateAbstractState)pElement;
            if (element.isAbstractionState()) {
                Set<PredicateAbstractState> set2 = Collections.singleton(element);
                return set2;
            }
            boolean errorFound = false;
            for (AbstractState lElement : otherElements) {
                if (lElement instanceof AssumptionStorageState) {
                    element = this.strengthen(element, (AssumptionStorageState)lElement);
                }
                if (lElement instanceof AbstractStateWithAssumptions) {
                    element = this.strengthen(edge.getSuccessor(), element, (AbstractStateWithAssumptions)lElement);
                }
                if (!AbstractStates.isTargetState(lElement)) continue;
                errorFound = true;
            }
            if (errorFound && this.targetStateSatCheck && (element = this.strengthenSatCheck(element, this.getAnalysisSuccesor(edge))) == null) {
                set = Collections.emptySet();
                return set;
            }
            set = Collections.singleton(element);
            return set;
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver failed during strengthen sat check", e);
        }
        finally {
            this.strengthenTimer.stop();
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private PredicateAbstractState strengthen(CFANode pNode, PredicateAbstractState pElement, AbstractStateWithAssumptions pAssumeElement) throws CPATransferException, InterruptedException {
        PathFormula pf = pElement.getPathFormula();
        for (AssumeEdge assumption : pAssumeElement.getAsAssumeEdges(pNode.getFunctionName())) {
            if (this.assumptionContainsProblemType(assumption)) continue;
            pf = this.convertEdgeToPathFormula(pf, assumption);
        }
        if (pf != pElement.getPathFormula()) {
            return this.replacePathFormula(pElement, pf);
        }
        return pElement;
    }

    private PredicateAbstractState strengthen(PredicateAbstractState pElement, AssumptionStorageState pElement2) {
        if (pElement2.isAssumptionTrue() || pElement2.isAssumptionFalse()) {
            return pElement;
        }
        String asmpt = pElement2.getAssumptionAsString().toString();
        PathFormula pf = this.pathFormulaManager.makeAnd(pElement.getPathFormula(), this.fmgr.parse(asmpt));
        return this.replacePathFormula(pElement, pf);
    }

    private PredicateAbstractState replacePathFormula(PredicateAbstractState oldElement, PathFormula newPathFormula) {
        if (oldElement instanceof PredicateAbstractState.ComputeAbstractionState) {
            CFANode loc = ((PredicateAbstractState.ComputeAbstractionState)oldElement).getLocation();
            return new PredicateAbstractState.ComputeAbstractionState(newPathFormula, oldElement.getAbstractionFormula(), loc, oldElement.getAbstractionLocationsOnPath());
        }
        assert (!oldElement.isAbstractionState());
        return PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(newPathFormula, oldElement);
    }

    private PredicateAbstractState strengthenSatCheck(PredicateAbstractState pElement, CFANode loc) throws SolverException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Checking for feasibility of path because error has been found"});
        this.strengthenCheckTimer.start();
        PathFormula pathFormula = pElement.getPathFormula();
        boolean unsat = this.formulaManager.unsat(pElement.getAbstractionFormula(), pathFormula);
        this.strengthenCheckTimer.stop();
        if (unsat) {
            ++this.numStrengthenChecksFalse;
            this.logger.log(Level.FINEST, new Object[]{"Path is infeasible."});
            return null;
        }
        this.logger.log(Level.FINEST, new Object[]{"Last part of the path is not infeasible."});
        AbstractionFormula abs = this.formulaManager.makeTrueAbstractionFormula(pathFormula);
        PathFormula newPathFormula = this.pathFormulaManager.makeEmptyPathFormula(pathFormula);
        PersistentMap abstractionLocations = pElement.getAbstractionLocationsOnPath();
        Integer newLocInstance = (Integer)MoreObjects.firstNonNull((Object)abstractionLocations.get((Object)loc), (Object)0) + 1;
        abstractionLocations = abstractionLocations.putAndCopy((Object)loc, (Object)newLocInstance);
        return PredicateAbstractState.mkAbstractionState(this.bfmgr, newPathFormula, abs, (PersistentMap<CFANode, Integer>)abstractionLocations);
    }

    boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws SolverException, CPATransferException, InterruptedException {
        PredicateAbstractState predicateElement = (PredicateAbstractState)pElement;
        PathFormula pathFormula = this.computedPathFormulae.get(predicateElement);
        if (pathFormula == null) {
            pathFormula = this.pathFormulaManager.makeEmptyPathFormula(predicateElement.getPathFormula());
        }
        boolean result = true;
        if (pSuccessors.isEmpty()) {
            this.satCheckTimer.start();
            PathFormula pFormula = this.convertEdgeToPathFormula(pathFormula, pCfaEdge);
            Collection<PredicateAbstractState> collection = this.handleNonAbstractionFormulaLocation(pFormula, predicateElement);
            for (AbstractState abstractState : collection) {
                PredicateAbstractState successor = (PredicateAbstractState)abstractState;
                if (this.formulaManager.unsat(successor.getAbstractionFormula(), successor.getPathFormula())) continue;
                result = false;
            }
            this.satCheckTimer.stop();
            return result;
        }
        for (AbstractState abstractState : pSuccessors) {
            PredicateAbstractState successor = (PredicateAbstractState)abstractState;
            if (successor.isAbstractionState()) {
                pathFormula = this.convertEdgeToPathFormula(pathFormula, pCfaEdge);
                this.abstractionCheckTimer.start();
                if (!this.formulaManager.checkCoverage(predicateElement.getAbstractionFormula(), pathFormula, successor.getAbstractionFormula())) {
                    result = false;
                }
                this.abstractionCheckTimer.stop();
                continue;
            }
            this.abstractionCheckTimer.start();
            if (!successor.getAbstractionFormula().equals(predicateElement.getAbstractionFormula())) {
                result = false;
            }
            this.abstractionCheckTimer.stop();
            PathFormula pathFormula2 = this.convertEdgeToPathFormula(pathFormula, pCfaEdge);
            PathFormula mergeWithPathFormula = this.computedPathFormulae.get(successor);
            if (mergeWithPathFormula != null) {
                this.computedPathFormulae.put(successor, this.pathFormulaManager.makeOr(mergeWithPathFormula, pathFormula2));
                continue;
            }
            this.computedPathFormulae.put(successor, pathFormula2);
        }
        return result;
    }

    private boolean assumptionContainsProblemType(AssumeEdge assumption) {
        CExpression expression = (CExpression)assumption.getExpression();
        CIdExpressionCollectorVisitor collector = new CIdExpressionCollectorVisitor();
        expression.accept(collector);
        for (CIdExpression var : collector.getReferencedIdExpressions()) {
            if (!(var.getExpressionType() instanceof CProblemType)) continue;
            return true;
        }
        return false;
    }
}

